@extends('admin.layout.app')
@section('style')

<script src="{{ asset('/adminto/assets/js/modernizr.min.js')}}"></script>
<style>
    .morris-hover.morris-default-style{
       position: absolute;
    }

</style>
@endsection
@section('content')

<div class="row">
    <div class="col-lg-3 col-md-6">
        <div class="card-box widget-user">
            <div>
                <div class="box-icon">
                    <i class="fa fa-plus-circle" aria-hidden="true"></i>
                </div>
                <div class="wid-u-info">
                    <h4 class="m-t-0 m-b-5"><a href="{{route('users.create')}}">إضافة عميل جديد </a></h4>
                </div>
            </div>
        </div>
    </div><!-- end col -->

    <div class="col-lg-3 col-md-6">
        <div class="card-box widget-user">
            <div>
                <div class="box-icon">
                    <i class="fa fa-plus-circle" aria-hidden="true"></i>
                </div>
                <div class="wid-u-info">
                    <h4 class="m-t-0 m-b-5"><a href="{{url('/dashboard/settings/admins')}}">إضافة مستخدم </a></h4>
                </div>
            </div>
        </div>
    </div><!-- end col -->

    <div class="col-lg-3 col-md-6">
        <div class="card-box widget-user">
            <div>
                <div class="box-icon">
                    <i class="fa fa-plus-circle" aria-hidden="true"></i>
                </div>
                <div class="wid-u-info">
                    <h4 class="m-t-0 m-b-5"><a href="{{route('products.create')}}">إضافة معدة للايجار</a></h4>
                </div>
            </div>
        </div>
    </div><!-- end col -->

    <div class="col-lg-3 col-md-6">
        <div class="card-box widget-user">
            <div>
                <div class="box-icon">
                    <i class="fa fa-plus-circle" aria-hidden="true"></i>
                </div>
                <div class="wid-u-info">
                    <h4 class="m-t-0 m-b-5"><a href="{{route('products.create')}}">إضافة معدة للبيع </a></h4>
                </div>
            </div>
        </div>
    </div><!-- end col -->
</div>
<!-- end row -->


<div class="row">
    <div class="col-lg-3 col-md-6">
        <div class="card-box">


            <h4 class="header-title m-t-0 m-b-30">عدد الطلبات </h4>

            <div class="widget-chart-1">
                <div class="widget-chart-box-1">
                    <i class="fa fa-hospital-o" aria-hidden="true"></i>
                </div>

                <div class="widget-detail-1">
                    <h2 class="p-t-10 m-b-0"> {{GetCount('orders','','')}} </h2>
                    <p class="text-muted">عدد عدد الطلبات </p>
                </div>
            </div>
        </div>
    </div><!-- end col -->

    <div class="col-lg-3 col-md-6">
        <div class="card-box">


            <h4 class="header-title m-t-0 m-b-30">عدد الطلبات تم استلامها </h4>

            <div class="widget-box-2">
                <div class="widget-detail-2">
                    <span class="badge badge-success pull-left m-t-20"><i class="fa fa-compress" aria-hidden="true"></i>
                    </span>
                    @php
                    $orders_total = GetCount('orders','', '');
                    $orders_accepted = GetCount('orders','status','accepted');
                    $percent = ($orders_total != 0)? round($orders_accepted / $orders_total * 100) : 0;
                    @endphp
                    <h2 class="m-b-0"> {{$orders_accepted}} </h2>
                    <p class="text-muted m-b-25">عدد الطلبات تم استلامها </p>
                </div>
                <div class="progress progress-bar-pink-alt progress-sm m-b-0">
                    <div class="progress-bar progress-bar-pink" role="progressbar" aria-valuenow="{{$percent}}"
                        aria-valuemin="0" aria-valuemax="100" style="width: {{$percent}}%;">
                        <span class="sr-only">{{$percent}}% Complete</span>
                    </div>
                </div>
            </div>
        </div>
    </div><!-- end col -->

    <div class="col-lg-3 col-md-6">
        <div class="card-box">


            <h4 class="header-title m-t-0 m-b-30">عدد الطلبات الملغية </h4>

            <div class="widget-chart-1">
                <div class="widget-chart-box-1">
                    @php
                    $orders_total = GetCount('orders','', '');
                    $orders_canceled = GetCount('orders','status','canceled');
                    $percent = ($orders_total != 0)? round($orders_canceled / $orders_total * 100) : 0;
                    @endphp
                    <input data-plugin="knob" data-width="80" data-height="80" data-fgColor="#ffbd4a"
                        data-bgColor="#FFE6BA" value="{{$percent}}" data-skin="tron" data-angleOffset="180"
                        data-readOnly=true data-thickness=".15" />
                </div>
                <div class="widget-detail-1">
                    <h2 class="p-t-10 m-b-0"> {{$orders_canceled}} </h2>
                    <p class="text-muted">عدد الطلبات الملغية </p>
                </div>
            </div>
        </div>
    </div><!-- end col -->

    <div class="col-lg-3 col-md-6">
        <div class="card-box">


            <h4 class="header-title m-t-0 m-b-30">عدد الطلبات المنتهيه </h4>

            <div class="widget-box-2">
                <div class="widget-detail-2">
                    <span class="badge badge-pink pull-left m-t-20"><i class="fa fa-list-ol" aria-hidden="true"></i>
                    </span>
                    <h2 class="m-b-0"> {{GetCount('orders','status','finished')}} </h2>
                    <p class="text-muted m-b-25"> اجمالى عدد الطلبات المنتهيه </p>
                </div>

            </div>
        </div>
    </div><!-- end col -->

</div>
<!-- end row -->

<div class="row">
    <div class="col-lg-3 col-md-6">
        <div class="card-box">


            <h4 class="header-title m-t-0 m-b-30">عدد العملاء</h4>

            <div class="widget-chart-1">
                <div class="widget-chart-box-1">
                    <i class="fa fa-users" aria-hidden="true"></i>
                </div>

                <div class="widget-detail-1">
                    <h2 class="p-t-10 m-b-0">{{GetCount('users','','')}} </h2>
                    <p class="text-muted">مجموع عدد العملاء </p>
                </div>
            </div>
        </div>
    </div><!-- end col -->

    <div class="col-lg-3 col-md-6">
        <div class="card-box">


            <h4 class="header-title m-t-0 m-b-30">عدد حسابات البيزنس </h4>

            <div class="widget-chart-1">
                <div class="widget-chart-box-1">
                    <i class="fa fa-handshake-o" aria-hidden="true"></i>
                </div>

                <div class="widget-detail-1">
                    <h2 class="p-t-10 m-b-0">{{GetCount('business_accounts','','')}} </h2>
                    <p class="text-muted">مجموع عدد حسابات البيزنس </p>
                </div>
            </div>
        </div>
    </div><!-- end col -->

    <div class="col-lg-3 col-md-6">
        <div class="card-box">


            <h4 class="header-title m-t-0 m-b-30">عدد أقسام المعدات</h4>

            <div class="widget-chart-1">
                <div class="widget-chart-box-1">
                    <i class="fa fa-building-o" aria-hidden="true"></i>
                </div>
                <div class="widget-detail-1">
                    <h2 class="p-t-10 m-b-0"> {{GetCount('categories','','')}} </h2>
                    <p class="text-muted">إجمالي عدد الأقسام</p>
                </div>
            </div>
        </div>
    </div><!-- end col -->

    <div class="col-lg-3 col-md-6">
        <div class="card-box">


            <h4 class="header-title m-t-0 m-b-30">عدد مهام المعدات</h4>

            <div class="widget-chart-1">
                <div class="widget-chart-box-1">
                    <i class="fa fa-building-o" aria-hidden="true"></i>
                </div>
                <div class="widget-detail-1">
                    <h2 class="p-t-10 m-b-0"> {{GetCount('missions','','')}} </h2>
                    <p class="text-muted">إجمالي عدد المهام</p>
                </div>
            </div>
        </div>
    </div><!-- end col -->


</div>
<!-- end row -->

<div class="row">
    <div class="col-lg-4">
        <div class="card-box">


            <h4 class="header-title m-t-0">طلبات التأجير</h4>

            <div class="widget-chart text-center">
                <div id="morris-donut-example" style="height: 245px;"></div>
                <ul class="list-inline chart-detail-list m-b-0">
                    <li>
                        <h5 style="color: #ff8acc;"><i class="fa fa-circle m-r-5"></i> منتهيه</h5>
                    </li>
                    <li>
                        <h5 style="color: #5b69bc;"><i class="fa fa-circle m-r-5"></i> تم الاستلام</h5>
                    </li>
                    <li>
                        <h5 style="color: #35b8e0;"><i class="fa fa-circle m-r-5"></i> ملغاه </h5>
                    </li>
                </ul>
            </div>
        </div>
    </div><!-- end col -->

    <div class="col-lg-4">
        <div class="card-box">

            <h4 class="header-title m-t-0">العملاء على التطبيق</h4>
            <div id="morris-bar-example" style="height: 280px;"></div>
        </div>
    </div><!-- end col -->

    <div class="col-lg-4">
        <div class="card-box">

            <h4 class="header-title m-t-0">أرباح طلبات التأجير </h4>
            <div id="morris-line-example" style="height: 280px;"></div>
        </div>
    </div><!-- end col -->

</div>
<!-- end row -->


<div class="row">

    <div class="col-lg-12">
        <div class="card-box">

            <h4 class="header-title m-t-0 m-b-30"> احدث طلبات التأجير </h4>


            <div class="row">
                <form role="form" action="" method="GET">
                    <div class="col-lg-12">
                        <div class="f-box m-b-15">
                            <h4 class="header-title m-t-0 m-b-15">فلترة الطلبات </h4>

                            <div class="f-box-sm">

                                <label for="">حاله الطلب </label>
                                {!! Form::select("status",OrderStatus(),(array_key_exists('status', $search))?
                                $search['status'] : null,['class'=>"form-control select2 "])!!}

                            </div>

                            {{-- <div class="f-box-sm m-b-15">

                            <label for="">نوع المعدة </label>
                            {!! Form::select("mission_id",MissionsList(),(array_key_exists('mission_id', $search))? $search['mission_id'] : null,['class'=>"form-control select2 "])!!}
                                                    
                        </div> --}}
                        </div>
                    </div>


                    <div class="col-lg-12">
                        <div class="f-box m-b-15">
                            <div class="form-group">
                                <label class="control-label" for="example-input1-group2">عرض الطلبات خلال ( عدد الأيام
                                    )</label>
                                <div class="input-group">

                                    <input type="text" id="example-input1-group2" name="days"
                                        value="{{(array_key_exists('days', $search))? $search['days'] : ''}}"
                                        class="form-control" placeholder="أدخل عدد الأيام هنا">
                                    <span class="input-group-btn">
                                        <button type="submit" class="btn waves-effect waves-light btn-primary"><i
                                                class="fa fa-search"></i></button>
                                    </span>
                                </div>
                            </div>
                        </div>
                    </div>
                </form>
            </div>

            <div class=" table-custom" style="overflow: hidden;">
                <table class=" datatable-buttons table table-striped table-bordered ">
                    <thead>
                        <tr>
                            <th>رقم الطلب </th>
                            <th>اسم العميل </th>
                            <th> رقم الجوال </th>
                            <th> السعر الكلى </th>
                            <th>تاريخ الطلب</th>
                            <th>الحالة </th>
                            <th>نوع الطلب </th>
                            <th>عرض التفاصيل</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($orders as $item)

                        <tr>
                            <td> {{$item->id}} </td>
                            <td> {{ $item->User->name ?? '' }} </td>
                            <td> {{ $item->User->phone ?? '' }} </td>
                            <td> {{ $item->total_price ?? '' }} </td>
                            <td> {{ $item->created_at ?? '' }} </td>
                            <td> {{__('words.'.$item->status)}} </td>
                            <td> {{__('words.'.$item->OrderItem()->first()->product_type ?? '')}} </td>

                            <td><a href="{{route('orders.show',$item->id)}}"><i class="fa fa-eye  m-r-10"
                                        style="color: #188ae2;"></i> عرض</a></td>

                        </tr>
                        @endforeach




                    </tbody>
                </table>
            </div>
        </div>
    </div><!-- end col -->

</div>
<!-- end row -->

@if(false)
<div class="row">
    <div class="col-lg-3 col-md-6">
        <div class="card-box widget-user">
            <div>
                <div class="box-icon">
                    <i class="fa fa-plus-circle" aria-hidden="true"></i>
                </div>
                <div class="wid-u-info">
                    <h4 class="m-t-0 m-b-5"><a href="{{url('/dashboard/settings/admins')}}"> إضافه مستخدم </a></h4>
                </div>
            </div>
        </div>
    </div><!-- end col -->
    <div class="col-lg-3 col-md-6">
        <div class="card-box widget-user">
            <div>
                <div class="box-icon">
                    <i class="fa fa-plus-circle" aria-hidden="true"></i>
                </div>
                <div class="wid-u-info">
                    <h4 class="m-t-0 m-b-5"><a href="{{url('/dashboard/users/create')}}"> إضافه عميل </a></h4>
                </div>
            </div>
        </div>
    </div><!-- end col -->
    <div class="col-lg-3 col-md-6">
        <div class="card-box widget-user">
            <div>
                <div class="box-icon">
                    <i class="fa fa-plus-circle" aria-hidden="true"></i>
                </div>
                <div class="wid-u-info">
                    <h4 class="m-t-0 m-b-5"><a href="{{url('/dashboard/drivers/create')}}"> إضافه سائق </a></h4>
                </div>
            </div>
        </div>
    </div><!-- end col -->

    <div class="col-lg-3 col-md-6">
        <div class="card-box widget-user">
            <div>
                <div class="box-icon">
                    <i class="zmdi zmdi-notifications-none" aria-hidden="true"></i>
                </div>
                <div class="wid-u-info">
                    <h4 class="m-t-0 m-b-5"><a href="{{url('/dashboard/notifications')}}">ارسال اشعار </a></h4>
                </div>
            </div>
        </div>
    </div><!-- end col -->
</div>
<!-- end row -->

<div class="row">
    <div class="col-lg-4">
        <div class="card-box">
            <h4 class="header-title m-t-0">العملاء على التطبيق</h4>
            <div id="morris-bar-example" style="height: 280px;"></div>
        </div>
    </div><!-- end col -->

    <div class="col-lg-4">
        <div class="card-box">
            <h4 class="header-title m-t-0">الطلبات بالشهر </h4>
            <div id="morris-line-example" style="height: 280px;"></div>
        </div>
    </div><!-- end col -->

</div>
<!-- end row -->


@endif


@endsection
@section('script')


<!-- jQuery  -->
<script src="{{ asset('/adminto/assets/js/jquery.min.js')}}"></script>
<script src="{{ asset('/adminto/assets/js/bootstrap-rtl.min.js')}}"></script>
<script src="{{ asset('/adminto/assets/js/detect.js')}}"></script>
<script src="{{ asset('/adminto/assets/js/fastclick.js')}}"></script>

<script src="{{ asset('/adminto/assets/js/jquery.slimscroll.js')}}"></script>
<script src="{{ asset('/adminto/assets/js/jquery.blockUI.js')}}"></script>
<script src="{{ asset('/adminto/assets/js/waves.js')}}"></script>
<script src="{{ asset('/adminto/assets/js/wow.min.js')}}"></script>
<script src="{{ asset('/adminto/assets/js/jquery.nicescroll.js')}}"></script>
<script src="{{ asset('/adminto/assets/js/jquery.scrollTo.min.js')}}"></script>

<!-- KNOB JS -->
<!--[if IE]>
        <script type="text/javascript" src="{{ asset('/adminto/assets/plugins/jquery-knob/excanvas.js')}}"></script>
        <![endif]-->
<script src="{{ asset('/adminto/assets/plugins/jquery-knob/jquery.knob.js')}}"></script>

<!--Morris Chart-->
<script src="{{ asset('/adminto/assets/plugins/morris/morris.min.js')}}"></script>
<script src="{{ asset('/adminto/assets/plugins/raphael/raphael-min.js')}}"></script>

<!-- Dashboard init -->
<!-- <script src="{{ asset('/adminto/assets/pages/jquery.dashboard.js')}}"></script> -->

<!-- Datatables-->
<script src="{{ asset('/adminto/assets/plugins/datatables/jquery.dataTables.min.js')}}"></script>
<script src="{{ asset('/adminto/assets/plugins/datatables/dataTables.bootstrap.js')}}"></script>
<script src="{{ asset('/adminto/assets/plugins/datatables/dataTables.buttons.min.js')}}"></script>
<script src="{{ asset('/adminto/assets/plugins/datatables/buttons.bootstrap.min.js')}}"></script>
<script src="{{ asset('/adminto/assets/plugins/datatables/jszip.min.js')}}"></script>
<script src="{{ asset('/adminto/assets/plugins/datatables/pdfmake.min.js')}}"></script>
<script src="{{ asset('/adminto/assets/plugins/datatables/vfs_fonts.js')}}"></script>
<script src="{{ asset('/adminto/assets/plugins/datatables/buttons.html5.min.js')}}"></script>
<script src="{{ asset('/adminto/assets/plugins/datatables/buttons.print.min.js')}}"></script>
<script src="{{ asset('/adminto/assets/plugins/datatables/dataTables.fixedHeader.min.js')}}"></script>
<script src="{{ asset('/adminto/assets/plugins/datatables/dataTables.keyTable.min.js')}}"></script>
<script src="{{ asset('/adminto/assets/plugins/datatables/dataTables.responsive.min.js')}}"></script>
<script src="{{ asset('/adminto/assets/plugins/datatables/responsive.bootstrap.min.js')}}"></script>
<script src="{{ asset('/adminto/assets/plugins/datatables/dataTables.scroller.min.js')}}"></script>
<script src="{{ asset('/adminto/assets/plugins/bootstrap-datepicker/dist/js/bootstrap-datepicker.min.js')}}"></script>
<!-- Datatable init js -->
<script src="{{ asset('/adminto/assets/pages/datatables.init.js')}}"></script>

<!-- Plugins Js -->
<script src="{{ asset('/adminto/assets/plugins/switchery/switchery.min.js')}}"></script>
<script src="{{ asset('/adminto/assets/plugins/bootstrap-tagsinput/dist/bootstrap-tagsinput.min.js')}}"></script>
<script type="text/javascript" src="{{ asset('/adminto/assets/plugins/multiselect/js/jquery.multi-select.js')}}">
</script>
<script type="text/javascript" src="{{ asset('/adminto/assets/plugins/jquery-quicksearch/jquery.quicksearch.js')}}">
</script>
<script src="{{ asset('/adminto/assets/plugins/select2/dist/js/select2.min.js')}}" type="text/javascript"></script>
<script src="{{ asset('/adminto/assets/plugins/bootstrap-touchspin/dist/jquery.bootstrap-touchspin.min.js')}}"
    type="text/javascript"></script>
<script src="{{ asset('/adminto/assets/plugins/bootstrap-inputmask/bootstrap-inputmask.min.js')}}"
    type="text/javascript"></script>
<script src="{{ asset('/adminto/assets/plugins/moment/moment.js')}}"></script>
<script src="{{ asset('/adminto/assets/plugins/timepicker/bootstrap-timepicker.min.js')}}"></script>
<script src="{{ asset('/adminto/assets/plugins/mjolnic-bootstrap-colorpicker/dist/js/bootstrap-colorpicker.min.js')}}">
</script>
<script src="{{ asset('/adminto/assets/plugins/bootstrap-datepicker/dist/js/bootstrap-datepicker.min.js')}}"></script>
<script src="{{ asset('/adminto/assets/plugins/bootstrap-daterangepicker/daterangepicker.js')}}"></script>
<script src="{{ asset('/adminto/assets/plugins/bootstrap-maxlength/bootstrap-maxlength.min.js')}}"
    type="text/javascript"></script>


<!-- App js -->
<script src="{{ asset('/adminto/assets/js/jquery.core.js')}}"></script>
<script src="{{ asset('/adminto/assets/js/jquery.app.js')}}"></script>

<script type="text/javascript">
    ! function ($) {
        "use strict";

        var Dashboard1 = function () {
            this.$realData = []
        };

        //creates Bar chart
        Dashboard1.prototype.createBarChart = function (element, data, xkey, ykeys, labels, lineColors) {
                Morris.Bar({
                    element: element,
                    data: data,
                    xkey: xkey,
                    ykeys: ykeys,
                    labels: labels,
                    hideHover: 'auto',
                    resize: true, //defaulted to true
                    gridLineColor: '#eeeeee',
                    barSizeRatio: 0.2,
                    barColors: lineColors
                });
            },

            //creates line chart
            Dashboard1.prototype.createLineChart = function (element, data, xkey, ykeys, labels, opacity, Pfillcolor,
                Pstockcolor, lineColors) {
                Morris.Line({
                    element: element,
                    data: data,
                    xkey: xkey,
                    ykeys: ykeys,
                    labels: labels,
                    fillOpacity: opacity,
                    pointFillColors: Pfillcolor,
                    pointStrokeColors: Pstockcolor,
                    behaveLikeLine: true,
                    gridLineColor: '#eef0f2',
                    hideHover: 'auto',
                    resize: true, //defaulted to true
                    pointSize: 0,
                    lineColors: lineColors
                });
            },

            //creates Donut chart
            Dashboard1.prototype.createDonutChart = function (element, data, colors) {
                Morris.Donut({
                    element: element,
                    data: data,
                    resize: true, //defaulted to true
                    colors: colors
                });
            },


            Dashboard1.prototype.init = function () {

                //creating bar chart
                // var $barData  = [
                //     { y: '2010', a: 75 },
                //     { y: '2011', a: 42 },
                //     { y: '2012', a: 75 },
                //     { y: '2013', a: 38 },
                //     { y: '2014', a: 19 },
                //     { y: '2015', a: 93 }
                // ];
                var $barData = JSON.parse('{!! $users_chart !!}');
                this.createBarChart('morris-bar-example', $barData, 'y', ['a'], ['عدد العملاء'], ['#188ae2']);

                //create line chart
                // var $data  = [
                //     { y: '2008', a: 50, b: 0 },
                //     { y: '2009', a: 75, b: 50 },
                //     { y: '2010', a: 30, b: 80 },
                //     { y: '2011', a: 50, b: 50 },
                //     { y: '2012', a: 75, b: 10 },
                //     { y: '2013', a: 50, b: 40 },
                //     { y: '2014', a: 75, b: 50 },
                //     { y: '2015', a: 100, b: 70 }
                //   ];
                var $data = JSON.parse('{!! $orders_chart !!}');
                this.createLineChart('morris-line-example', $data, 'y', ['a', 'b'], ['Series A', 'Series B'], ['0.9'], [
                    '#ffffff'
                ], ['#999999'], ['#10c469', '#188ae2']);

                //creating donut chart
                var $donutData = [{
                        label: "منتهية",
                        value: parseInt("{{GetCount('orders','status','finished')}}")
                    },
                    {
                        label: "تم الاستلام",
                        value: parseInt(
                            "{{\App\Models\Order::whereNotIn('status', ['init', 'canceled'])->count() }}")
                    },
                    {
                        label: "ملغاه",
                        value: parseInt("{{GetCount('orders','status','canceled')}}")
                    }
                ];
                this.createDonutChart('morris-donut-example', $donutData, ['#ff8acc', '#5b69bc', "#35b8e0"]);
            },
            //init
            $.Dashboard1 = new Dashboard1, $.Dashboard1.Constructor = Dashboard1
    }(window.jQuery),

    //initializing 
    function ($) {
        "use strict";
        $.Dashboard1.init();
    }(window.jQuery);

</script>

@endsection
