<?php
namespace App\Traits\Admin;

use App\Http\Controllers\Api\FCMController;
use App\Notifications\GeneralNotification;
use Illuminate\Http\Request;
use App\Models\Order;
use App\Models\Driver;
use App\Models\PriceList;
use DB;
use Carbon\Carbon;
use App\Models\Admin;
use App\Notifications\AdminNotification;

trait OrderOperations
{
  

    /**
     * Register a New .
     *
     * @param $request
     * @return \App\
     */
    public function register ($request)
    {
        $data = $request->all();
        if ($request->hasFile('image')) {
            $data['image'] = uploadImage($request->file('image'));
        }
        DB::beginTransaction();
        $Order = Order::create($data);
        $Order->client_code = mt_rand(100000,999999);
        $Order->save();
        DB::commit();
        return $Order;
    }


    /**
     * Update Record
     * @param $truck
     * @param $request
     */
    public function UpdateRecords(Order $Order,$request)
    {
        // return dd(HelpersendSMS('0502375383', "Client Code: ".$Order->client_code));
        $data = $request->all();
        if ($request->hasFile('image')) {
            @unlink(public_path('/cdn/'.$Order->image));
            // 
            $data['image'] = uploadImage($request->file('image'));
        }
        if($request->has('client_code_verify'))
        {
            if($request->get('client_code_verify') == $Order->client_code)
            {
                $request->merge([
                "status" => "processing"
                ]);
                $Order->client_code_v = '1';
                $Order->status = 'processing';
                $Order->save();
                return $Order;
                
            }elseif(!empty($request->get('client_code_verify'))){
                return 0;
            }
        }
        if ($request->has('status') && $request->get('status') != 'init' && $request->get('status') != $Order->status) {
            // check order type start
            
            // check order type end
            // send notification
            
            if( $Order->User->lang == 'ar')
                {
                    $title = "تم تغيير حالة الطلب رقم #". $Order->id;
                    $content = "تم تغيير حالة الطلب رقم #". $Order->id . ' الي '.trans('words.'.$request->status);

                }else{
                    $title = " status has been changed for order #".$Order->id;
                    $content = " status has been changed for order #".$Order->id . ' to '. trans('wordsen.'.$request->status);
                }
                $type = "order_details";
                
                $title_ar = "تم تغيير حالة الطلب رقم #".$Order->id;
                $title_en = " status has been changed for order #".$Order->id;
                $content_ar = "تم تغيير حالة الطلب رقم #".$Order->id . ' الي '.trans('words.'.$request->status);
                $content_en = " status has been changed for order #".$Order->id . ' to '. trans('wordsen.'.$request->status);
                $activity = "order_details";
                $data2 = [
                    'order' => $Order,
                    'title_ar' => $title_ar,
                    'title_en' => $title_en,
                    'content_ar' => $content_ar,
                    'content_en' => $content_en,
                    'type' => $type,
                ];
                $notifiable = $Order->User()->first();
                $token = $notifiable->PlayerId()->pluck('player_id')->toArray();
                FCMController::Push($title, $content,$token,$data2);
                $notifiable->notify(new GeneralNotification($title, $content, $type, $data2, $activity) );
                
                // send notification to admin start
                $admin = Admin::first();
                $admin->notify(new AdminNotification($content_ar . $Order->id , route('orders.show', $Order->id)));
                // send notification to admin end
                
                // send notification end
                    // $Order->OrderLog()->create([
                    //     'created_by_type' => 'admin',
                    //     'created_by_id' => auth()->id(),
                    //     'key' => 'status_changed',
                    //     'notes' => trans('words.order status has been changed by', ['by_name' => auth()->user()->name, 'status' => trans('words.'.$request->status) ]),
                    // ]); 
            }
        $Order->update($data);
        return $Order;
    }
    /**
     * delete Record
     * @param $truck
     * @param $request
     */
    public function DeleteRecord($id)
    {
        //
    }
    
    public function sendSMS($destinations, $message)
    {
        // $username = "Aljeri";		    // اسم المستخدم الخاص بك في الموقع
        // $password = "SmSaljeri_1330"; 		// كلمة المرور الخاصة بك
        // $destinations = $destinations; //الارقام المرسل لها  ,, يتم وضع فاصلة بين الارقام المراد الارسال لها
        // $message = $message;      // محتوى الرسالة
        // $sender = "JTC";         // اسم المرسل الخاص بك المفعل  في الموقع
        // $url = "http://www.jawalbsms.ws/api.php/sendsms?user=$username&pass=$password&to=$destinations&message=$message&sender=$sender";

        // $ch = curl_init($url); // init the curl with jawalb API url
        // curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        // curl_setopt($ch, CURLOPT_HEADER, 0);
        // $data = curl_exec($ch);  //run curl api call, on success curl call, $data will contain the API call response
        // curl_close($ch);
        // // print_r($data);

        $postRequest = array(
            'body' => $message,
            'sender' => 'OTC',
            'recipients' => [
                $destinations
            ]
        );

        $cURLConnection = curl_init('https://api.taqnyat.sa/v1/messages');
        curl_setopt($cURLConnection, CURLOPT_POSTFIELDS, json_encode($postRequest));
        curl_setopt($cURLConnection, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($cURLConnection, CURLOPT_HTTPHEADER, array(
            'Authorization: Bearer 2097057f9ffbb1836fa24795c10e7915',
            'Content-Type: application/json'
        ));


        $apiResponse = curl_exec($cURLConnection);
        curl_close($cURLConnection);

        // $apiResponse - available data from the API request
        $jsonArrayResponse = json_decode($apiResponse);
        return $jsonArrayResponse;
    }
}