<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class VipCart extends Model
{
    protected $table='vip_carts';
    protected $fillable = [
        'quantity', 'category_id', 'user_id', 'product_name',
    ];
    protected $appends = [
        'category_name',
    ];

    public function User()
    {
        return $this->belongsTo(User::class,'user_id');
    }

    public function Category()
    {
        return $this->belongsTo(Category::class,'category_id');
    }
    public function getCategoryNameAttribute()
    {
        return ($this->Category()->first())? $this->Category()->first()->name : '';
    }
}
