<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Carbon\Carbon;

class Cart extends Model
{
    protected $table='carts';
    protected $fillable = [
        'quantity', 'product_id', 'user_id',  'product_type', 'rent_type', 'date_from', 'date_to', 'time_from', 'time_to', 'uuid', 'gasoline_cost', 'move_cost',
        'housing_cost', 'city_id', 'latitude', 'longitude', 'months', 'coupon'
    ];
    protected $appends = [ 'rent_days', 'product_price', 'vat', 'vat_cost' ];

    public function User()
    {
        return $this->belongsTo(User::class,'user_id');
    }
    public function City()
    {
        return $this->belongsTo(City::class,'city_id');
    }

    public function Product()
    {
        return $this->belongsTo(Product::class,'product_id');
    }
    
    public function CartItemDay()
    {
        return $this->Hasmany(CartItemDay::class,'cart_id');
    }
    public function getRentDaysAttribute()
    {
        
        return $this->CartItemDay()->get();
    }
    public function getVatAttribute()
    {
        return round((float)getSettingValue('tax'),2);
    }
    public function getVatCostAttribute()
    {
        return round((float)getSettingValue('tax'),2) / 100 * $this->product_price;
    }
    public function getProductPriceAttribute()
    {
        $total_price = 0;
        $product = $this->Product()->first();
            if ($product) {
                
                if ($this->product_type == 'rent') {
                    // 
                    if ($this->rent_type == 'day') {
                        $total_price += $this->CartItemDay()->count() * $product->daily_price;  
                    }elseif ($this->rent_type == 'month') {
                        $total_price += $this->month * $product->price;  
                    }  else {
                        if ($this->CartItemDay()->first()) {
                            
                            $from = Carbon::createFromFormat('Y-m-d H:s:i', $this->CartItemDay()->first()->day_date . ' ' . $this->CartItemDay()->first()->time_from);
                            $to = Carbon::createFromFormat('Y-m-d H:s:i', $this->CartItemDay()->first()->day_date . ' ' . $this->CartItemDay()->first()->time_to);
                            $diff_in_hours = $to->diffInHours($from);
                            $total_price += $diff_in_hours * $product->hour_price; 
                        }
                    }
                    
                }else{
                    $total_price += $this->quantity * $this->Product->price;
                }
                // $move_cost += $product->move_cost;
            }
            return $total_price;
        // return $this->Product->price ?? 0;
    }
}
