<?php

use Carbon\Carbon;

function getSettingValue($key)
{
    $row = \App\Models\Setting::where('key', $key)->first();
    if ($row) {
        return $row->value;
    }
    return '';
}
function getHoursCount(){
    if (getSettingValue('start_time') && getSettingValue('end_time')) {

        $from = Carbon::parse('2021-08-19 '. getSettingValue('start_time') );
        $to = Carbon::parse('2021-08-19 '. getSettingValue('end_time') );
        return (int)$to->diffInHours($from);
    }
    return 1;
}
function PriceWithVat($price, $round=2)
{
    // return $price;
    return round($price * (getSettingValue('tax') / 100), $round) + $price;
}

function uploadFile($request)
{
    // $filename = rand(99999, 99999999) . time(). '.' . $request->file('image')->getClientOriginalExtension();
    $filename = rand(99999, 99999999) . time(). '.jpg';
    // $request->file('image')->move(public_path('/cdn'), $filename);
    $img = \Image::make($request->file('image'))->encode('jpg', 30);
    $img->save(public_path('/cdn/'. $filename));
    // $profileimg  = $filename;
    return $filename;
}

function uploadImage($file, $path = "")
{
    // $filename = rand(99999, 99999999) . time(). '.' . $file->getClientOriginalExtension();
    $filename = rand(99999, 99999999) . time(). '.jpg';
    $img = \Image::make($file)->encode('jpg', 30);
    if($path != '')
    if (!file_exists(public_path('/cdn/'.$path))) {
        mkdir(public_path('/cdn/'.$path), 0777, true);
    }
    $img->save(public_path('/cdn/'.$path. $filename));
    // $file->move(public_path('/cdn'), $filename);
    // $profileimg  = $filename;
    return $path.$filename;
}
function uploadFiless($file, $path = "")
{
    $filename = rand(99999, 99999999) . time(). '.' . $file->getClientOriginalExtension();

    $file->move(public_path('/cdn'), $filename);
    $profileimg  = $filename;
    return $path.$filename;
}

function FileHtmlContent($file)
{
    // return $file;
    try{
        if(strpos($file, url('/')) !== false) {
            $file = str_replace( url('/'). '/cdn/', '', $file);
        }
        $file2 = public_path('/cdn/'.$file);
        $type = exif_imagetype($file2);
        switch($type) {
          case IMG_GIF:
            $type = 'image/gif';
            break;
          case IMG_JPG:
            $type = 'image/jpg';
            break;
          case IMG_JPEG:
            $type = 'image/jpeg';
            break;
          case IMG_PNG:
            $type = 'image/png';
            break;
          case IMG_WBMP:
            $type = 'image/wbmp';
            break;
          case IMG_XPM:
            $type = 'image/xpm';
            break;
          default:
            $type = 'unknown';
        }

    }catch(\Exception $e){
        return '';
    }
    $file = GetImage($file);
    if(    str_contains($type, 'image')    )
    {
        $type = 'image';
    }
    switch ($type) {
        case 'image':
            return '<img src="'.$file.'" class="image-responsive" style="height:150px; width:100%;" />';
            break;

        default:
            return '<center><a href="'.$file.'"><i class="fa fa-file-text" aria-hidden="true" style=font-size:124px;></i>
</a></center>';
            break;
    }
}

function uploadImageBase64($file)
{

    // $filename = rand(99999, 99999999) . time(). '.' . $file->getClientOriginalExtension();
    $image = $file;  // your base64 encoded
    $image = str_replace('data:image/png;base64,', '', $image);
    $image = str_replace(' ', '+', $image);
    // $filename = str_random(10).'.'.'png';
   $filename = 'image_'.rand(99999, 99999999) .time().'.png'; //generating unique file name;
   @list($type, $file_data) = explode(';', $image);
   @list(, $image) = explode(',', $image);
    \File::put(public_path(). '/cdn/' . $filename, base64_decode($image));
    // $profileimg  = $filename;
    // $filename = rand(99999, 99999999) . $file->getClientOriginalName();
    // $file->move(public_path('/cdn'), $filename);
    // $profileimg  = $filename;
    return $filename;
}

function getImage($filename)
{
    if(strpos($filename, url('/')) !== false) {
        return $filename;
    }
    return url('/').'/cdn/'.$filename;
}

function UserStatus()
{
    $arr = [
        '1' => 'مفعل',
        '0' => 'غير مفعل',
    ];
    return $arr;
}

function DriverReviewed()
{
    $arr = [
        '0' => ' لم تتم المراجعه',
        '1' => 'تمت المراجعه',
    ];
    return $arr;
}

function OrderTypes()
{
    $arr = [
        'internal' => 'داخلي',
        'external' => 'خارجي',
    ];
    return $arr;
}

function DriverType()
{
    $arr = [
        'employee' => 'موظف',
        'not_employee' => 'غير موظف',
    ];
    return $arr;
}
function UserRole()
{
    $arr = [
        'user' => 'مستخدم',
        'admin' => 'مدير',
        // 'company' => 'شركة',
    ];
    return $arr;
}
function ProductType()
{
    $arr = [
        'rent' => 'ايجار',
        'sale' => 'بيع',
    ];
    return $arr;
}

function GetCount($table,$column, $value, $operator = '=')
{
    if ($column != '') {
        //
        return \DB::table($table)->where($column, $operator, $value)->count();
    }else{
        return \DB::table($table)->count();
    }
}
function Admins()
{
    $cats = \App\Models\Admin::get();
    $arr = [];
    $arr[''] = 'اختر المستخدم';
    foreach ($cats as $item) {
            $arr[$item->id] = $item->name;
    }
    return $arr;
}
function RolesList()
{
    $cats = \App\Models\Role::get();
    $arr = [];
    foreach ($cats as $item) {
            $arr[$item->id] = $item->name;
    }
    return $arr;
}
function CheckPermission($key)
{
    if(auth()->user()->role == 'admin' )
    {
        return true;
    }
    $role = auth()->user()->UserRole()->first();
    if( $role )
    {
        $permission = $role->Role()->first()->Permission()->where('permission', $key)->first();
        if ($permission) {
            return true;
        }
    }
    return false;
}

function AllCity()
{
    return $cats = \App\Models\City::get();
    $arr = [];
    foreach ($cats as $item) {
        $arr[$item->id] = $item->name_ar;

    }
    return $arr;
}

function AllColors()
{
    return $cats = \App\Models\Color::get();
    $arr = [];
    foreach ($cats as $item) {
        $arr[$item->id] = $item->name_ar;

    }
    return $arr;
}

function AllYears()
{
    return $items = \App\Models\Year::get();
    $arr = [];
    foreach ($items as $item) {
        $arr[$item->id] = $item->name_ar;

    }
    return $arr;
}

function Cities()
{
    $items = \App\Models\City::get();
    $arr = ['' => 'اختر المدينة'];
    foreach ($items as $item) {
        $arr[$item->id] = $item->name_ar;

    }
    return $arr;
}


function CarModelList()
{
    $items = \App\Models\CarModel::get();
    $arr = [];
    foreach ($items as $item) {
        $arr[$item->id] = $item->name_ar;

    }
    return $arr;
}

function CarColorList()
{
    $items = \App\Models\Color::get();
    $arr = [];
    foreach ($items as $item) {
        $arr[$item->id] = $item->name_ar;

    }
    return $arr;
}

function CarYearList()
{
    $items = \App\Models\Year::get();
    $arr = [];
    foreach ($items as $item) {
        $arr[$item->id] = $item->name;

    }
    return $arr;
}


function OrderStatus()
{
    $arr = [
        '' => 'اختر الحالة',
        'init' => 'في انتظار الدفع',
        'confirmed' => 'تم التاكيد و الدفع',
        'processing' => 'المعدة في موقع العمل',
        'canceled' => 'تم الالغاء',
        'finished' => 'تم الانتهاء',
    ];
    return $arr;
}


function PermissionModels()
{
    return [ 'user', 'product', 'order', 'vacation', 'slider', 'coupon'];
}
function Roles()
{
    $cats = \App\Models\Role::get();
    $arr = [];
    foreach ($cats as $item) {
            $arr[$item->id] = $item->name;
    }
    return $cats;
}
// shimaa///////////////////////
function Years()
{
   $items = \App\Models\Year::get();
    $arr = [];
    foreach ($items as $item) {
        $arr[$item->id] = $item->name;

    }
    return $arr;
}

function Models()
{
   $items = \App\Models\Models::get();
    $arr = [];
    foreach ($items as $item) {
        $arr[$item->id] = $item->name_ar;

    }
    return $arr;
}
function ModelsList()
{
   $items = \App\Models\Models::get();
    $arr = [];
    foreach ($items as $item) {
        $arr[$item->id] = $item->name_ar;

    }
    return $arr;
}
function AllModels()
{
   $items = \App\Models\Models::get();
    $arr = [];
    foreach ($items as $item) {
        $arr[$item->id] = $item->name_ar;

    }
    return $items;
}
function Missions()
{
   $items = \App\Models\Mission::get();
    $arr = [];
    foreach ($items as $item) {
        $arr[$item->id] = $item->name_ar;

    }
    return $items;
}
function MissionsList()
{
   $items = \App\Models\Mission::get();
    $arr = ['' => 'اختر'];
    foreach ($items as $item) {
        $arr[$item->id] = $item->name_ar;

    }
    return $arr;
}
function Categories()
{
   $items = \App\Models\Category::get();
    $arr = [];
    foreach ($items as $item) {
        $arr[$item->id] = $item->name_ar;

    }
    return $items;
}
function CategoriesList()
{
   $items = \App\Models\Category::get();
   $arr = ['' => 'اختر'];
    foreach ($items as $item) {
        $arr[$item->id] = $item->name_ar;

    }
    return $arr;
}
function CategoriesListc()
{
   $items = \App\Models\Category::get();
    $arr = ['' => 'اختر نوع المعدة'];
    foreach ($items as $item) {
        $arr[$item->id] = $item->name_ar;

    }
    return $arr;
}
function Branchs()
{
   $items = \App\Models\Branch::get();
   $arr = ['' => 'اختر'];
    foreach ($items as $item) {
        $arr[$item->id] = $item->name_ar;

    }
    return $arr;
}

 function HelpersendSMS($destinations, $message)
    {
        // $username = "Aljeri";		    // اسم المستخدم الخاص بك في الموقع
        // $password = "SmSaljeri_1330"; 		// كلمة المرور الخاصة بك
        // $destinations = $destinations; //الارقام المرسل لها  ,, يتم وضع فاصلة بين الارقام المراد الارسال لها
        // $message = $message;      // محتوى الرسالة
        // $sender = "JTC";         // اسم المرسل الخاص بك المفعل  في الموقع
        // $url = "http://www.jawalbsms.ws/api.php/sendsms?user=$username&pass=$password&to=$destinations&message=$message&sender=$sender";

        // $ch = curl_init($url); // init the curl with jawalb API url
        // curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        // curl_setopt($ch, CURLOPT_HEADER, 0);
        // $data = curl_exec($ch);  //run curl api call, on success curl call, $data will contain the API call response
        // curl_close($ch);
        // // print_r($data);

        $postRequest = array(
            'body' => $message,
            'sender' => 'OTC',
            'recipients' => [
                $destinations
            ]
        );

        $cURLConnection = curl_init('https://api.taqnyat.sa/v1/messages');
        curl_setopt($cURLConnection, CURLOPT_POSTFIELDS, json_encode($postRequest));
        curl_setopt($cURLConnection, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($cURLConnection, CURLOPT_HTTPHEADER, array(
            'Authorization: Bearer 2097057f9ffbb1836fa24795c10e7915',
            'Content-Type: application/json'
        ));

        $apiResponse = curl_exec($cURLConnection);
        curl_close($cURLConnection);

        // $apiResponse - available data from the API request
        $jsonArrayResponse = json_decode($apiResponse);
        return $jsonArrayResponse;
    }

?>
