<?php

namespace App\Http\Controllers\Admin;

use App\Http\Requests\Admin\UpdateOrderRequest;
use App\Http\Requests\Admin\StoreOrderRequest;
use App\Http\Controllers\Controller;
use App\Traits\Admin\OrderOperations;
use Illuminate\Http\Request;
use App\Models\Admin;
use App\Models\Order;
use App\Models\Bus;
use App\Models\CompanyOrder;
use Auth;
use Validator;
use Maatwebsite\Excel\Facades\Excel;

class OrderController extends Controller
{
    use OrderOperations;
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */

    public function __construct()
    {
        // $this->middleware('Permission:Order_show'    , ['only' => 'index', 'show']);
        // $this->middleware('Permission:Order_add'     , ['only' => 'create', 'store']);
        // $this->middleware('Permission:Order_edit'    , ['only' => 'edit', 'update']);
        // $this->middleware('Permission:Order_delete'  , ['only' => 'destroy']);
    }

    public function index()
    {
        $orders = Order::latest();


        $search = array();
        if (Request()->has('name') && Request()->get('name') != '') {
            $name = Request()->get('name');
            $search['name'] = $name;
            $orders = $orders->wherehas('User', function($q) use ($name){
                $q->where('name'     , 'LIKE', '%'.$name.'%');
            });
        }
        if (Request()->has('id') && Request()->get('id') != '') {
            $id = Request()->get('id');
            $search['id'] = $id;
            $orders = $orders->where('id'     ,$id);
        }
        if (Request()->has('city') && Request()->get('city') != '') {
            $city = Request()->get('city');
            $search['city'] = $city;
            $orders = $orders->where('city'     ,$city);
        }
        if (Request()->has('date_from') && Request()->get('date_from') != '') {
            $date_from = Request()->get('date_from');
            $search['date_from'] = $date_from;
            $orders = $orders->whereDate('created_at', '>=',$date_from);
        }
        if (Request()->has('date_to') && Request()->get('date_to') != '') {
            $date_to = Request()->get('date_to');
            $search['date_to'] = $date_to;
            $orders = $orders->whereDate('created_at', '<=',$date_to);
        }
        if (Request()->has('status') && Request()->get('status') != '') {
            $status = Request()->get('status');
            $search['status'] = $status;
            $orders = $orders->where('status'     ,$status);
        }
        // ////////////////////////////////////////////////////
        $ordersf = $orders;
        $orders_sale = $ordersf;
        $orders_canceled = $ordersf;
        $orders_rent = $ordersf;
        $orders = $orders->paginate(40);
        $orders_sale = $orders_sale->whereHas('OrderItem', function($q){
            $q->where('product_type', 'sale');
        })->paginate(40);


        $orders_rent = $orders_rent->whereHas('OrderItem', function($q){
            $q->where('product_type', 'rent');
        })->paginate(40);

        $orders_canceled = $orders_canceled->where('status', 'canceled')->paginate(40);

        $title = 'الطلبات';
        $order_company=CompanyOrder::latest()->paginate(20);


        return view('admin.orders.index', compact('orders', 'title', 'search', 'orders_sale', 'orders_rent', 'orders_canceled','order_company'));
    }
    public function indexPost(Request $request)
    {
        // return $request->all();
        $orders = Order::whereNotNull('id');
        $search = array();
        if ($request->has('sort_by') && $request->sort_by != '' && !in_array($request->sort_by, ['user_name', 'user_phone'])) {
            $orders = $orders->orderBy($request->sort_by, $request->sort_type);
            $search['sort_by'] = $request->sort_by;
            $search['sort_type'] = $request->sort_type;
        }else{
            $orders = $orders->latest();
        }
        // $search = array();
        if (Request()->has('name') && Request()->get('name') != '') {
            $name = Request()->get('name');
            $search['name'] = $name;
            $orders = $orders->wherehas('User', function($q) use ($name){
                $q->where('name'     , 'LIKE', '%'.$name.'%');
            });
        }
        if (Request()->has('id') && Request()->get('id') != '') {
            $id = Request()->get('id');
            $search['id'] = $id;
            $orders = $orders->where('id'     ,$id);
        }
        if (Request()->has('city') && Request()->get('city') != '') {
            $city = Request()->get('city');
            $search['city'] = $city;
            $orders = $orders->where('city'     ,$city);
        }
        if (Request()->has('date_from') && Request()->get('date_from') != '') {
            $date_from = Request()->get('date_from');
            $search['date_from'] = $date_from;
            $orders = $orders->whereDate('created_at', '>=',$date_from);
        }
        if (Request()->has('date_to') && Request()->get('date_to') != '') {
            $date_to = Request()->get('date_to');
            $search['date_to'] = $date_to;
            $orders = $orders->whereDate('created_at', '<=',$date_to);
        }
        if (Request()->has('status') && Request()->get('status') != '') {
            $status = Request()->get('status');
            $search['status'] = $status;
            $orders = $orders->where('status'     ,$status);
        }
        // ////////////////////////////////////////////////////
        $ordersf = $orders;
        $orders_sale = $ordersf;
        $orders_canceled = $ordersf;
        $orders_rent = $ordersf;
        $orders = $orders->paginate(40)->setPath(route('orders.index'));
        $orders_sale = $orders_sale->whereHas('OrderItem', function($q){
            $q->where('product_type', 'sale');
        })->paginate(40);


        $orders_rent = $orders_rent->whereHas('OrderItem', function($q){
            $q->where('product_type', 'rent');
        })->paginate(40);

        $orders_canceled = $orders_canceled->where('status', 'canceled')->paginate(40);

        $title = 'الطلبات';
        $order_company = CompanyOrder::latest();
        if (Request()->has('status') && Request()->get('status') != '') {
            $status = Request()->get('status');
            $search['status'] = $status;
            $order_company = $order_company->where('status'     ,$status);
        }
        if (Request()->has('id') && Request()->get('id') != '') {
            $id = Request()->get('id');
            $search['id'] = $id;
            $order_company = $order_company->where('id'     ,$id);
        }
        if (Request()->has('date_from') && Request()->get('date_from') != '') {
            $date_from = Request()->get('date_from');
            $search['date_from'] = $date_from;
            $order_company = $order_company->whereDate('created_at', '>=',$date_from);
        }
        if (Request()->has('date_to') && Request()->get('date_to') != '') {
            $date_to = Request()->get('date_to');
            $search['date_to'] = $date_to;
            $order_company = $order_company->whereDate('created_at', '<=',$date_to);
        }
        if (Request()->has('name') && Request()->get('name') != '') {
            $name = Request()->get('name');
            $search['name'] = $name;
            $order_company = $order_company->where('responsible_name', 'LIKE', "%$name%");
            // $order_company = $order_company->wherehas('User', function($q) use ($name){
            //     $q->where('name'     , 'LIKE', '%'.$name.'%');
            // });
        }
        $order_company = $order_company->paginate(20);


        $view = view('admin.orders.table2', compact('orders', 'title', 'search', 'orders_sale', 'orders_rent', 'orders_canceled','order_company'))->render();
        $viewCom = view('admin.orders.table_com', compact('orders', 'title', 'search', 'orders_sale', 'orders_rent', 'orders_canceled','order_company'))->render();
        return response()->json([
            'code' => 200,
            'view' => $view,
            'viewCom' => $viewCom
        ], 200);
    }



    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $title = 'اضافة طلب';
        return view('admin.orders.add', compact('title'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(StoreOrderRequest $request)
    {
        // return $request->all();
        $this->register($request);
        return redirect('/dashboard/orders')->with('success', 'data added successfully');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show(Order $order)
    {
        $title = 'عرض طلب';
        return view('admin.orders.show', compact('order', 'title'));
    }
    public function bill($id)
    {
        $title = ' bill';
        $order = Order::find($id);
        return view('admin.orders.bill', compact('order', 'title'));
    }
    public function OrderInfo($id)
    {
        $order = Order::find($id);
        $title = 'عرض طلب';
        return view('admin.orders.ajax_data', compact('order', 'title'))->render();
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $title = 'تعديل طلب';
        $order = Order::find($id);
        return view('admin.orders.edit', compact('order', 'title'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(UpdateOrderRequest $request, Order $order)
    {
        // $order = Order::find($id);
        $res = $this->UpdateRecords($order, $request);
        try{
        if($res == 0)
        {
            return back()->with('warning', 'كود العميل غير صحيح');
        }
            
        }catch(\Exception $e){}
        return redirect('/dashboard/orders')->with('success', 'data added successfully');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Order $order)
    {
        if ($order->image) {
            @unlink(public_path('/cdn/'.$order->image));
        }
        $order->OrderItem()->delete();
        $order->delete();
        return 'success';
    }public function deleteArray(Request $request)
    {
        if ($request->has('ids') && is_array($request->ids) && sizeof($request->ids) > 0 ) {
            foreach ($request->ids as $id) {
                $pro = Order::find($id);
                if($pro)
                $this->destroy($pro);
            }
        }
        return response()->json([
            'message' => "تم الحذف بنجاح",
            'code' => 200
        ]);
    }
    public function updateArray(Request $request)
    {
        // return $request->all();
        $data = $request->only(['status']);
        if (trim($data['status']) == '') unset($data['status']);
        // if (trim($data['category_id']) == '') unset($data['category_id']);
        // if (trim($data['branch_id']) == '') unset($data['branch_id']);
        // if (isset($data['active']) && trim($data['active']) == '') unset($data['active']);
        if ($request->has('ids') && $request->ids != '' ) {
            $ids = explode(',', $request->ids);
            Order::whereIn('id', $ids)->update($data);
        }
        return response()->json([
            'message' => "تم التعديل بنجاح",
            'code' => 200
        ]);
    }
}
