<?php

namespace App\Http\Controllers\Admin;

use App\Http\Requests\Admin\UpdateDriverRequest;
use App\Http\Requests\Admin\StoreDriverRequest;
use App\Http\Controllers\Controller;
use App\Traits\Admin\DriverOperations;
use Illuminate\Http\Request;
use App\Models\Admin;
use App\Models\Driver;
use App\Models\OrderLog;
use Auth;
use Validator;
use Illuminate\Support\Collection;
use App\Exports\GeneralExport;
use Maatwebsite\Excel\Facades\Excel;

class DriverController extends Controller
{
    use DriverOperations;
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */

    public function __construct()
    {
        // $this->middleware('Permission:Driver_show'    , ['only' => 'index', 'show']);
        // $this->middleware('Permission:Driver_add'     , ['only' => 'create', 'store']);
        // $this->middleware('Permission:Driver_edit'    , ['only' => 'edit', 'update']);
        // $this->middleware('Permission:Driver_delete'  , ['only' => 'destroy']);
    }

    public function index()
    {
        $drivers = Driver::latest();


        $search = array();
        if (Request()->has('name') && Request()->get('name') != '') {
            $name = Request()->get('name');
            $search['name'] = $name;
            $drivers = $drivers->where('name'     , 'LIKE', '%'.$name.'%');
        }
        if (Request()->has('phone') && Request()->get('phone') != '') {
            $phone = Request()->get('phone');
            $search['phone'] = $phone;
            $drivers = $drivers->where('phone'     , 'LIKE', '%'.$phone.'%');
        }
        
        // excport to excel
        if(Request()->has('excel') && Request()->get('excel') == '1')
        {
            return Excel::download(new GeneralExport($drivers->get(), 'drivers'), 'drivers.xlsx');
        }
        // excport to excel
        $drivers = $drivers->paginate(20);
        
        $title = 'السائقين';
        return view('admin.drivers.index', compact('drivers', 'title', 'search'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $title = 'اضافة السائق';
        $parent_id = Request()->get('parent_id');
        return view('admin.drivers.add', compact('title', 'parent_id'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(StoreDriverRequest $request)
    {
        // return $request->all();
        $this->register($request);
        return redirect('/dashboard/drivers')->with('success', 'data added successfully');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show(Driver $driver)
    {
        $title = 'عرض السائق';
        $old_orders = OrderLog::where('key', 'driver_assigned')
                                ->where('key_id', $driver->id)
                                ->whereNotIn('order_id', $driver->Order()->pluck('id')->toArray() )
                                ->pluck('order_id')->toArray();
        $previous_orders = $driver->Order()
                        ->whereIn('id', $old_orders)
                        ->with('CarType')
                        ->with('CarMaker')
                        ->with('CarModel')
                        ->with('ServiceType')
                        ->with('User')
                        ->with('Driver')
                        ->with('SourceCity')
                        ->with('DestinationCity')
                        ->with('SourceBranch')
                        ->with('DestinationBranch')
                        ->get();
        $current_orders = $driver->Order()
                        ->with('CarType')
                        ->with('CarMaker')
                        ->with('CarModel')
                        ->with('ServiceType')
                        ->with('User')
                        ->with('Driver')
                        ->with('SourceCity')
                        ->with('DestinationCity')
                        ->with('SourceBranch')
                        ->with('DestinationBranch')
                        ->get();
        $driver_payments = $driver->DriverPayment()->get();
        return view('admin.drivers.show', compact('driver', 'title', 'current_orders', 'previous_orders', 'driver_payments'));
    }
    public function DriverInfo($id)
    {
        $driver = Driver::find($id);
        $title = 'عرض السائق';
        return view('admin.drivers.ajax_data', compact('driver', 'title'))->render();
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $driver = Driver::find($id);
        $title = 'تعديل السائق';
        if ($driver->DriverInfo()->first()) {
            // 
            $driverInfo = $driver->DriverInfo()->first()->toArray();
        } else {
            $driverInfo = [];
            // 
        }
        
        foreach ($driverInfo as $key => $value) {
            if ($key == 'id') {
                continue;
            }
            $driver->$key = $value;
        }
        // return $driver;
        return view('admin.drivers.edit', compact('driver', 'title'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(UpdateDriverRequest $request, Driver $driver)
    {
        // $driver = Driver::find($id);
        $this->UpdateRecords($driver, $request);
        return redirect('/dashboard/drivers')->with('success', 'data added successfully');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Driver $driver)
    {
        if ($driver->image) {
            @unlink(public_path('/cdn/'.$driver->image));
        }
        $driver->delete();
        return 'success';
    }
    public function logout()
    {
        Auth::logout();
        return redirect('/login');
    }
    public function storeClient(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'name'          => 'required|max:255',
            'email'         => 'nullable|email|unique:drivers|max:255',
            'phone'         => 'required|unique:drivers|max:255',
            // 'password'      => 'required|max:255|min:6',
            'image'         => 'nullable|image',
        ]);
        if ($validator->fails()) {
            $errors = collect($validator->errors());
            $error  = $errors->unique()->first();
            // return $validator->errors();
            return Response()->jDriver([
            'message' => 'error',
            'data' => $error ,
        ]);
        }
        $driver = Driver::create($request->all());
        return Response()->jDriver([
            'message' => 'success',
            'data' => '<option value="'.$driver->id.'" selected="">'.$driver->name.'</option>',
        ]);
        // return '<option value="'.$driver->id.'">'.$driver->name.'</option>';
    }
}
