<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Traits\Admin\CityOperations;
use Illuminate\Http\Request;
use App\Models\Admin;
use App\Models\City;
use Auth;
use Excel;
use App\Exports\GeneralExport;
use Carbon\Carbon;

class CityController extends Controller
{
    use CityOperations;
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */


    public function __construct()
    {

    }
    public function index()
    {
        $title = 'مناطق العمل الجيوغرافية';

                $cities = City::orderBy('id', 'asc');
            $search = array();
            if (Request()->has('id') && Request()->get('id') != '') {
                $id = Request()->get('id');
                $search['id'] = $id;
                $cities = $cities->where('id',$id);
            }
            if (Request()->has('name') && Request()->get('name') != '') {
                $name = Request()->get('name');
                $search['name'] = $name;
                $cities = $cities->where('structure_no'     , 'LIKE', '%'.$name.'%')->orWhere('name'     , 'LIKE', '%'.$name.'%');
            }
            $cities = $cities->paginate(40);
        return view('admin.cities.index', compact('cities', 'title' , 'search'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $title = 'اضافة ';
        return view('admin.cities.add', compact('title'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->register($request);
        return redirect('/dashboard/cities')->with('success', 'data added successfully');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show(City $city)
    {
        $title = 'عرض ';
        return view('admin.cities.show', compact('city', 'title'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $city = City::find($id);
        $polygon = $city->polygon;
        $polygon = explode(',', $polygon);
        if (sizeof($polygon) > 2 ) {
            $point = explode(' ', $polygon[0]);
            $lat = $point[0];
            $long = $point[1];
        } else {
            $lat = '24.68890207347191';
            $long = '46.68803199999999';
        }

        $title = 'تعديل ';
        return view('admin.cities.edit', compact('city', 'title', 'lat', 'long'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {

        $city = City::find($id);
        $this->UpdateRecords($city, $request);

        return redirect('dashboard/cities');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(City $city)
    {
        if ($city->form_image) {
            @unlink(public_path('/cdn/'.$city->form_image));
        }
        $city->delete();
        return 'success';
    }
    var $pointOnVertex = true; // Check if the point sits exactly on one of the vertices?

    public function pointLocation() {
    }

    public function pointInPolygon($point, $polygon, $pointOnVertex = true) {
        $this->pointOnVertex = $pointOnVertex;

        // Transform string coordinates into arrays with x and y values
        $point = $this->pointStringToCoordinates($point);
        $vertices = array();
        foreach ($polygon as $vertex) {
            $vertices[] = $this->pointStringToCoordinates($vertex);
        }

        // Check if the point sits exactly on a vertex
        if ($this->pointOnVertex == true and $this->pointOnVertex($point, $vertices) == true) {
            return "vertex";
        }

        // Check if the point is inside the polygon or on the boundary
        $intersections = 0;
        $vertices_count = count($vertices);

        for ($i=1; $i < $vertices_count; $i++) {
            $vertex1 = $vertices[$i-1];
            $vertex2 = $vertices[$i];
            if ($vertex1['y'] == $vertex2['y'] and $vertex1['y'] == $point['y'] and $point['x'] > min($vertex1['x'], $vertex2['x']) and $point['x'] < max($vertex1['x'], $vertex2['x'])) { // Check if point is on an horizontal polygon boundary
                return "boundary";
            }
            if ($point['y'] > min($vertex1['y'], $vertex2['y']) and $point['y'] <= max($vertex1['y'], $vertex2['y']) and $point['x'] <= max($vertex1['x'], $vertex2['x']) and $vertex1['y'] != $vertex2['y']) {
                $xinters = ($point['y'] - $vertex1['y']) * ($vertex2['x'] - $vertex1['x']) / ($vertex2['y'] - $vertex1['y']) + $vertex1['x'];
                if ($xinters == $point['x']) { // Check if point is on the polygon boundary (other than horizontal)
                    return "boundary";
                }
                if ($vertex1['x'] == $vertex2['x'] || $point['x'] <= $xinters) {
                    $intersections++;
                }
            }
        }
        // If the number of edges we passed through is odd, then it's in the polygon.
        if ($intersections % 2 != 0) {
            return "inside";
        } else {
            return "outside";
        }
    }

    public function pointOnVertex($point, $vertices) {
        foreach($vertices as $vertex) {
            if ($point == $vertex) {
                return true;
            }
        }

    }

    public function pointStringToCoordinates($pointString) {
        $coordinates = explode(" ", $pointString);
        return array("x" => $coordinates[0], "y" => $coordinates[1]);
    }
    public function checkP($id, $lat, $long) {
        $polygon = City::find($id)->polygon;
        $polygon = explode(',', $polygon);
        $polygon = array_filter($polygon, function($value) { return !is_null($value) && $value !== ''; });
        // The last point's coordinates must be the same as the first one's, to "close the loop"
        // foreach($points as $key => $point) {
            if($this->pointInPolygon($lat . ' ' . $long , $polygon) == 'inside' )
            {
                return true;
            }else{
                return false;
            }
        // }
    }

}
