<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class CompanyOrder extends Model
{
    protected $table='company_orders';
    protected $fillable = [
        'company_name', 'company_phone', 'registration_name', 'user_id', 'responsible_name', 
        'responsible_phone', 'responsible_mail', 'date_from', 'date_to', 'details', 'address', 'status',
         'latitude', 'longitude', 
    ];

    public function User()
    {
        return $this->belongsTo(User::class,'user_id');
    }

    public function CompanyOrderItem()
    {
        return $this->hasMany(CompanyOrderItem::class,'company_order_id');
    }
    
   public function Files()
   {
       return $this->morphMany(Files::class, 'taggable');
   }
}
