<?php

namespace App\Http\Requests\Admin;

use Illuminate\Foundation\Http\FormRequest;

class UpdateAdminRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        $admin = $this->route('admin');
        return [
            'name'          => 'max:255',
            'email'         => 'email|unique:admins,email,'.$admin->id.'|max:255',
            'phone'         => 'unique:admins,phone,'.$admin->id.'|max:255',
            'password'      => 'max:255',
            'image'         => 'nullable|image',
        ];

    }
}
