<?php

namespace App\Http\Controllers\Api;

use App\Mail\Api\UserVerify as UserVerifyMail;
use App\Http\Requests\Api\StoreUserRequest;
use App\Http\Requests\Api\UpdateUserRequest;
use App\Mail\Api\UserForgetPasswordMail;
use App\Http\Requests\Api\LoginRequest;
use App\Http\Controllers\Controller;
use App\Traits\Api\UserOperations;
use Illuminate\Http\Request;
use App\Models\ProductRating;
use App\Models\OrderRating;
use App\Models\User;
use App\Models\Cart;
use App\Models\BusinessAccount;
use Carbon\Carbon;
use Auth;
use Mail;
use Tymon\JWTAuth\Facades\JWTAuth;
use Validator;

class UserController extends Controller
{
    use UserOperations;

    public function login(LoginRequest $request)
    {
        
            // $code = $request->get('code');
            $email = $request->get('email');
            $password = $request->get('password');
            $phone = $request->get('phone');
            if ($request->has('phone')) {
                $credentials = ['phone' => $phone, 'password' => $password];
                // check user
                if($token = auth('api')->attempt($credentials))
                {
                    $user = auth('api')->user();
                    $uuid = Request()->header('uuid');
                    if($uuid && Request()->header('uuid') != '')
                    {

                        if (Cart::where('uuid', $uuid)->count() > 0) {
                            $user->Cart()->delete();
                            Cart::where('uuid', $uuid)->update(['user_id' => $user->id]);
                        }
                    }
                        $user->update(['verify_code' => null]);
                    if(Request()->has('player_id') && !$user->PlayerId()->where('player_id', '=', $request->get('player_id'))->first() )
                    {
                        $user->PlayerId()->create(['player_id' => $request->player_id]);
                    }
                    $user->token = $token;
                    return Response()->json([
                            'data'          => [
                                'user'  => $user,
                                // 'token'  => $token
                            ],
                            'message'       => 'success',
                            'code'          => getMsgCode('success'),
                        ]);
                }
            }else{
                $credentials = ['email' => $email, 'password' => $password];
            }
            if ($token = auth('api')->attempt($credentials)) {
                $user = auth('api')->user();
                    $user->token = $token;
                if(Request()->has('player_id') && !$user->PlayerId()->where('player_id', '=', $request->get('player_id'))->first() )
                {
                    $user->PlayerId()->create($request->all());
                }
                    if($user->UserVerify()->where('type','phone')->latest()->first())
                    {
                        $verifyNum = $user->UserVerify()->where('type','phone')->latest()->first()->code;
                    }else{
                        $verifyNum = '';
                    }
                return Response()->json([
                        'data'          => [
                            'user'  => $user,
                            // 'token'  => $token
                        ],
                        'message'       => 'success',
                        'code'          => getMsgCode('success'),
                    ]);
            }else{
                return Response()->json([
                        'data'   => new \stdClass,
                        'errors'       => [' '],
                        'message'       => 'authFailed',
                        'code'          => getMsgCode('authFailed'),
                    ]);
            }
    }

    public function logout()
    {
        $user = Auth::guard('api')->user();
        if (Request()->has('player_id')) {
            $user->PlayerId()->where('player_id', '=', Request()->get('player_id'))->delete();
        }
        return Response()->json([
            'data'          => new \stdClass,
            'message'       => 'success',
            'code'          => getMsgCode('success'),
        ]);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(StoreUserRequest $request)
    {
            $token = '';
            $user = $this->register($request);
            if ($request->has('phone') && $request->get('phone')) {
                $credentials = request(['phone', 'password']);
                $token = auth('api')->attempt($credentials);
            }else{
                $credentials = request(['email', 'password']);
                $token = auth('api')->attempt($credentials);
            }
        // }
        $user = User::find($user->id);
            // send code to mobile
            $code = '2222';//rand(1000,9999);
            try{
                $result=$this->sendSMS($user->phone, 'code:'.$code);
            }catch(\Exception $e){

            }
            // send code to mobile
            $user->verify_code = $code;
            $user->save();
            $user->token = $token;
        return Response()->json([
                'data' => [
                    'user' => $user
                ],
                'message' => 'success',
                'code' => getMsgCode('success')
        ]);
    }
    public function update(UpdateUserRequest $request)
    {
        $user = Auth::guard('api')->user();
        if ($request->has('phone') && $request->get('phone') != '' && $request->has('code') && $request->get('code') != '' && $user->verify_code != $request->get('code')) {
            return Response()->json([
                    'data' => new \stdClass,
                    'errors' => ['كود التحقق غير صحيح.'],
                    'message' => trans('words.wrong verify code'),
                    'code' => getMsgCode('validationErrors')
            ]);
        }
        $this->UpdateRecords($user, $request);
        $user = User::find($user->id);
        $user->token = auth('api')->tokenById($user->id);
        return Response()->json([
                'data' => [
                    'user' => $user
                ],
                'message' => 'success',
                'code' => getMsgCode('success')
        ]);
    }
    public function profile(Request $request)
    {
        $user = Auth::guard('api')->user();
        // if($user->image)
        // {
        //     $user->image = url('/').'/cdn/'.$user->image;
        // }
        return Response()->json([
                'data' => [
                    'user' => $user
                ],
                'message' => 'success',
                'code' => getMsgCode('success')
        ]);
    }

    public function changePassword()
    {
        $user           = Auth::guard('api')->user();
        $data           = request()->except(['api_token']);

        $newPassword    = bcrypt($data['password']);

        try {

            $user->update(['password' => $newPassword]);

            return response()->json([
                    'data'      => [
                            'user' => $user,
                    ],
                    'message'   => 'success',
                    'code'      => getMsgCode()
            ]);

        } catch (Exception $e) {
            return response()->json([
                'data'   => new \stdClass,
                'errors'       => [' '],
                'message'   => 'something went wrong',
                'code'      => getMsgCode('somethingWrong')
            ]);
        }
    }

    

    public function show(Request $request)
    {
        $user_id = Request()->get('user_id');
        $user = User::find($user_id);
        if($user->image)
        {
            $user->image = url('/').'/cdn/'.$user->image;
        }
        $rate = 0;
        try {
            $rate = ($user->MyRate()->sum('value') / $user->MyRate()->count());
        } catch (\Exception $e) {
            $rate = 0;
        }
        $user->rate = $rate;
        return Response()->json([
                'data' => [
                    'user' => $user
                ],
                'message' => 'success',
                'code' => getMsgCode('success')
        ]);
    }

    public function notifications(Request $request)
    {
        $user = auth('api')->user();
        $notifications  = $user->unreadnotifications;
        // return $notifications;
        return Response()->json([
                'data' => [
                    'notifications' => $notifications
                ],
                'message' => 'success',
                'code' => getMsgCode('success')
        ]);
    }
    public function notificationReaded(Request $request)
   {
    // $user = Auth::user();
    $user = auth('api')->user();
    $user->unreadnotifications->where('id', $request->id)->markAsRead();
    $notifications  = $user->unreadnotifications;
    // return $notifications;
    return Response()->json([
            'data' => [
                'notifications' => $notifications
            ],
            'message' => 'success',
            'code' => getMsgCode('success')
    ]);
   }

    public function VIPRequest(Request $request)
    {
        $user = auth('api')->user();
        $data = $request->all();
        // $rules = [
        //     'email'         => 'required|email|unique:users,email,'.$id.'|max:255',
        //     'phone'         => 'required|unique:users,phone,'.$id.'|max:255',
        //     'registration_number'         => 'required|unique:users,registration_number,'.$id.'|max:255',
        // ];
        // $validator = Validator::make($data, $rules);
        // if ($validator->fails()) {
        //     return Response()->json([
        //         'data' => new \stdClass,
        //         'errors' => $validator->errors,
        //         'message' => 'validationErrors',
        //         'code' => getMsgCode('validationErrors')
        // ]);
        // }
        if ($request->hasFile('image')) {
            $data['image'] = uploadFile($request);
        }
        if($user->BusinessAccount()->first())
        {
            $id = $user->BusinessAccount()->first()->id;
            $rules = [
                'email'         => 'required|email|unique:business_accounts,email,'.$id.'|max:255',
                'phone'         => 'required|unique:business_accounts,phone,'.$id.'|max:255',
                'registration_number'         => 'required|unique:business_accounts,registration_number,'.$id.'|max:255',
            ];
            $validator = Validator::make($data, $rules);
            if ($validator->fails()) {
                return Response()->json([
                    'data' => new \stdClass,
                    'errors' => $validator->errors()->all(),
                    'message' => implode(' , ', $validator->errors()->all()),
                    'code' => getMsgCode('validationErrors')
            ]);
                }
            if ($request->has('phone') && $request->get('phone') != '' && $request->has('code') && $request->get('code') != '' && $user->verify_code != $request->get('code')) {
                return Response()->json([
                        'data' => new \stdClass,
                        'errors' => ['كود التحقق غير صحيح.'],
                        'message' => 'validationErrors',
                        'code' => getMsgCode('validationErrors')
                ]);
            }
            unset($data['code']);
            $user->BusinessAccount()->update($data);
        }else{
            $rules = [
                'email'         => 'required|email|unique:business_accounts,email|max:255',
                'phone'         => 'required|unique:business_accounts,phone|max:255',
                'registration_number'         => 'required|unique:business_accounts,registration_number|max:255',
            ];
            $validator = Validator::make($data, $rules);
            if ($validator->fails()) {
                return Response()->json([
                    'data' => new \stdClass,
                    'errors' => $validator->errors()->all(),
                    'message' => implode(' , ', $validator->errors()->all()),
                    'code' => getMsgCode('validationErrors')
            ]);
                }
            $user->BusinessAccount()->create($data);
        }
        $user->token = auth('api')->tokenById($user->id);
        return Response()->json([
            'data' => [
                'user' => $user
            ],
            'message' => 'success',
            'code' => getMsgCode('success')
        ]);
    }

    public function VIPAccountRates(Request $request)
    {
        $user = auth('api')->user();
        $product_ids = $user->Product()->pluck('id')->toArray();
        $rates = ProductRating::whereIn('product_id', $product_ids)->with('Product')->with('User');
        $count = $rates->count();
        $rate_sum = $rates->sum('rate');
        $rates = $rates->get();
        try{
            // 
            $value = $rate_sum / $count;
        }catch(\Exception $e){
            // 
            $value = 0;
        }
        return Response()->json([
            'data' => [
                'rates' => $rates,
                'count' => $count,
                'value' => $value,
            ],
            'message' => 'success',
            'code' => getMsgCode('success')
        ]);
    }
    
    public function sendVerifyCode(Request $request)
    {
        $phone = $request->get('phone');
        $code = '2222';//rand(1000,9999);
        // if (User::where('phone', $phone)->first() && (!$request->has('type') || $request->get('type') == '' )) {
        //     $user = User::where('phone', $phone)->first();
        //     $user->verify_code = $code;
        //     $user->save();
            
        // }else{
        //     if(!$request->has('type') || $request->get('type') != 'update' )
        //     {
        //         $user = User::create(['phone' => $phone]);
        //     }else{
                if (!Request()->has('resend')) {
                    
                    $user = auth('api')->user();
                    if(!$user)
                    {
                        return Response()->json([
                            'data'   => new \stdClass,
                            'errors'       => [' '],
                            'message'       => 'authFailed',
                            'code'          => getMsgCode('authFailed'),
                        ]);
                    }
                    if(User::where('phone', $phone)->where('id', '<>', $user->id)->count() > 0)
                    {
                        return Response()->json([
                                'data' => new \stdClass,
                                'errors' => ['هذا الهاتف مسجل من قبل.'],
                                'message' => 'validationErrors',
                                'code' => getMsgCode('validationErrors')
                        ]);
                    }
                    
                }else{
                    $phone = $request->get('phone');
                    $user = User::where('phone', $phone)->first();
                    if(!$user)
                    {
                        return Response()->json([
                                'data' => new \stdClass,
                                'errors' => ['هذا الهاتف غير مسجل من قبل.'],
                                'message' => 'validationErrors',
                                'code' => getMsgCode('validationErrors')
                        ]);
                    }
                }
        //     }
        // }
            $user->verify_code = $code;
            $user->save();
            try{
                $result=$this->sendSMS($phone, 'code:'.$code);
            }catch(\Exception $e){

            }
            
            
            //لتحويل النتيجة إلى  array
            // return $result = json_decode($result, true);
            
            // return $user;
            return Response()->json([
                    'data' => [
                        'phone' => $phone,
                        'code' => $code
                    ],
                    'message' => 'success',
                    'code' => getMsgCode('success')
            ]);
    }
    public function sendSMS($destinations, $message)
    {
        // $username = "Aljeri";		    // اسم المستخدم الخاص بك في الموقع 
        // $password = "SmSaljeri_1330"; 		// كلمة المرور الخاصة بك 
        // $destinations = $destinations; //الارقام المرسل لها  ,, يتم وضع فاصلة بين الارقام المراد الارسال لها 
        // $message = $message;      // محتوى الرسالة 
        // $sender = "JTC";         // اسم المرسل الخاص بك المفعل  في الموقع 
        // $url = "http://www.jawalbsms.ws/api.php/sendsms?user=$username&pass=$password&to=$destinations&message=$message&sender=$sender";

        // $ch = curl_init($url); // init the curl with jawalb API url
        // curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);   
        // curl_setopt($ch, CURLOPT_HEADER, 0);
        // $data = curl_exec($ch);  //run curl api call, on success curl call, $data will contain the API call response
        // curl_close($ch);
        // // print_r($data);
            
        $postRequest = array(
            'body' => $message,
            'sender' => 'OTCRENT',
            'recipients' => [
                $destinations
            ]
        );

        $cURLConnection = curl_init('https://api.taqnyat.sa/v1/messages');
        curl_setopt($cURLConnection, CURLOPT_POSTFIELDS, json_encode($postRequest));
        curl_setopt($cURLConnection, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($cURLConnection, CURLOPT_HTTPHEADER, array(
            'Authorization: Bearer 2097057f9ffbb1836fa24795c10e7915',
            'Content-Type: application/json'
        ));

        $apiResponse = curl_exec($cURLConnection);
        curl_close($cURLConnection);

        // $apiResponse - available data from the API request
        $jsonArrayResponse = json_decode($apiResponse);
        return $jsonArrayResponse;
    }

    public function phoneVerify()
    {
        $phone        = Request()->get('phone');
        $verifyData  = Request()->all();

        if ($user = User::where('verify_code',$verifyData['code'])->where('phone',$phone)->first() ){

            if( $user->update(['verify' => 1]) ){

                $user->token = auth('api')->tokenById($user->id);
                return response()->json([
                        'data'      => [
                                'user' => $user,
                        ],
                        'message'   => 'success',
                        'code'      => getMsgCode()
                ]);

            }else{
                return response()->json([
                    'data'   => new \stdClass,
                    'errors'       => [' '],
                    'message'   => 'something went wrong',
                    'code'      => getMsgCode('somethingWrong')
                ]);
            }


        }else{
             return response()->json([
                    'data'   => new \stdClass,
                    'errors'       => [' '],
                    'message'   => 'worng phone verification number',
                    'code'      => getMsgCode('wrongPhoneVerifyNum')
            ]);
        }
    }
    

    public function sendVerifyForgetPasswordNum()
    {
        $data = request()->all();

        $user = User::where('phone',$data['phone'])->first();

        if (!$user) {
            return response()->json([
                    'data'   => new \stdClass,
                    'errors'       => [' '],
                    'message'   => 'not found',
                    'code'      => getMsgCode('notFound')
            ]);
        }


        $code = '2222';//mt_rand(1000,9999);

        $this->sendSMS($user->phone, 'code:'.$code);

        $sendVerifyForgetPassMessage = true;

        if ($sendVerifyForgetPassMessage) {
               $user->update(['verify_code' => $code]);

               return response()->json([
                    'data'      => [
                        'user_phone'  => $user->phone,
                    ],
                    'message'   => 'success',
                    'code'      => getMsgCode()
               ]);

        }else{
            return response()->json([
                'data'   => new \stdClass,
                'errors'       => [' '],
                'message'   => 'something went wrong',
                'code'      => getMsgCode('somethingWrong')
            ]);
        }
    }

    public function verifyForgetPassword()
    {
        $verifyData = request()->all();

        $user = User::where('phone',$verifyData['phone'])->where('verify_code',$verifyData['code'])->first();

        if (!$user) {
            return response()->json([
                'data'   => new \stdClass,
                'errors'       => [' '],
                'message'   => 'not found',
                'code'      => getMsgCode('notFound')
            ]);
        }

        if ($user){
            $user->token = auth('api')->tokenById($user->id);

            return response()->json([
                'data'      => [
                        'user' => $user,
                ],
                'message'   => 'success',
                'code'      => getMsgCode()
            ]);

        }else{
             return response()->json([
                'data'   => new \stdClass,
                'errors'       => [' '],
                'message'   => 'worng forget password verification number',
                'code'      => getMsgCode('wrongForgetPassVerifyNum')
            ]);
        }
    }
    public function MyOrdersRate(Request $request)
    {
        $user = auth('api')->user();
        $rates = OrderRating::whereHas('Order', function($q) use($user){
            $q->whereHas('Product', function($qq) use($user){
                $qq->where('user_id', $user->id);
            });
        })->with('User');
        $count = $rates->count();
        $rate_sum = $rates->sum('rate');
        $rates = $rates->get();
        try{
            // 
            $value = $rate_sum / $count;
        }catch(\Exception $e){
            // 
            $value = 0;
        }
        return Response()->json([
            'data' => [
                'rates' => $rates,
                'count' => $count,
                'value' => $value,
            ],
            'message' => 'success',
            'code' => getMsgCode('success')
        ]);
    }
    
    public function CheckUser(Request $request)
    {
        if ($request->has('email') && $request->get('email') != '' ) {
            $user = User::where('email',$request->get('email') )->first();
        }elseif ($request->has('phone') && $request->get('phone') != '' ) {
            $user = User::where('phone',$request->get('phone') )->first();
        }else{
            $user = false;
        }
        

        if (!$user) {
            return response()->json([
                'data'   => [
                    'result' => false
                ],
                'message'   => 'مش موجودين',
                'code'      => getMsgCode('success')
            ]);
        }

            return response()->json([
                'data'   => [
                    'result' => true
                ],
                'message'   => 'موجودين',
                'code'      => getMsgCode()
            ]);

    }
    
    public function CheckVIP(Request $request)
    {
        $user = false;
        $check = false;
            $msg = '';
        if ($request->has('email') && $request->get('email') != '' ) {
            $user = BusinessAccount::where('email',$request->get('email') )->first();
            if($user)
            {
                $check = true;
                $msg .= 'البريد الالكتروني مستخدم مسبقا ,';
            }
        }
        if ($request->has('phone') && $request->get('phone') != '' ) {
            $user = BusinessAccount::where('phone',$request->get('phone') )->first();
            if($user)
            {
                $check = true;
                $msg .= 'رقم الهاتف مستخدم مسبقا , ';
            }
        }
        if ($request->has('registration_number') && $request->get('registration_number') != '' ) {
            $user = BusinessAccount::where('registration_number',$request->get('registration_number') )->first();
            if($user)
            {
                $check = true;
                $msg .= 'رقم السجل التجاري مستخدم مسبقا , ';
            }
        }
        

        if ($check) {
            return response()->json([
                'data'   => [
                    'result' => true
                ],
                'message'   => $msg,
                'code'      => getMsgCode('success')
            ]);
        }

            return response()->json([
                'data'   => [
                    'result' => false
                ],
                'message'   => '',
                'code'      => getMsgCode()
            ]);

    }

}
