<?php

namespace App\Http\Controllers\Api;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Setting;
use App\Models\City;
use App\Models\Category;
use App\Models\Product;
use App\Models\Mission;
use App\Models\Slider;
use App\Models\OrderItemDay;
use App\Models\Cart;
use App\Models\Vacation;
use Carbon\Carbon;

class PageController extends Controller
{
    public function home(Request $request)
    {
        $ids = scandir(public_path('/cdn/products'));
        $cities = City::whereHas('Products')->latest()->get();
        $sliders = Slider::latest()->get();
        $missions = Mission::latest()->get();
        $categories = Category::latest()->get();
        $best_sales = Product::whereNotNull('id')->whereIn('product_number', $ids);
        $nearest = Product::whereNotNull('id')->whereIn('product_number', $ids);
        $products = Product::whereNotNull('id')->whereIn('product_number', $ids);
        if (Request()->header('city_id') && Request()->header('city_id') != '') {
            $best_sales = $best_sales->whereHas('ProductCity', function($q){
                                                $q->where('city_id', Request()->header('city_id') );
                                            });
            // $nearest = $nearest->where('city_id', Request()->get('city_id') );
            $products = $products->whereHas('ProductCity', function($q){
                                        $q->where('city_id', Request()->header('city_id') );
                                    });
        }
        if (Request()->has('mission_id') && Request()->get('mission_id') != '' && Request()->get('mission_id') != '-1') {
            $products = $products->where('mission_id', Request()->get('mission_id') );
            $best_sales = $best_sales->where('mission_id', Request()->get('mission_id') );
            $nearest = $nearest->where('mission_id', Request()->get('mission_id') );
        }
        if (Request()->has('category_id') && Request()->get('category_id') != '' && Request()->get('category_id') != '-1') {
            $products = $products->where('category_id', Request()->get('category_id') );
            $best_sales = $best_sales->where('category_id', Request()->get('category_id') );
            $nearest = $nearest->where('category_id', Request()->get('category_id') );
        }
        if ($request->has('sort_by_price') && $request->get('sort_by_price') != '') {
            $sort_by_price = $request->get('sort_by_price');
            if ($sort_by_price == 'asc') {
                $products = $products->orderBy('price', 'asc');
                $best_sales = $best_sales->orderBy('price', 'asc');
                $nearest = $nearest->orderBy('price', 'asc');
            } else {
                $products = $products->orderBy('price', 'desc');
                $best_sales = $best_sales->orderBy('price', 'desc');
                $nearest = $nearest->orderBy('price', 'desc');

            }

        }else{
            $products = $products->orderBy('id', 'desc');
            $best_sales = $best_sales->orderBy('id', 'desc');
            $nearest = $nearest->orderBy('id', 'desc');

        }
        $best_sales = $best_sales->limit(10)->get();
        $nearest = $nearest->limit(10)->get();
        if (Request()->has('page_count')) {
            $count = Request()->get('page_count');
        }else{
            $count = 20;
        }
        $products = $products->paginate($count);
        if (auth('api')->user()) {
            $cart_count = auth('api')->user()->Cart()->count();
        }else if(Request()->header('uuid')){
            $cart_count = Cart::where('uuid', Request()->header('uuid') )->count();
        }else{
            $cart_count = 0;
        }
        if (auth('api')->user()) {
            $noti_count = auth('api')->user()->unreadnotifications();
        } else {
            $noti_count = 0;
        }

        return Response()->json([
                'data' => [
                    // 'cities' => $cities,
                    'sliders' => $sliders,
                    'categories' => $categories,
                    'missions' => $missions,
                    'best_sales' => $best_sales,
                    'nearest' => $nearest,
                    'products' => $products,
                    'cart_count' => $cart_count,
                    'notification_count' => $noti_count,
                ],
                'message' => 'success',
                'code' => getMsgCode('success')
        ]);
    }
    public function Cities()
    {

        $cities = City::whereHas('Products')->latest()->get();
        return Response()->json([
                'data' => [
                    'cities' => $cities,
                ],
                'message' => 'success',
                'code' => getMsgCode('success')
        ]);
    }
    public function filter(Request $request)
    {
        $ids = scandir(public_path('/cdn/products'));
        $missions = Mission::latest()->get();
        $categories = Category::latest()->get();
        $result = Product::whereNotNull('id')->whereIn('product_number', $ids);
        if (Request()->has('mission_id') && Request()->get('mission_id') != '') {
            $result = $result->where('mission_id', Request()->get('mission_id') );
        }
        if (Request()->has('category_id') && Request()->get('category_id') != '') {
            $result = $result->where('category_id', Request()->get('category_id') );
        }
        if (Request()->header('city_id') && Request()->header('city_id') != '') {
            $result = $result->whereHas('ProductCity', function($q){
                $q->where('city_id', Request()->header('city_id') );
            });
        }
        if (Request()->has('type') && Request()->get('type') != '') {
            $result = $result->where('type', Request()->get('type') );
        }
        if (Request()->has('search') && Request()->get('search') != '') {
            $result = $result->where('title', 'LIKE', '%'.Request()->get('search') .'%' );
        }
        if ($request->has('sort_by_price') && $request->get('sort_by_price') != '') {
            $sort_by_price = $request->get('sort_by_price');
            if ($sort_by_price == 'asc') {
                $result = $result->orderBy('price', 'asc');
            } else {
                $result = $result->orderBy('price', 'desc');
            }
        }else{
            $result = $result->orderBy('id', 'desc');
        }
        if (Request()->has('page_count')) {
            $count = Request()->get('page_count');
        }else{
            $count = 20;
        }
        $result = $result->paginate($count);
        return Response()->json([
                'data' => [
                    'categories'    => $categories,
                    'missions'      => $missions,
                    'result'           => $result,
                ],
                'message' => 'success',
                'code' => getMsgCode('success')
        ]);
    }

    public function productView($id)
    {
        $product  = Product::where('id', $id)->with('Year')->with('Branch')->with('Mission')->with('Category')->with('Models')->first();
        if (!$product) {
            return Response()->json([
                'data'          => new \stdClass,
                'errors'        => [trans('words.product not found')],
                'message'       => trans('words.product not found'),
                'code'          => getMsgCode('notFound'),
            ]);
        }
        // if ($product->type == 'rent') {
        //     $not_available_dates = $product->OrderItem()->where('rent_type', 'time')->pluck('id')->toArray();
        //     $not_available_dates = OrderItemDay::whereIn('order_item_id', $not_available_dates)->pluck('day_date')->toArray();
        //     $product->not_available_dates = $not_available_dates;
        // }
        if ($product->type == 'rent') {
            $vacations = Vacation::whereDate('day_date', '>=', Carbon::now() )->pluck('day_date')->toArray();
            $not_available_dates = $product->OrderItem()->where('rent_type', 'day')->pluck('id')->toArray();
            $not_available_dates = array_merge(OrderItemDay::whereIn('order_item_id', $not_available_dates)->pluck('day_date')->toArray(), $vacations);
            $not_available_dates = array_merge($not_available_dates, [Carbon::now()->format('Y-m-d')]);
            $not_available_times = $product->OrderItem()->where('rent_type', 'time')->pluck('id')->toArray();
            $not_available_times = OrderItemDay::whereIn('order_item_id', $not_available_times)->get()->unique('day_date')->each(function($item){
                $times = OrderItemDay::whereHas('OrderItem', function ($q) use ($item){
                    // dd($item->OrderItem()->first());
                    $q->where('product_id', $item->OrderItem()->first()->product_id);
                })->whereNotNull('time_from')->where('day_date', $item->day_date)->select('time_from', 'time_to')->get();
                $item->times = $times;
            })->makeHidden(['time_from', 'time_to', 'order_item_id', 'created_at', 'updated_at', 'id'])->toArray();
            $not_available_times = array_values($not_available_times);
            $product->not_available_dates = $not_available_dates;
            $product->not_available_times = $not_available_times;
            // $not_available_dates = $product->OrderItem()
            //                                 ->whereHas('Order', function($q){
            //                                     $q->where('status', '<>', 'completed');
            //                                 })
            //                                 ->where('rent_type', 'day')
            //                                 ->pluck('id')->toArray();
            // $not_available_dates = OrderItemDay::whereIn('order_item_id', $not_available_dates)
            //                                     ->where('day_date', '>=',Carbon::now())
            //                                     ->pluck('day_date')
            //                                     ->toArray();
            // $not_available_times = $product->OrderItem()
            //                                 ->whereHas('Order', function($q){
            //                                     $q->where('status', '<>', 'completed');
            //                                 })
            //                                 ->where('rent_type', 'time')
            //                                 ->pluck('id')->toArray();
            // $not_available_times = OrderItemDay::whereIn('order_item_id', $not_available_times)
            //                                     ->where('day_date', '>=',Carbon::now())
            //                                     ->get()
            //                                     ->unique('day_date')
            //                                     ->each(function($item){
            //     $times = OrderItemDay::whereHas('OrderItem', function ($q) use ($item){
            //         // dd($item->OrderItem()->first());
            //         $q->where('product_id', $item->OrderItem()->first()->product_id);
            //     })->whereNotNull('time_from')->where('day_date', $item->day_date)->select('time_from', 'time_to')->get();
            //     $item->times = $times;
            // })->makeHidden(['time_from', 'time_to', 'order_item_id', 'created_at', 'updated_at', 'id'])->toArray();
            // $not_available_times = array_values($not_available_times);
            // $product->not_available_dates = $not_available_dates;
            // $product->not_available_times = $not_available_times;
        }

        $recommended_products = Product::where('branch_id',$product->branch_id)
                                        ->where('model_id',$product->model_id)
                                        ->where('category_id',$product->category_id)
                                        ->where('mission_id',$product->mission_id)
                                        ->where('type',$product->type)
                                        ->where('id', '<>',$product->id)
                                        ->limit(4)->get();
        return Response()->json([
            'data' => [
                'product'    => $product,
                'recommended_products'    => $recommended_products,
            ],
            'message' => 'success',
            'code' => getMsgCode('success')
        ]);
    }
}
