<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Traits\Admin\VacationOperations;
use Illuminate\Http\Request;
use App\Models\Admin;
use App\Models\Vacation;
use Auth;
use Carbon\Carbon;

class VacationController extends Controller
{
    // use VacationOperations;
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */

    
    public function index()
    {
        $search = [];
        $title = 'الاجازات';
        $rows = Vacation::latest()->paginate(40);
        return view('admin.vacations.index', compact('title', 'rows', 'search'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $title = 'اضافة ';
        return view('admin.vacations.add', compact('title'))->render();
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        Vacation::create($request->all());
        return redirect(route('vacations.index'))->with('success', 'data added successfully');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show(Vacation $vacation)
    {
        $title = 'عرض ';
        return view('admin.vacations.show', compact('vacation', 'title'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $vacation = Vacation::find($id);
        $title = 'تعديل ';
        return view('admin.vacations.edit', compact('vacation', 'title'))->render();
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
      
        $vacation = Vacation::find($id);
        $vacation->update($request->all());
      
        return redirect(route('vacations.index'));
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        Vacation::where('id', $id)->delete();
       
        return redirect(route('vacations.index'));
    }
}
