<?php

namespace App\Http\Controllers\Admin;


use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\User;
use App\Models\Files;
use App\Models\Driver;
use Auth;

class AjaxController extends Controller
{
    
    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function ClassRooms(Request $request, $id)
    {
        $items = ClassRoom::where( 'educational_level_id', $id)->get();
        return view('admin.ajax.class_rooms', compact('items'));
    }
    
    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function BusTypes(Request $request, $id)
    {
        $items = BusType::where( 'bus_class_id', $id)->get();
        return view('admin.ajax.bus_types', compact('items'));
    }
    public function GetDriversByType(Request $request, $type)
    {
        if ($type == 'external') {
            $items = Driver::where('type', 'not_employee')->get();
            $title = 'اختر سائق خارجي';
        } else {
            $items = Driver::where('type', '<>', 'not_employee')->get();
            $title = 'احتر سائق داخلي';
        }
        
        return view('admin.ajax.select.items', compact('items', 'title'));
    }

    public function DeleteFile(Request $request, $id)
    {
        
        if ($id == '0' && $request->has('name') ) {
            @unlink(public_path($request->get('name')));
        }else{
            Files::where('id', $id)->delete();

        }
        return Response()->json([
            'data' => [
                
            ],
            'message' => 'success',
            'code' => getMsgCode('success')
    ]);
    }
}
