<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class OrderItemDay extends Model
{
    protected $table='order_item_days';
    protected $fillable = [
        'order_item_id', 'day_date', 'time_from', 'time_to',
    ];
    protected $casts = [
        'created_at' => 'datetime:d/m/Y',
        'updated_at' => 'datetime:d/m/Y',
    ];

    public function OrderItem()
    {
        return $this->belongsTo(OrderItem::class,'order_item_id');
    }
}
