<?php

namespace App\Http\Controllers\Api;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

class ProductRateController extends Controller
{
    public function index(Request $request)
    {
        $user = auth('api')->user();
        $rates = $user->ProductRating()->with('Product')->with('User')->get();
        return Response()->json([
            'data' => [
                'rates' => $rates,
            ],
            'message' => 'success',
            'code' => getMsgCode('success')
        ]);
    }
    public function store(Request $request)
    {
        $user = auth('api')->user();
        $data = $request->all();
        $user->ProductRating()->create($data);
        return Response()->json([
            'data' => [
            ],
            'message' => 'success',
            'code' => getMsgCode('success')
        ]);
    }
}
