<?php

namespace App\Http\Controllers\Api;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Product;
use App\Models\Cart;
use Carbon\Carbon;

class OldCartNoAuthController extends Controller
{
    public function addToCart(Request $request)
    {
        $uuid = Request()->header('uuid');
        if ($request->has('empty') && $request->empty == '1') {
            Cart::where('uuid', $uuid)->delete();
        }
        $data = $request->all();
        // check product type
        $product = Product::find($request->get('product_id'));
        if (!$product) {
            return Response()->json([
                'data'          => new \stdClass,
                'errors'        => [trans('words.product not found')],
                'message'       => trans('words.product not found'),
                'code'          => getMsgCode('notFound'),
            ]);
        }
        if (Cart::where('uuid', $uuid)->where('product_type', '<>', $product->type)->count() > 0 ) {
            return Response()->json([
                'data'          => new \stdClass,
                'errors'        => [trans('words.different types not allowed in cart.')],
                'message'       => trans('words.different types not allowed in cart.'),
                'code'          => getMsgCode('somethingWrong'),
            ]);
        }
        // check product exist
        if ($item = Cart::where('uuid', $uuid)->where('product_id', $product->id)->first() ) {
            $data['product_type'] = $product->type;
            if($product->quantity && ($item->quantity + $request->quantity) > $product->quantity)
            {
                return Response()->json([
                    'data'          => new \stdClass,
                    'errors'        => [trans('words.quantity not available')],
                    'message'       => trans('words.quantity not available'),
                    'code'          => getMsgCode('somethingWrong'),
                ]);
            }
            $data['quantity'] = $item->quantity + $request->quantity;
            if ($product->gasoline && $product->type == 'rent') {
                $data['gasoline_cost'] = $product->gasoline * (float)getSettingValue('gasoline_cost');
            }
            $item->update($data);
        }else{
            $data['product_type'] = $product->type;
            $data['uuid'] = $uuid;
            if ($product->gasoline && $product->type == 'rent') {
                $data['gasoline_cost'] = $product->gasoline * (float)getSettingValue('gasoline_cost');
            }
            if($product->quantity && $request->quantity > $product->quantity)
            {
                return Response()->json([
                    'data'          => new \stdClass,
                    'errors'        => [trans('words.quantity not available')],
                    'message'       => trans('words.quantity not available'),
                    'code'          => getMsgCode('somethingWrong'),
                ]);
            }
            $item = Cart::create($data);
        }
        $item->CartItemDay()->delete();
        if ($data['product_type'] == 'rent') {
            if ($request->has('city_id') && $product->ProductCity()->where('city_id', $request->city_id)) {
                $move_cost = $product->ProductCity()->where('city_id', $request->city_id)->first()->cost; 
            }else{
                $move_cost = 0;
            }
            $item->update(['move_cost' => $move_cost]);
            // array of days start
            if ($data['rent_type'] == 'day' && isset( $data['rent_days'] ) && is_array(  $data['rent_days']  ) ) {
                foreach ($data['rent_days'] as $day) {
                    $item->CartItemDay()->create( ['day_date' => $day] );
                }
            }
            if ($data['rent_type'] == 'time' && isset( $data['rent_day_time'] ) && is_array(  $data['rent_day_time']  ) ) {
                    $item->CartItemDay()->create( $data['rent_day_time'] );
            }
        }
        $move_cost = Cart::where('uuid', $uuid)->sum('move_cost');
        $gasoline_cost = Cart::where('uuid', $uuid)->sum('gasoline_cost');
        $cart = Cart::where('uuid', $uuid)->with('Product')->get();
        $total_price = 0;
        foreach ($cart as $item) {
            $product = $item->Product()->first();
            if ($product) {
                
                if ($item->product_type == 'rent') {
                    // 
                    if ($item->rent_type == 'day') {
                        $total_price += $item->CartItemDay()->count() * $product->daily_price;  
                    } else {
                        if ($item->CartItemDay()->first()) {
                            
                            $from = Carbon::createFromFormat('Y-m-d H:s:i', $item->CartItemDay()->first()->day_date . ' ' . $item->CartItemDay()->first()->time_from);
                            $to = Carbon::createFromFormat('Y-m-d H:s:i', $item->CartItemDay()->first()->day_date . ' ' . $item->CartItemDay()->first()->time_to);
                            $diff_in_hours = $to->diffInHours($from);
                            $total_price += $diff_in_hours * $product->hour_price; 
                        }
                    }
                if ($request->has('city_id') && $product->ProductCity()->where('city_id', $request->city_id)) {
                    $move_cost2 = $product->ProductCity()->where('city_id', $request->city_id)->first()->cost; 
                }else{
                    $move_cost2 = 0;
                }
                $move_cost += $move_cost2;
                    
                }else{
                    $total_price += $item->quantity * $item->Product->price;
                }
            }
        }
        return Response()->json([
            'data'          => [
                'cart'  => $cart,
                'sub_total_price'  => $total_price,
                'total_price'  => $total_price + $move_cost + $gasoline_cost + (round((float)getSettingValue('tax'),2) / 100 * $total_price),
                'move_cost'  => $move_cost,
                'vat'  => round((float)getSettingValue('tax'),2),
                'vat_cost'  => round((float)getSettingValue('tax'),2) / 100 * $total_price,
                'gasoline_cost'  => $gasoline_cost,
            ],
            'message'       => 'success',
            'code'          => getMsgCode('success'),
        ]);
    }
    public function viewCart(Request $request)
    {
        $uuid = Request()->header('uuid');
        $move_cost = 0;//Cart::where('uuid', $uuid)->sum('move_cost');
        $gasoline_cost =  Cart::where('uuid', $uuid)->sum('gasoline_cost');
        $cart = Cart::where('uuid', $uuid)->with('Product')->get();
        $total_price = 0;
        foreach ($cart as $item) {
            $product = $item->Product()->first();
            if ($product) {
                
                if ($item->product_type == 'rent') {
                    // 
                    if ($item->rent_type == 'day') {
                        $total_price += $item->CartItemDay()->count() * $product->daily_price;  
                    } else {
                        if ($item->CartItemDay()->first()) {
                            
                            $from = Carbon::createFromFormat('Y-m-d H:s:i', $item->CartItemDay()->first()->day_date . ' ' . $item->CartItemDay()->first()->time_from);
                            $to = Carbon::createFromFormat('Y-m-d H:s:i', $item->CartItemDay()->first()->day_date . ' ' . $item->CartItemDay()->first()->time_to);
                            $diff_in_hours = $to->diffInHours($from);
                            $total_price += $diff_in_hours * $product->hour_price; 
                        }
                    }
                if ($request->has('city_id') && $product->ProductCity()->where('city_id', $request->city_id)) {
                    $move_cost2 = $product->ProductCity()->where('city_id', $request->city_id)->first()->cost; 
                }else{
                    $move_cost2 = 0;
                }
                $move_cost += $move_cost2;
                    
                }else{
                    $total_price += $item->quantity * $item->Product->price;
                }
            }
        }
        if (Cart::where('uuid', $uuid)->first()) {
            $type = Cart::where('uuid', $uuid)->first()->product_type;
        } else {
            $type = null;
        }
        
        return Response()->json([
            'data'          => [
                'cart'  => $cart,
                'sub_total_price'  => $total_price,
                'total_price'  => $total_price + $move_cost + $gasoline_cost + (round((float)getSettingValue('tax'),2) / 100 * $total_price),
                'move_cost'  => $move_cost,
                'vat'  => round((float)getSettingValue('tax'),2),
                'vat_cost'  => round((float)getSettingValue('tax'),2) / 100 * $total_price,
                'gasoline_cost'  => $gasoline_cost,
                'type'  => $type,
            ],
            'message'       => 'success',
            'code'          => getMsgCode('success'),
        ]);
    }
    public function removeFromCart(Request $request)
    {
        $uuid = Request()->header('uuid');
        $product = Product::find($request->get('product_id'));
        if (!$product) {
            return Response()->json([
                'data'          => new \stdClass,
                'errors'        => [trans('words.product not found')],
                'message'       => trans('words.product not found'),
                'code'          => getMsgCode('notFound'),
            ]);
        }
        Cart::where('uuid', $uuid)->where('product_id', $product->id)->delete();
        $move_cost = Cart::where('uuid', $uuid)->sum('move_cost');
        $gasoline_cost = Cart::where('uuid', $uuid)->sum('gasoline_cost');
        $cart = Cart::where('uuid', $uuid)->with('Product')->get();
        $total_price = 0;
        foreach ($cart as $item) {
            $total_price += $item->quantity * $item->Product->price;
        }
        return Response()->json([
            'data'          => [
                'cart'  => $cart,
                'sub_total_price'  => $total_price,
                'total_price'  => $total_price + $move_cost + $gasoline_cost + (round((float)getSettingValue('tax'),2) / 100 * $total_price),
                'move_cost'  => $move_cost,
                'vat'  => round((float)getSettingValue('tax'),2),
                'vat_cost'  => round((float)getSettingValue('tax'),2) / 100 * $total_price,
                'gasoline_cost'  => $gasoline_cost,
            ],
            'message'       => 'success',
            'code'          => getMsgCode('success'),
        ]);
    }
    public function updateCartItem(Request $request, $id)
    {
        $uuid = Request()->header('uuid');
        $data = $request->all();
        Cart::where('uuid', $uuid)->where('id', $id)->update($data);
        return $this->viewCart($request);
    }
}
