<?php

namespace App\Http\Controllers\Admin;

use App\Http\Requests\Admin\UpdateUserRequest;
use App\Http\Requests\Admin\StoreUserRequest;
use App\Http\Controllers\Controller;
use App\Traits\Admin\UserOperations;
use Illuminate\Http\Request;
use App\Models\Admin;
use App\Models\User;
use App\Models\Department;
use Auth;
use Validator;
use App\Exports\GeneralExport;
use App\Models\CompanyOrderItem;
use App\Models\OrderItem;
use Maatwebsite\Excel\Facades\Excel;

class UserController extends Controller
{
    use UserOperations;
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */

    public function __construct()
    {
        // $this->middleware('Permission:user_show'    , ['only' => 'index', 'show']);
        // $this->middleware('Permission:user_add'     , ['only' => 'create', 'store']);
        // $this->middleware('Permission:user_edit'    , ['only' => 'edit', 'update']);
        // $this->middleware('Permission:user_delete'  , ['only' => 'destroy']);
    }

    public function index()
    {
        if (Request()->has('type') && Request()->get('type') == 'user') {
            # code...
            $users = User::where('role', 'user')->latest();
        } elseif (Request()->has('type') && Request()->get('type') == 'admin') {
            # code...
            $users = User::where('role','<>', 'user')->latest();
        }else {
            $users = User::latest();
        }


        $search = array();
        if (Request()->has('name') && Request()->get('name') != '') {
            $name = Request()->get('name');
            $search['name'] = $name;
            $users = $users->where('name'     , 'LIKE', '%'.$name.'%');
        }
        if (Request()->has('phone') && Request()->get('phone') != '') {
            $phone = Request()->get('phone');
            $search['phone'] = $phone;
            $users = $users->where('phone'     , 'LIKE', '%'.$phone.'%');
        }
        if (Request()->has('region_id') && Request()->get('region_id') != '') {
            $region_id = Request()->get('region_id');
            $search['region_id'] = $region_id;
            $users = $users->where('region_id'     , 'LIKE', '%'.$region_id.'%');
        }
        if (Request()->has('city_id') && Request()->get('city_id') != '') {
            $city_id = Request()->get('city_id');
            $search['city_id'] = $city_id;
            $users = $users->where('city_id'     , 'LIKE', '%'.$city_id.'%');
        }
        if (Request()->has('district_id') && Request()->get('district_id') != '') {
            $district_id = Request()->get('district_id');
            $search['district_id'] = $district_id;
            $users = $users->where('district_id'     , 'LIKE', '%'.$district_id.'%');
        }
        if (Request()->has('client_type') && Request()->get('client_type') != '') {
            $client_type = Request()->get('client_type');
            $search['client_type'] = $client_type;
            $users = $users->where($client_type , '1');
        }
        // excport to excel
        if(Request()->has('excel') && Request()->get('excel') == '1')
        {
            return Excel::download(new GeneralExport('admin.excel.users', $users->get()), 'users.xlsx');
        }
        // excport to excel
        $users = $users->paginate(20);

        $title = 'المستخدمين';
        return view('admin.users.index', compact('users', 'title', 'search'));
    }
    public function indexPost(Request $request)
    {
        // return $request->all();
        $users = User::whereNotNull('id');
        $search = array();
        if ($request->has('sort_by') && $request->sort_by != '') {
            $users = $users->orderBy($request->sort_by, $request->sort_type);
            $search['sort_by'] = $request->sort_by;
            $search['sort_type'] = $request->sort_type;
        }else{
            $users = $users->latest();
        }
        // $search = array();
        if (Request()->has('name') && Request()->get('name') != '') {
            $name = Request()->get('name');
            $search['name'] = $name;
            $users = $users->where('name'     , 'LIKE', '%'.$name.'%');
        }
        if (Request()->has('phone') && Request()->get('phone') != '') {
            $phone = Request()->get('phone');
            $search['phone'] = $phone;
            $users = $users->where('phone'     , 'LIKE', '%'.$phone.'%');
        }
        if (Request()->has('region_id') && Request()->get('region_id') != '') {
            $region_id = Request()->get('region_id');
            $search['region_id'] = $region_id;
            $users = $users->where('region_id'     , 'LIKE', '%'.$region_id.'%');
        }
        if (Request()->has('city_id') && Request()->get('city_id') != '') {
            $city_id = Request()->get('city_id');
            $search['city_id'] = $city_id;
            $users = $users->where('city_id'     , 'LIKE', '%'.$city_id.'%');
        }
        if (Request()->has('district_id') && Request()->get('district_id') != '') {
            $district_id = Request()->get('district_id');
            $search['district_id'] = $district_id;
            $users = $users->where('district_id'     , 'LIKE', '%'.$district_id.'%');
        }
        if (Request()->has('client_type') && Request()->get('client_type') != '') {
            $client_type = Request()->get('client_type');
            $search['client_type'] = $client_type;
            $users = $users->where($client_type , '1');
        }
        // excport to excel
        if(Request()->has('excel') && Request()->get('excel') == '1')
        {
            return Excel::download(new GeneralExport('admin.excel.users', $users->get()), 'users.xlsx');
        }
        // excport to excel
        $users = $users->paginate(20)->setPath(route('users.index'));

        $title = 'المستخدمين';
        $view = view('admin.users.table', compact('users', 'title', 'search'))->render();
        // $view = view('admin.products.table', compact('products', 'title', 'search'));
        return response()->json([
            'code' => 200,
            'view' => $view
        ], 200);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $title = 'اضافة مستخدم';
        return view('admin.users.add', compact('title'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(StoreUserRequest $request)
    {
        // return $request->all();
        $this->register($request);
        return redirect('/dashboard/users')->with('success', 'data added successfully');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show(User $user)
    {
        $title = 'عرض مستخدم';
        return view('admin.users.show', compact('user', 'title'));
    }
    public function UserInfo($id)
    {
        $user = User::find($id);
        $title = 'عرض مستخدم';
        return view('admin.users.ajax_data', compact('user', 'title'))->render();
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $user = User::find($id);
        $user->business = $user->BusinessAccount()->first();
        $title = 'تعديل مستخدم';
        return view('admin.users.edit', compact('user', 'title'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(UpdateUserRequest $request, User $user)
    {
        // $user = User::find($id);
        $this->UpdateRecords($user, $request);
        return redirect('/dashboard/users')->with('success', 'data added successfully');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(User $user)
    {
        if ($user->image) {
            @unlink(public_path('/cdn/'.$user->image));
        }
        $user->delete();
        return 'success';
    }
    public function deleteArray(Request $request)
    {
        if ($request->has('ids') && is_array($request->ids) && sizeof($request->ids) > 0 ) {
            foreach ($request->ids as $id) {
                $pro = User::find($id);
                if($pro){
                    $pro->Cart()->delete();
                    $order_ids = $pro->CompanyOrder()->pluck('id')->toArray();
                    CompanyOrderItem::whereIn('company_order_id', $order_ids)->delete();
                    $pro->CompanyOrder()->delete();
                    $order_ids = $pro->Order()->pluck('id')->toArray();
                    OrderItem::whereIn('order_id', $order_ids)->delete();
                    $pro->Order()->delete();
                    $pro->Product()->delete();
                    $pro->PlayerId()->delete();
                    $this->destroy($pro);
                }
            }
        }
        return response()->json([
            'message' => "تم الحذف بنجاح",
            'code' => 200
        ]);
    }
    public function updateArray(Request $request)
    {
        // return $request->all();
        $data = $request->only(['mission_id', 'category_id', 'branch_id', 'active']);
        if (trim($data['mission_id']) == '') unset($data['mission_id']);
        if (trim($data['category_id']) == '') unset($data['category_id']);
        if (trim($data['branch_id']) == '') unset($data['branch_id']);
        if (isset($data['active']) && trim($data['active']) == '') unset($data['active']);
        if ($request->has('ids') && $request->ids != '' ) {
            $ids = explode(',', $request->ids);
            User::whereIn('id', $ids)->update($data);
        }
        return response()->json([
            'message' => "تم التعديل بنجاح",
            'code' => 200
        ]);
    }
    public function logout()
    {
        Auth::logout();
        return redirect('/login');
    }
    public function storeClient(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'name'          => 'required|max:255',
            'email'         => 'nullable|email|unique:users|max:255',
            'phone'         => 'required|unique:users|max:255',
            // 'password'      => 'required|max:255|min:6',
            'image'         => 'nullable|image',
        ]);
        if ($validator->fails()) {
            $errors = collect($validator->errors());
            $error  = $errors->unique()->first();
            // return $validator->errors();
            return Response()->json([
            'message' => 'error',
            'data' => $error ,
        ]);
        }
        $User = User::create($request->all());
        return Response()->json([
            'message' => 'success',
            'data' => '<option value="'.$User->id.'" selected="">'.$User->name.'</option>',
        ]);
        // return '<option value="'.$User->id.'">'.$User->name.'</option>';
    }
}
