<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\City;
use App\Exports\UnitExport;
use niklasravnsborg\LaravelPdf\Facades\Pdf as PDF;
use Carbon\Carbon;
use App\Exports\GeneralExport;

class ReportController extends Controller
{
	public function cities(Request $request, $type = 'pdf')
	{
		$title = 'cities';
		return view('admin.reports.cities', compact('title'));
	}
	public function citiesPost(Request $request, $type = 'excel')
	{
		$title = 'cities';
		$city = City::find($request->get('city_id'));
		// if type = excel;
		// if (!$request->has('pdf')) {
		// 	return (new citiesExport($cities))->download('cities_ramy_alkelany.xlsx');
		// }
		// if type = excel;
		// $cities = Offer::where('user_id', $request->get('user_id'))->where('type', 'offer')->get();

		$html = view('admin.pdf.cities', compact('city', 'title'))->render();

		$pdfarr = [
			'title' => 'اهلا بكم ',
			'data' => $html, // render file blade with content html
			'header' => ['show' => false], // header content
			'footer' => ['show' => false], // Footer content
			'font' => 'dejavusans', //  dejavusans, aefurat ,aealarabiya ,times
			'font-size' => 12, // font-size 
			'text' => '', //Write
			'rtl' => true, //true or false 
			'creator' => 'ramy invoice', // creator file - you can remove this key
			'keywords' => 'ramy invoice keywords', // keywords file - you can remove this key
			'subject' => 'ramy invoice subject', // subject file - you can remove this key
			'filename' => 'ramy invoice.pdf', // filename example - invoice.pdf
			'display' => 'download', // stream , download , print
		];
		ini_set('memory_limit', '-1');
		$pdf = PDF::loadView('admin.pdf.cities', compact('city', 'title'));
		return $pdf->stream('cities_reo.pdf');
	}

}
