<?php

namespace App\Http\Controllers\Admin;

use App\Http\Requests\Admin\UpdateCompanyRequest;
use App\Http\Requests\Admin\StoreCompanyRequest;
use App\Http\Controllers\Controller;
use App\Traits\Admin\CompanyOperations;
use Illuminate\Http\Request;
use App\Models\Admin;
use App\Models\Company;
use App\Models\Department;
use Auth;
use Validator;
use App\Exports\Exportcompanies;
use Maatwebsite\Excel\Facades\Excel;

class CompanyController extends Controller
{
    use CompanyOperations;
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */

    public function __construct()
    {
        // $this->middleware('Permission:company_show'    , ['only' => 'index', 'show']);
        // $this->middleware('Permission:company_add'     , ['only' => 'create', 'store']);
        // $this->middleware('Permission:company_edit'    , ['only' => 'edit', 'update']);
        // $this->middleware('Permission:company_delete'  , ['only' => 'destroy']);
    }

    public function index()
    {
        
        $companies = Company::latest();
        $search = array();
        if (Request()->has('name') && Request()->get('name') != '') {
            $name = Request()->get('name');
            $search['name'] = $name;
            $companies = $companies->where('name'     , 'LIKE', '%'.$name.'%');
        }
        if (Request()->has('phone') && Request()->get('phone') != '') {
            $phone = Request()->get('phone');
            $search['phone'] = $phone;
            $companies = $companies->where('phone'     , 'LIKE', '%'.$phone.'%');
        }
        if (Request()->has('region_id') && Request()->get('region_id') != '') {
            $region_id = Request()->get('region_id');
            $search['region_id'] = $region_id;
            $companies = $companies->where('region_id'     , 'LIKE', '%'.$region_id.'%');
        }
        if (Request()->has('city_id') && Request()->get('city_id') != '') {
            $city_id = Request()->get('city_id');
            $search['city_id'] = $city_id;
            $companies = $companies->where('city_id'     , 'LIKE', '%'.$city_id.'%');
        }
        if (Request()->has('district_id') && Request()->get('district_id') != '') {
            $district_id = Request()->get('district_id');
            $search['district_id'] = $district_id;
            $companies = $companies->where('district_id'     , 'LIKE', '%'.$district_id.'%');
        }
        if (Request()->has('client_type') && Request()->get('client_type') != '') {
            $client_type = Request()->get('client_type');
            $search['client_type'] = $client_type;
            $companies = $companies->where($client_type , '1');
        }
        // excport to excel
        if(Request()->has('excel') && Request()->get('excel') == '1')
        {
            return Excel::download(new Exportcompanies($companies->get()), 'clients_ramyalkelany.xlsx');
        }
        // excport to excel
        $companies = $companies->paginate(20);
        
        $title = 'الشركات';
        return view('admin.companies.index', compact('companies', 'title', 'search'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $title = 'اضافة شركة';
        return view('admin.companies.add', compact('title'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(StoreCompanyRequest $request)
    {
        // return $request->all();
        $this->register($request);
        return redirect('/dashboard/companies')->with('success', 'data added successfully');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show(Company $company)
    {
        $title = 'عرض شركة';
        return view('admin.companies.show', compact('company', 'title'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $company = Company::find($id);
        $title = 'تعديل شركة';
        return view('admin.companies.edit', compact('company', 'title'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(UpdateCompanyRequest $request, Company $company)
    {
        // $company = Company::find($id);
        $this->UpdateRecords($company, $request);
        return redirect('/dashboard/companies')->with('success', 'data added successfully');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Company $company)
    {
        if ($company->image) {
            @unlink(public_path('/cdn/'.$company->image));
        }
        $company->delete();
        return 'success';
    }
    public function storeClient(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'name'          => 'required|max:255',
            'email'         => 'nullable|email|unique:companies|max:255',
            'phone'         => 'required|unique:companies|max:255',
            // 'password'      => 'required|max:255|min:6',
            'image'         => 'nullable|image',
        ]);
        if ($validator->fails()) {
            $errors = collect($validator->errors());
            $error  = $errors->unique()->first();
            // return $validator->errors();
            return Response()->json([
            'message' => 'error',
            'data' => $error ,
        ]);
        }
        $company = Company::create($request->all());
        return Response()->json([
            'message' => 'success',
            'data' => '<option value="'.$company->id.'" selected="">'.$company->name.'</option>',
        ]);
        // return '<option value="'.$company->id.'">'.$company->name.'</option>';
    }
}
