<?php
namespace App\Traits\Admin;

use App\Http\Controllers\Api\FCMController;
use App\Notifications\GeneralNotification;
use Illuminate\Http\Request;
use App\Models\CompanyOrder;
use App\Models\Driver;
use App\Models\PriceList;
use DB;
use Carbon\Carbon;
use App\Models\Admin;
use App\Notifications\AdminNotification;

trait CompanyOrderOperations
{
  

    /**
     * Register a New .
     *
     * @param $request
     * @return \App\
     */
    public function register ($request)
    {
        $data = $request->all();
        if ($request->hasFile('image')) {
            $data['image'] = uploadImage($request->file('image'));
        }
        DB::beginTransaction();
        $CompanyOrder = CompanyOrder::create($data);
        DB::commit();
        return $CompanyOrder;
    }


    /**
     * Update Record
     * @param $truck
     * @param $request
     */
    public function UpdateRecords(CompanyOrder $CompanyOrder,$request)
    {
        $data = $request->all();
        if ($request->hasFile('image')) {
            @unlink(public_path('/cdn/'.$CompanyOrder->image));
            // 
            $data['image'] = uploadImage($request->file('image'));
        }
        
        if ($request->has('status') && $request->get('status') != 'init' && $request->get('status') != $CompanyOrder->status) {
            // check Companyorder type start
            
            // check Companyorder type end
            // send notification
            
            if( $CompanyOrder->User->lang == 'ar')
                {
                    $title = "تم تغيير حالة الطلب رقم #". $CompanyOrder->id;
                    $content = "تم تغيير حالة الطلب رقم #". $CompanyOrder->id . ' الي '.trans('words.'.$request->status);

                }else{
                    $title = " status has been changed for order #".$CompanyOrder->id;
                    $content = " status has been changed for order #".$CompanyOrder->id . ' to '. trans('wordsen.'.$request->status);
                }
                $type = "company_order_details";
                
                $title_ar = "تم تغيير حالة الطلب رقم #".$CompanyOrder->id;
                $title_en = " status has been changed for order #".$CompanyOrder->id;
                $content_ar = "تم تغيير حالة الطلب رقم #".$CompanyOrder->id . ' الي '.trans('words.'.$request->status);
                $content_en = " status has been changed for order #".$CompanyOrder->id . ' to '. trans('wordsen.'.$request->status);
                $activity = "company_order_details";
                $data2 = [
                    'company_order' => $CompanyOrder,
                    'title_ar' => $title_ar,
                    'title_en' => $title_en,
                    'content_ar' => $content_ar,
                    'content_en' => $content_en,
                    'type' => $type,
                ];
                $notifiable = $CompanyOrder->User()->first();
                $token = $notifiable->PlayerId()->pluck('player_id')->toArray();
                FCMController::Push($title, $content,$token,$data2);
                $notifiable->notify(new GeneralNotification($title, $content, $type, $data2, $activity) );
                
                // send notification to admin start
                $admin = Admin::first();
                $admin->notify(new AdminNotification($content_ar . $CompanyOrder->id , route('company-orders.show', $CompanyOrder->id)));
                // send notification to admin end
                
                // send notification end
                    // $CompanyOrder->CompanyOrderLog()->create([
                    //     'created_by_type' => 'admin',
                    //     'created_by_id' => auth()->id(),
                    //     'key' => 'status_changed',
                    //     'notes' => trans('words.Companyorder status has been changed by', ['by_name' => auth()->user()->name, 'status' => trans('words.'.$request->status) ]),
                    // ]); 
            }
        $CompanyOrder->update($data);
        return $CompanyOrder;
    }
    /**
     * delete Record
     * @param $truck
     * @param $request
     */
    public function DeleteRecord($id)
    {
        //
    }
}