<?php

namespace App\Http\Resources;

use App\Models\Cart;
use Carbon\Carbon;
use Illuminate\Http\Resources\Json\JsonResource;

class CartResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        $total_price = 0;
        dd($this->id);
        $cart = Cart::find($this->id);
        foreach ($cart as $item) {
            $product = $item->Product()->first();
            if ($product) {
                
                if ($item->product_type == 'rent') {
                    // 
                    if ($item->rent_type == 'day') {
                        $total_price += $item->CartItemDay()->count() * $product->daily_price;  
                    } else if ($item->rent_type == 'month') {
                        $total_price += $item->CartItemDay()->count() * $product->daily_price;  
                    } else {
                        if ($item->CartItemDay()->first()) {
                            
                            $from = Carbon::createFromFormat('Y-m-d H:s:i', $item->CartItemDay()->first()->day_date . ' ' . $item->CartItemDay()->first()->time_from);
                            $to = Carbon::createFromFormat('Y-m-d H:s:i', $item->CartItemDay()->first()->day_date . ' ' . $item->CartItemDay()->first()->time_to);
                            $diff_in_hours = $to->diffInHours($from);
                            $total_price += $diff_in_hours * $product->hour_price; 
                        }
                    }
                    
                }else{
                    $total_price += $item->quantity * $item->Product->price;
                }
            }
        }
        $sub_total = $total_price + $cart->CartItem()->sum('gasoline_cost') + $cart->CartItem()->sum('move_cost') + $cart->CartItem()->sum('housing_cost');
        return [
            'id' => $this->id,
            'items' => CartItemResource::collection($this->CartItem()->get()),
            'move_cost' => $this->CartItem()->sum('move_cost'),
            'gasoline_cost' => $this->CartItem()->sum('gasoline_cost'),
            'housing_cost' => $this->CartItem()->sum('housing_cost'),
            'sub_total' => $sub_total,
            'vat' => round((float)getSettingValue('tax'),2),
            'vat_cost' => round((float)getSettingValue('tax') / 100 * $sub_total,2),
            'total' => PriceWithVat($sub_total),
            
        ];
    }
}
