<?php

namespace App\Http\Controllers\Api;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\User;
use App\Models\Driver;
use App\Models\Setting;
use App\Models\Category;
use App\Models\City;
use App\Models\Branch;
use App\Models\CarMaker;
use App\Models\CarType;
use App\Models\Product;
use App\Models\PriceList;
use App\Models\Year;
use App\Models\Color;
use App\Models\Order;
use Auth;
use DB;
use App\Traits\Api\CompanyOrderOperations;
use Carbon\Carbon;

class CompanyOrderController extends Controller
{
    use CompanyOrderOperations;
    public function store(Request $request)
    {
        $user = auth('api')->user();
        $order = $this->register($request, $user);
        return Response()->json([
            'data'          => [
                'order'  => $order,
            ],
            'message'       => 'success',
            'code'          => getMsgCode('success'),
        ]);
    }
    
    public function index(Request $request)
    {
        $user = auth('api')->user();
        $orders = $user->CompanyOrder()->with('User')->get();
        return Response()->json([
            'data'          => [
                'orders'  => $orders,
            ],
            'message'       => 'success',
            'code'          => getMsgCode('success'),
        ]);
    }
    public function show(Request $request, $id)
    {
        $user = auth('api')->user();
        $order = $user->CompanyOrder()->with('User')->with('CompanyOrderItem')->find($id);
        return Response()->json([
            'data'          => [
                'order'  => $order,
            ],
            'message'       => 'success',
            'code'          => getMsgCode('success'),
        ]);
    }
}
