<?php

namespace App\Http\Controllers\Admin;

use App\Http\Requests\Admin\UpdateTransactionRequest;
use App\Http\Requests\Admin\StoreTransactionRequest;
use App\Http\Controllers\Controller;
use App\Traits\Admin\TransactionOperations;
use Illuminate\Http\Request;
use App\Models\Admin;
use App\Models\Transaction;
use Auth;

class TransactionController extends Controller
{
    use TransactionOperations;
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */

    public function __construct()
    {
        // $this->middleware('Permission:engTransaction_show'    , ['only' => 'index', 'show']);
        // $this->middleware('Permission:engTransaction_add'     , ['only' => 'create', 'store']);
        // $this->middleware('Permission:engTransaction_edit'    , ['only' => 'edit', 'update']);
        // $this->middleware('Permission:engTransaction_delete'  , ['only' => 'destroy']);
    }
    public function index()
    {
        $all = Transaction::latest()->get();
        $transactions = Transaction::latest()->get();
        $title = 'التحويلات';
        return view('admin.transactions.index', compact('transactions', 'title'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $title = 'اضافة الحوالة';
        return view('admin.transactions.add', compact('title'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(StoreTransactionRequest $request)
    {
        $this->register($request);
        return redirect()->back()->with('success', 'data added successfully');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show(Transaction $transaction)
    {
        $title = 'عرض الحوالة';
        return view('admin.transactions.show', compact('transaction', 'title'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $transaction = Transaction::find($id);
        $title = 'تعديل الحوالة';
        return view('admin.transactions.edit', compact('transaction', 'title'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(UpdateTransactionRequest $request, Transaction $transaction)
    {
        // $transaction = Transaction::find($id);
        $this->UpdateRecords($transaction, $request);
        return redirect()->back()->with('success', 'data added successfully');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Transaction $transaction)
    {
        if ($transaction->image) {
            @unlink(public_path('/cdn/'.$transaction->image));
        }
        $transaction->delete();
        return 'success';
    }
}
