<?php

namespace App\Http\Controllers\Admin;

use App\Http\Requests\Admin\UpdatePriceListRequest;
use App\Http\Requests\Admin\StorePriceListRequest;
use App\Http\Controllers\Controller;
use App\Traits\Admin\PriceListOperations;
use Illuminate\Http\Request;
use App\Models\Admin;
use App\Models\PriceList;
use Auth;

class PriceListController extends Controller
{
    use PriceListOperations;
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */

    public function __construct()
    {
        // $this->middleware('Permission:engprice_show'    , ['only' => 'index', 'show']);
        // $this->middleware('Permission:engprice_add'     , ['only' => 'create', 'store']);
        // $this->middleware('Permission:engprice_edit'    , ['only' => 'edit', 'update']);
        // $this->middleware('Permission:engprice_delete'  , ['only' => 'destroy']);
    }
    public function index()
    {
        $all = PriceList::latest()->get();
        $bus_type_id = Request()->get('bus_type_id');
        $prices = PriceList::latest()->where('bus_type_id', $bus_type_id)->get();
        $title = 'قائمة الاسعار';
        return view('admin.price_lists.index', compact('prices', 'title', 'bus_type_id'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $title = 'اضافة العنصر';
        $bus_type_id = Request()->get('bus_type_id');
        return view('admin.price_lists.add', compact('title', 'bus_type_id'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(StorePriceListRequest $request)
    {
        $price = $this->register($request);
        return redirect(url('/dashboard/pricelists?bus_type_id='.$price->bus_type_id))->with('success', 'data added successfully');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show(PriceList $price)
    {
        $title = 'عرض العنصر';
        return view('admin.price_lists.show', compact('price', 'title'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $price = PriceList::find($id);
        $bus_type_id = Request()->get('bus_type_id');
        $title = 'تعديل العنصر';
        return view('admin.price_lists.edit', compact('price', 'title', 'bus_type_id'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(UpdatePriceListRequest $request, $price)
    {
        // return $request->all();
        $price = PriceList::find($price);
        $this->UpdateRecords($price, $request);
        return redirect(url('/dashboard/pricelists?bus_type_id='.$price->bus_type_id))->with('success', 'data added successfully');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(PriceList $price)
    {
        if ($price->image) {
            @unlink(public_path('/cdn/'.$price->image));
        }
        $price->delete();
        return 'success';
    }
}
