@extends('admin.layout.app')
@section('style')
<link rel="stylesheet" href="{{ asset('/adminto/assets/plugins/magnific-popup/dist/magnific-popup.css')}}" />
<style>
    .badge-success {
        font-size: 15px;
        padding: 6px 19px !important;
    }

</style>
@endsection
@section('content')

<div class="row">


    <div class="col-lg-12 table-custom">
        <div class="title-page sub-header-title-custom">
            <h5 style="color: inherit;"><a href="{{route('orders.index')}}"><span> الطلبات</span><i
                        class="fa fa-angle-left" style="padding: 0 5px; color:inherit;"></i></a><span>طلب رقم
                    {{ $order->id}} </span></h5>


        </div>

        <div class="panel panel-color  card-box-v2 panel-tabs panel-success m-t-10">
            <div class="panel-heading panel-heading-custom">
                <ul class="nav nav-pills">
                    <li class="active">
                        <a href="#navpills-1" data-toggle="tab" aria-expanded="true">البيانات الأساسية</a>
                    </li>
                    <li class="">
                        <a href="#navpills-2" data-toggle="tab" aria-expanded="false">المعدات</a>
                    </li>
                    <li class="">
                        <a href="#navpills-3" data-toggle="tab" aria-expanded="false">صور موقع العمل</a>
                    </li>
                    @if ($order->OrderItem()->first()->product_type == 'rent')

                    <li class="">
                        <a href="#navpills-4" data-toggle="tab" aria-expanded="false">ايام العمل</a>
                    </li>
                    @endif
                </ul>
            </div>
            <div class="panel-body">
                <div class="tab-content">
                    <div id="navpills-1" class="tab-pane    fade in active">
                        <div class="row">
                            <div class="col-md-3">
                                <table class="table m-0" style="width: 100%; ">

                                    <tbody>
                                        <tr>
                                            <td>رقم الطلب <span style="padding-right: 40px;">{{$order->id}}</span></td>
                                        </tr>
                                        <tr>
                                            <td>تاريخ الطلب <span style="padding-right: 40px;">{{$order->created_at}}</span></td>
                                        </tr>
                                        <tr>
                                            <td> حاله الطلب <span style="padding-right: 40px;"> {{__('words.'.$order->status) }} </span></td>
                                        </tr>
                                        <tr>
                                            <td> نوع الطلب <span style="padding-right: 40px;"> {{__('words.'.$order->OrderItem()->first()->product_type) }} </span>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td> نوع الحجز <span style="padding-right: 40px;"> {{__('words.'.$order->OrderItem()->first()->rent_type) }} </span>
                                            </td>
                                        </tr>
                                        @if ($order->OrderItem()->first()->product_type == 'rent')
                                        <tr>
                                            <td> تاريخ الايجار من <span style="padding-right: 40px;"> {{$order->OrderItem()->first()->OrderItemDay()->orderBy('id', 'asc')->first()->day_date ?? ''}} </span></td>
                                        </tr>
                                        <tr>
                                            <td> تاريخ الايجار الي <span style="padding-right: 40px;"> {{$order->end_date ?? ''}} </span></td>
                                        </tr>

                                        @endif
                                        <tr>
                                            <td> اسم العميل <span style="padding-right: 40px;"> {{$order->User->name ?? ''}} </span></td>
                                        </tr>


                                        <tr>
                                            <td> رقم الجوال <span style="padding-right: 40px;">{{$order->User->phone ?? ''}} </span></td>
                                        </tr>
                                        <tr>
                                            <td> مدينه العميل <span style="padding-right: 40px;">{{$order->User->City->name ?? ''}} </span>
                                            </td>
                                        </tr>

                                    </tbody>
                                </table>
                            </div>
                            <div class="col-md-3">
                                <table class="table m-0" style="width: 100%; ">

                                    <tbody>
                                        <tr>
                                            <td> تكلفة المعدات <span style="padding-right: 40px;">{{$order->original_total}} ريال</span></td>
                                        </tr>
                                        <tr>
                                            <td>تكلفة الجازلين <span style="padding-right: 40px;">{{$order->OrderItem()->sum('gasoline_cost')}} ريال</span></td>
                                        </tr>
                                        <tr>
                                            <td> تكلفة السكن <span style="padding-right: 40px;"> {{$order->OrderItem()->sum('housing_cost')}} ريال </span></td>
                                        </tr>
                                        <tr>
                                            <td> تكلفة النقل <span style="padding-right: 40px;"> {{$order->OrderItem()->sum('move_cost')}} ريال </span></td>
                                        </tr>
                                        @if ($order->coupon)
                                        <tr>
                                            <td>  الكوبون <span style="padding-right: 40px;"> {{$order->coupon}}  </span></td>
                                        </tr>
                                        <tr>
                                            <td>  الخصم <span style="padding-right: 40px;"> {{$order->discount}} ريال </span></td>
                                        </tr>

                                        @endif

                                        <tr>
                                            <td> السعر الكلى <span style="padding-right: 40px;">{{$order->total_price}} ريال</span></td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>

                            <div class="col-md-6">
                                <div class="box-map-map">
                                    <h6>موقع العمل</h6>
                                    <div id="gmaps-markers" class="gmaps" data-lat="{{$order->latitude}}"
                                        data-long="{{$order->longitude}}"></div>
                                </div>
                            </div>





                        </div>
                    </div>

                    <div id="navpills-2" class="tab-pane fade">
                        <div class="row">
                            <div class="col-md-12">
                                <table class="datatable-buttons table tab-pane-custom table-striped table-bordered"
                                    style="width: 100%;">
                                    <thead>
                                        <tr>
                                            <th># </th>
                                            <th>المعدة </th>

                                            <th> الكمية </th>
                                            <th> السعر </th>
                                            <th> اجمالي السعر </th>
                                            <th>تاريخ </th>
                                            <th>تعديل المعده </th>
                                            <th>مهمه المعده </th>
                                            <th>نوع المعده </th>
                                        </tr>
                                    </thead>

                                    <tbody>
                                        @foreach($order->OrderItem()->OrderBy('id', 'asc')->get() as $item)
                                        <tr>
                                            <td>{{$item->Product->product_number ?? ''}}</td>
                                            <td> <a href="{{route('products.show',$item->Product->id)}}"> {{$item->Product->title ?? ''}} </a></td>
                                            <td> {{ $item->quantity ?? '' }} </td>
                                            <td> {{ $item->price ?? '' }} </td>
                                            <td> {{ $item->total_price ?? '' }} </td>
                                            <td> {{ $item->created_at ?? '' }} </td>
                                            <td> {{$item->Product->title ?? ''}}</td>
                                            <td> {{$item->Product->Mission->name_ar ?? ''}}</td>
                                            <td> {{$item->Product->Category->name_ar ?? ''}}</td>

                                        </tr>
                                        @if ($item->product_type == 'rent')
                                        <tr>
                                            <td colspan="2"> موعد التاجير</td>
                                            <td colspan="7">

                                                @foreach ($item->OrderItemDay()->get() as $day)
                                                @if ($item->rent_type == 'day')
                                                <span class="badge badge-success">{{$day->day_date}} </span>
                                                @else
                                                <span class="badge badge-success">{{$day->day_date}} / {{$day->time_from}} : {{$day->time_to}}</span>


                                                @endif
                                                @endforeach
                                            </td>
                                        </tr>
                                        @endif
                                        @endforeach

                                    </tbody>
                                </table>
                            </div>

                        </div>
                        {{--  <div class="row">
                            <div class="col-md-12">
                                <table class="datatable-buttons table tab-pane-custom table-striped table-bordered"
                                    style="width: 100%;">
                                    <thead>
                                        <tr>
                                            <th> صورة موقع العمل </th>

                                        </tr>
                                    </thead>

                                    <tbody>
                                        @foreach ($order->Files()->get as $item)

                                        <tr>
                                            <td>{{$item->name}}</td>
                        </tr>
                        @endforeach

                        </tbody>
                        </table>
                    </div>

                </div> --}}
            </div>
            <div id="navpills-3" class="tab-pane fade">
                <div class="row">
                    @if(isset($order))
                    @foreach($order->Files()->OrderBy('id', 'asc')->get() as $item)
                    <div class="col-md-3">
                        <a href="{{getImage($item->name)}}" class="image-popup" title="Screenshot-8">
                            <img src="{{getImage($item->name)}}" class="thumb-img pop_image_item" alt="work-thumbnail">
                        </a>



                    </div>
                    @endforeach
                    @endif


                </div>
            </div>

            @if ($order->OrderItem()->first()->product_type == 'rent')
            <div id="navpills-4" class="tab-pane fade">
                <div class="row">
                    @php
                    $idss = $order->OrderItem()->pluck('id')->toArray();
                    $days = \App\Models\OrderItemDay::whereIn('order_item_id' , $idss)->get()
                    @endphp
                    @foreach ($days as $itemD)
                    <div class="col-md-3">
                        @if (\Carbon\Carbon::parse($itemD->day_date)->gt(\Carbon\Carbon::today()))

                        <span class="badge" style="color:#fff; background-color:green;">
                            {{$itemD->day_date}}
                        </span>
                        @else
                        <span class="badge" style="color:#fff; background-color:red;">
                            {{$itemD->day_date}}
                        </span>

                        @endif
                    </div>
                    @endforeach

                </div>
            </div>
            @endif
        </div>
    </div><!-- end col -->

</div>
<!-- end row -->
</div>
</div>
@endsection
@section('script')
<script type="text/javascript"
    src="{{ asset('/adminto/assets/plugins/magnific-popup/dist/jquery.magnific-popup.min.js')}}"></script>
<script type="text/javascript"
    src="https://maps.google.com/maps/api/js?sensor=false&libraries=places&key=AIzaSyCUPprEbO25z-DXpDwe-0sA4FNwc7rI6Q0&language=ar">
</script>
<script type="text/javascript">
    $(document).ready(function () {
        $('.image-popup').magnificPopup({
            type: 'image',
            closeOnContentClick: true,
            mainClass: 'mfp-fade',
            gallery: {
                enabled: true,
                navigateByImgClick: true,
                preload: [0,
                    1
                ] // Will preload 0 - before current, and 1 after the current image
            }
        });
    });
    $(document).ready(function () {
        // gmaps
        $('.gmaps').each(function (i, obj) {
            //test
            console.log($(this).attr('data-lat'));
            // console.log(i);
            initializeMap(obj, $(this).attr('data-lat'), $(this).attr('data-long'))
        });
    });

    function initializeMap(div, lat, long) {
        // alert(3);
        var myLatlng = new google.maps.LatLng(parseFloat(lat), parseFloat(long));
        var myOptions = {
            zoom: 12,
            center: myLatlng,
            mapTypeId: google.maps.MapTypeId.ROADMAP
        }
        map = new google.maps.Map(div, myOptions);
        var marker = new google.maps.Marker({
            position: myLatlng,
            map: map,
            title: "location"
        });
    }

</script>
@endsection
