@extends('admin.layout.app')
@section('style')
    <link rel="stylesheet" href="/css/lightbox.min.css">
@endsection
@section('content')
<!-- Page-Title -->
<div class="row">
    <div class="col-sm-12">

        <div class="title-page sub-header-title-custom">
            <h5 style="color: inherit;"><a href="#"><span> اداره المعدات </span><i class="fa fa-angle-left"
                        style="padding: 0 5px; color:inherit;"></i></a><span>نظرة عامة </span></h5>
            <ul>


                <li class="offer-2">
                    <a href="{{url('/dashboard/products/create')}}{{(request()->has('type'))? '?type='.request()->get('type') : ''}}"><span><i class="fa fa-plus"
                                aria-hidden="true"></i></span>
                        اضافة جديد </a>
                </li>
                <li class="offer-2">
                    <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#exampleModal">
                        ادراج معدات من ملف اكسيل
                    </button>
                </li>
                <li class="offer-2">
                    <a href="{{url('/awn_excel_form-v2.xlsx')}}" target="_blank" class="btn btn-primary">
                        تحميل نموذج لملف اكسل
                    </a>
                </li>
                <li class="offer-2">
                    <a href="{{url('/dashboard/export-excel/city')}}" target="_blank" class="btn btn-primary">
                        تحميل المدن
                    </a>
                </li>
                <li class="offer-2">
                    <a href="{{url('/dashboard/export-excel/category')}}" target="_blank" class="btn btn-primary">
                        تحميل الاقسام
                    </a>
                </li>
                <li class="offer-2">
                    <a href="{{url('/dashboard/export-excel/mission')}}" target="_blank" class="btn btn-primary">
                        تحميل المهام
                    </a>
                </li>
                {{-- <li class="offer-2">
                                    <a href="{{url('/dashboard/export-excel/model')}}" target="_blank" class="btn
                btn-primary">
                تحميل الموديلات
                </a>
                </li> --}}

            </ul>

        </div>

        <div class="card-box">
            <form action="" method="get" id="search-form">
                <div class="row">
                    <div class="col-md-12 part-top">
                        <div class="row">

                        </div>
                    </div>

                    <div class="col-md-12">
                        <div class="row">


                            <div class="col-lg-3">
                                <div class="form-horizontal">
                                    <div class="form-group">
                                        <div class="col-md-12">
                                            <input type="text" onkeyup="submitForm()" name="title"
                                                value="{{(array_key_exists('title', $search))? $search['title'] : ''}}"
                                                class="form-control" placeholder="اسم المعده">
                                        </div>
                                    </div>

                                </div>
                            </div>

                            <div class="col-lg-3">
                                <div class="form-horizontal">
                                    <div class="form-group">
                                        <div class="col-md-12">
                                            <input type="text" onkeyup="submitForm()" name="id"
                                                value="{{(array_key_exists('id', $search))? $search['id'] : ''}}"
                                                class="form-control" placeholder="#رقم المعده">
                                        </div>
                                    </div>

                                </div>
                            </div>
                            <div class="col-lg-3">
                                <div class="form-horizontal">
                                    <div class="form-group">
                                        <div class="col-md-12">
                                            <input type="text" onkeyup="submitForm()" name="model"
                                                value="{{(array_key_exists('model', $search))? $search['model'] : ''}}"
                                                class="form-control" placeholder="الموديل">
                                        </div>
                                    </div>

                                </div>
                            </div>
                            <div class="col-lg-3">
                                <div class="form-horizontal">
                                    <div class="form-group">
                                        <div class="col-md-12">
                                            {!! Form::select("category",CategoriesListc(),(array_key_exists('category',
                                            $search))? $search['category'] : null,['class'=>"form-control select2 ",
                                            'onchange' => 'submitForm()'])!!}

                                        </div>
                                    </div>

                                </div>
                            </div>
                            <div class="col-lg-3">
                                <div class="form-horizontal">
                                    <div class="form-group">
                                        <div class="col-md-12">
                                            <input type="hidden" name="sort_by">
                                            <input type="hidden" name="sort_type">
                                            <input type="hidden" name="type"
                                                value="{{(array_key_exists('type', $search))? $search['type'] : ''}}"
                                                class="form-control">
                                        </div>
                                    </div>

                                </div>
                            </div>

                        </div>
                    </div>

                    <div class="col-md-12">
                        <div class="row">

                            <div class="col-md-4">
                                <div class="form-horizontal m-b-15">
                                    <button type="button"
                                        class=" search-bbt btn btn-block btn-sm btn-success waves-effect waves-light b-t-10 b-b-10"><i
                                            class="fa fa-search"></i> بحث</button>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-horizontal m-b-15">
                                    <button type="button" target="_blank"
                                        class="excel-bbt btn btn-block btn-sm btn-success waves-effect waves-light b-t-10 b-b-10">تصدير
                                        لExcel</button>
                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="form-horizontal">
                                    <a href="{{url('/dashboard/products')}}"
                                        class="cstm-delete btn btn-block btn-sm btn-success waves-effect waves-light b-t-10 b-b-10"><i
                                            class="fa fa-trash"></i> مسح خيارات البحث</a>
                                </div>
                            </div>

                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>


<div class="row">

    <div class="col-sm-12">
        <div class="card-box ">
            <div class="row">

                <div class="col-md-12">
                    <div class="tabel-control">
                        <button class="btn  btn-primary btn-sm btn-success waves-effect waves-light "
                            id="clear-selected"><i class="fa fa-undo"></i>تصفيه المحدد (<span id="sel-count"></span>)</button>
                        <button class="based-on-sel btn  cstm-delete btn-sm btn-success waves-effect waves-light "
                            id="delete-selected"><i class="fa fa-trash"></i>حذف المحدد</button>
                        <button class="based-on-sel btn   btn-sm btn-success waves-effect waves-light " data-toggle="modal"
                            data-target="#exampleModal2"><i class="fa fa-pencil"></i>تعديل المحدد</button>


                    </div>
                </div>
                <div class="col-md-12" id="table-data">
                    <div class="table-responsive">
                        <table class="table tab-pane-custom table-striped table-bordered" style="width: 100%;">
                            <thead>
                                <tr>
                                    <th>
                                        <input type="checkbox" class="ids" id="checkAll">
                                    </th>
                                    <th>
                                        <div class="sort">
                                            <span class="btns-wr">
                                                <button class="btn" onclick="ChangeSort('asc', 'product_number')">
                                                    <i class="fa fa-caret-up" aria-hidden="true"></i>
                                                </button>
                                                <button class="btn" onclick="ChangeSort('desc', 'product_number')">
                                                    <i class="fa fa-caret-down" aria-hidden="true"></i>
                                                </button>
                                            </span>
                                            <span class="txt">رقم المعدة</span>
                                        </div>
                                    </th>
                                    <th> الصورة </th>
                                    <th>

                                        <div class="sort">
                                            <span class="btns-wr">
                                                <button class="btn" onclick="ChangeSort('asc', 'title')">
                                                    <i class="fa fa-caret-up" aria-hidden="true"></i>
                                                </button>
                                                <button class="btn" onclick="ChangeSort('desc', 'title')">
                                                    <i class="fa fa-caret-down" aria-hidden="true"></i>
                                                </button>
                                            </span>
                                            <span class="txt">اسم المعده</span>
                                        </div>


                                    </th>
                                    <th>
                                        <div class="sort">
                                            <span class="btns-wr">
                                                <button class="btn" onclick="ChangeSort('asc', 'model')">
                                                    <i class="fa fa-caret-up" aria-hidden="true"></i>
                                                </button>
                                                <button class="btn" onclick="ChangeSort('desc', 'model')">
                                                    <i class="fa fa-caret-down" aria-hidden="true"></i>
                                                </button>
                                            </span>
                                            <span class="txt">الموديل</span>
                                        </div>

                                    </th>
                                    <th>
                                        <div class="sort">
                                            <span class="btns-wr">
                                                <button class="btn" onclick="ChangeSort('asc', 'category')">
                                                    <i class="fa fa-caret-up" aria-hidden="true"></i>
                                                </button>
                                                <button class="btn" onclick="ChangeSort('desc', 'category')">
                                                    <i class="fa fa-caret-down" aria-hidden="true"></i>
                                                </button>
                                            </span>
                                            <span class="txt">نوع المعده</span>
                                        </div>

                                    </th>
                                    <th>
                                        <div class="sort">
                                            <span class="btns-wr">
                                                <button class="btn" onclick="ChangeSort('asc', 'mission')">
                                                    <i class="fa fa-caret-up" aria-hidden="true"></i>
                                                </button>
                                                <button class="btn" onclick="ChangeSort('desc', 'mission')">
                                                    <i class="fa fa-caret-down" aria-hidden="true"></i>
                                                </button>
                                            </span>
                                            <span class="txt">المهمه</span>
                                        </div>

                                    </th>
                                    <th>
                                        <div class="sort">
                                            <span class="btns-wr">
                                                <button class="btn" onclick="ChangeSort('asc', 'price')">
                                                    <i class="fa fa-caret-up" aria-hidden="true"></i>
                                                </button>
                                                <button class="btn" onclick="ChangeSort('desc', 'price')">
                                                    <i class="fa fa-caret-down" aria-hidden="true"></i>
                                                </button>
                                            </span>
                                            <span class="txt">السعر</span>
                                        </div>

                                    </th>
                                    {{-- <th>المدينه </th> --}}
                                    <th>
                                        <div class="sort">
                                            <span class="btns-wr">
                                                <button class="btn" onclick="ChangeSort('asc', 'quantity')">
                                                    <i class="fa fa-caret-up" aria-hidden="true"></i>
                                                </button>
                                                <button class="btn" onclick="ChangeSort('desc', 'quantity')">
                                                    <i class="fa fa-caret-down" aria-hidden="true"></i>
                                                </button>
                                            </span>
                                            <span class="txt">الكميه</span>
                                        </div>

                                    </th>
                                    {{-- <th>الوصف </th> --}}
                                    <th>
                                        <div class="sort">
                                            <span class="btns-wr">
                                                <button class="btn" onclick="ChangeSort('asc', 'branch')">
                                                    <i class="fa fa-caret-up" aria-hidden="true"></i>
                                                </button>
                                                <button class="btn" onclick="ChangeSort('desc', 'branch')">
                                                    <i class="fa fa-caret-down" aria-hidden="true"></i>
                                                </button>
                                            </span>
                                            <span class="txt">الفرع</span>
                                        </div>

                                    </th>
                                    {{-- <th>الاعمال </th> --}}
                                    <th>الطراز </th>
                                    <th>العمليات </th>
                                    {{-- <th>عرض </th>
                                    <th>تعديل</th>
                                    <th>حذف</th> --}}
                                </tr>
                            </thead>
                            <tbody>
                                {{--  /////////////  --}}
                                @foreach($products as $item)
                                <tr class="deleted-row">
                                    <td>
                                        <input type="checkbox" name="ids[]" value="{{$item->id}}" class="ids with-v ids-{{$item->id}}" />
                                    </td>
                                    <td>
                                        {{$item->product_number}} </td>
                                    <td>
                                        <a href="{{$item->image}}" data-lightbox="image-1" data-title="{{$item->title}}">
                                            <img src="{{$item->image}}" width="50" height="50" alt="" srcset="">
                                        </a>
                                    </td>
                                    <td> {{ $item->title ?? '' }} </td>
                                    <td> {{ $item->model ?? '' }} </td>
                                    <td> {{ $item->Category->name_ar ?? '' }} </td>
                                    <td> {{ $item->Mission->name_ar ?? '' }} </td>
                                    <td> {{ $item->price ?? '' }} </td>
                                    {{-- <td> {{ $item->City->name_ar ?? '' }} </td> --}}
                                    <td> {{ $item->quantity ?? '' }} </td>
                                    <td> {{ $item->Branch->name_ar ?? '' }} </td>
                                    <td> {{ $item->version ?? '' }} </td>
                                    <td>
                                        <div class="btn-group pull-right m-t-15">
                                            <button type="button" class="btn btn-primary dropdown-toggle waves-effect waves-light" data-toggle="dropdown" aria-expanded="false">العمليات <i class="fa fa-cog"></i></button>
                                            <ul class="dropdown-menu" role="menu">
                                                <li>
                                                    <a style="border-radius: 0 !important;" href="{{route('products.show',$item->id)}}"><i class="fa fa-eye  m-r-10"
                                                        style="color: #188ae2;"></i> عرض</a>
                                                </li>
                                                <li>
                                                    <a style="border-radius: 0 !important;" target="_blank" href="{{route('products.edit',$item->id)}}"><i class="fa fa-pencil  m-r-10"
                                                        style="color: #188ae2;"></i> تعديل</a>
                                                </li>
                                                <li>
                                                    <a style="border-radius: 0 !important;" href="{{route('products.destroy',$item)}}" class="delete-btn"><i
                                                        class="fa fa-trash-o m-r-10" style="color: #5b69bc;"></i> حذف</a>
                                                </li>
                                                {{-- <li class="divider"></li>
                                                <li><a href="#">Separated link</a></li> --}}
                                            </ul>
                                        </div>
                                    </td>

                                    {{-- <td><a href="{{route('products.show',$item->id)}}"><i class="fa fa-eye  m-r-10"
                                                style="color: #188ae2;"></i> عرض</a></td>
                                    <td><a href="{{route('products.edit',$item->id)}}"><i class="fa fa-pencil  m-r-10"
                                                style="color: #188ae2;"></i> تعديل</a></td>
                                    <td> <a href="{{route('products.destroy',$item)}}" id="delete-btn"><i
                                                class="fa fa-trash-o m-r-10" style="color: #5b69bc;"></i> حذف</a></td> --}}
                                </tr>
                                @endforeach

                            </tbody>
                        </table>
                    </div>
                    {!! $products->appends($search)->links() !!}
                </div>
                {{-- <div class="col-md-12">
                    <div class="tabel-control">
                        <button class="btn  cstm-delete btn-sm btn-success waves-effect waves-light "
                            id="delete-selected"><i class="fa fa-trash"></i>حذف المحدد</button>
                        <button class="btn   btn-sm btn-success waves-effect waves-light " data-toggle="modal"
                            data-target="#exampleModal2"><i class="fa fa-pencil"></i>تعديل المحدد</button>


                    </div>
                </div> --}}
            </div>

        </div>
    </div><!-- end col -->
</div>
<!-- end row -->

<!-- Modal -->
<div class="modal fade" id="exampleModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
    aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">ادراج معدات من ملف اكسيل</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">

                {!!Form::open( ['url' => '/dashboard/products-excel/' ,'method' => 'Post','files' =>
                true,'id'=>'upload-excel-f']) !!}


                <div class="card-box">
                    <div class="row">
                        <div class="col-lg-12">
                            <div class="alert alert-warning" style="color:#000;">
                                يرجي تعديل كافه البيانات المدخله لاختيار نوع المعده و القسم و غيرها.
                            </div>
                        </div>

                        <div class="col-lg-12">
                            <div class="form-group">
                                <label class=""> اختر الملف *</label>
                                <div class=" append">
                                    {!! Form::file("excel",['class'=>"form-control select2 ",
                                    "autocomplete"=> 'off'])!!}
                                </div>
                            </div>
                        </div>


                        <div class="text-center">
                            <button class="btn btn-primary waves-effect waves-light btn-submit" type="submit"> اضافة
                            </button>
                        </div>
                    </div>


                </div>
                {!!Form::close() !!}
            </div>
            <div class="modal-footer">
            </div>
        </div>
    </div>
</div>
<div class="modal fade" id="exampleModal2" tabindex="-1" role="dialog" aria-labelledby="exampleModal2Label"
    aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModal2Label">تعديل المعدات المحدده</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">

                {!!Form::open( ['url' => route('products.update-array') ,'method' => 'Post','files' =>
                true,'id'=>'form-update']) !!}


                <div class="card-box">
                    <div class="row">

                        <div class="form-horizontal">
                            <div class="col-lg-12">
                                <div class="alert alert-warning" style="color:#000;">
                                    يرجي العلم بان كافه التعديلات التي سيتم اختيارها سوف تتطبع علي المعدات المحدده
                                    مسبقا.
                                </div>
                            </div>

                            <div class="col-lg-12">
                                <div class="form-group">
                                    <label class="col-md-2">المهمه <span></span></label>
                                    <div class="col-md-10">
                                        {!! Form::select("mission_id",MissionsList(),null,['class'=>"form-control
                                        select2 "])!!}
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-12">
                                <div class="form-group">
                                    <label class="col-md-2">القسم <span></span></label>
                                    <div class="col-md-10">
                                        {!! Form::select("category_id",CategoriesList(),null,['class'=>"form-control
                                        select2 "])!!}
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-12">
                                <div class="form-group">
                                    <label class="col-md-2">الفرع <span></span></label>
                                    <div class="col-md-10">
                                        {!! Form::select("branch_id",Branchs(),null,['class'=>"form-control select2
                                        "])!!}
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-12">
                                <div class="form-group">
                                    <label class="col-md-2">الحالة <span></span></label>
                                    <div class="col-md-10">
                                        <input type="checkbox" name="active" value="1" data-plugin="switchery"
                                            onchange="switchaerych(this)" data-color="#00b19d" />
                                    </div>

                                </div>
                            </div>
                        </div>


                        <div class="text-center">
                            <button class="btn btn-primary waves-effect waves-light btn-submit" type="submit"> تعديل
                            </button>
                        </div>
                    </div>


                </div>
                {!!Form::close() !!}
            </div>
            <div class="modal-footer">
            </div>
        </div>
    </div>
</div>

@endsection
@section('script')
<script src="/js/lightbox.min.js"></script>
<script>
    var xhr;
    $(document).on('click', '.search-bbt', function () {
        $(this).closest('form').find('#excel').remove();
        $(this).closest('form').submit();
    });
    $(document).on('click', '.excel-bbt', function () {
        $(this).closest('form').prepend(`<input name='excel' id='excel' type='hidden' value='1' />`);
        $(this).closest('form').submit();
    });

    $('body').on('submit', '#upload-excel-f', function () {
        $('body').waitMe({
            effect: 'ios',
            text: (this.lang == 'ar') ? 'إنتظر من فضلك ...' : 'Please wait...',
            color: '#000',
            waitTime: -1,
            textPos: 'vertical'
        });
    });
    $('body').on('submit', '#search-form', function (e) {
        if ($('#excel').length > 0) {
            return;
        }
        e.preventDefault();
        var data = $(this).serializeArray();
        console.log(data);
        $('#table-data').waitMe({
            effect: 'ios',
            text: (this.lang == 'ar') ? 'إنتظر من فضلك ...' : 'Please wait...',
            color: '#000',
            waitTime: -1,
            textPos: 'vertical'
        });
        if(xhr !== undefined )
        {
            xhr.abort();
        }
        xhr = $.post(`{{route('products.index-post')}}`, data)
            .done(function (res) {
                $('#table-data').html(res.view);
                feather.replace();
                $('.waitMe').remove();
                checkStored();
            })
            .fail(function (res) {
                $('.waitMe').remove();
            });
    });
    $('body').on('submit', '#form-update', function (e) {
        e.preventDefault();
        $('#exampleModal2').modal('toggle');
        var data = $(this).serializeArray();
        // var ids = $('input.ids:checked').map(function () {
        //     return $(this).val();
        // }).get();
        var ids = [];

        if (localStorage.getItem('listIds')) {
            ids = localStorage.getItem('listIds').split(',');
        }
        data.push({
            name: "ids",
            value: ids
        });
        console.log(data);
        $('#table-data').waitMe({
            effect: 'ios',
            text: (this.lang == 'ar') ? 'إنتظر من فضلك ...' : 'Please wait...',
            color: '#000',
            waitTime: -1,
            textPos: 'vertical'
        });
        $.post($(this).attr('action'), data)
            .done(function (res) {
                submitForm()
                $('input:checkbox').prop('checked', false);
                StoreAsArray('listIds', '', 'a',1)
                $('.waitMe').remove();
                ShowSuccess(res.message);

            })
            .fail(function (res) {
                $('.waitMe').remove();
            });
    });

    function submitForm() {
        $('#search-form').closest('form').find('#excel').remove();
        $('#search-form').submit();
    }

    function ChangeSort(typ, col) {
        $('#search-form').closest('form').find('#excel').remove();
        $('input[name=sort_by]').val(col);
        $('input[name=sort_type]').val(typ);
        submitForm();
    }
    $('body').on('click', "#checkAll", function () {
        $('input:checkbox').not(this).prop('checked', this.checked).change();
    });
    $("#delete-selected").click(function () {
        var ids = [];

        if (localStorage.getItem('listIds')) {
            ids = localStorage.getItem('listIds').split(',');
        }
        // var ids = localStorage.getItem('listIds').split(',');
        // var ids = $('input.ids:checked').map(function () {
        //     return $(this).val();
        // }).get();
        console.log("ids", ids);
        $.post(`{{route('products.delete-array')}}`, {
                ids: ids,
                _token: '{{csrf_token()}}'
            })
            .done(function (res) {
                ShowSuccess(res.message);
                submitForm();
                StoreAsArray('listIds', '', 'a',1)
            })
    });

    $('body').on('change', '.ids.with-v', function(){
        var ele = $(this);
        if (ele.is(':checked')) {
                console.log('checked');
                StoreAsArray('listIds', ele.val(), 'a')
            } else {
                console.log('unchecked');
                StoreAsArray('listIds', ele.val(), 'a',0,0)
            }
    });

    $('body').on('click', '#clear-selected', function(){
        $('input:checkbox').prop('checked', false);
                StoreAsArray('listIds', '', 'a',1)

    })

    function checkStored() {
        var t = [];

        if (localStorage.getItem('listIds')) {
            t = localStorage.getItem('listIds').split(',');
        }else{
            return;
        }
        // var t = localStorage.getItem('listIds').split(',');
        t.forEach(element => {
            $('.ids-'+element).prop('checked', true);
        });
        var filteredd = localStorage.getItem('listIds').split(',').filter(function (el) {
                    return el != '';
                    });
                if (filteredd.length == 0) {
                    $('.based-on-sel').prop('disabled', true);
                } else {
                    $('.based-on-sel').prop('disabled', false);

                }
    }
    checkStored();
    $(window).load(function(){

        if (localStorage.getItem('listIds')) {
            var filtered = localStorage.getItem('listIds').split(',').filter(function (el) {
                            return el != '';
                            });
                        $('#sel-count').html(filtered.length);

                    }
    });

    $('body').on('click', '.delete-btn',function(event) {
        event.preventDefault();

        var link = $(this);

        swal({
            title: "هل أنت متأكد؟",
            text: "أنك تريد حذف هذا العنصر ؟",
            icon: "warning",
            buttons: ["الغاء", "حذف"],
            dangerMode: true,
        }).then(function(isConfirm){
            if(isConfirm){
                var cr = $('meta[name="csrf-token"]').attr('content');
                var o = link;
                // alert(cr);
                $(o).append('<i class="fa fa-spin fa-spinner"></i>');
                $.post($(o).attr('href'),{
                _token:cr,
                _method:'DELETE'
                },function(data){
                $(o).find('i').remove();
                $(o).append('<i class="fa fa-check"></i>');
                setTimeout(function(){
                    $(o).closest('.deleted-row').remove();
                    $(o).parent().parent().remove();
                    if(typeof cb  == 'function'){
                    cb();
                    }
                },1000);

                checkStored();
                });
            }
            else{
                // swal("تم الالغاء", "الحذف  الغي بنجاح");
            }
        });

    });

</script>
@endsection
