<?php
namespace App\Traits\Admin;

use App\Http\Controllers\Api\FCMController;
use App\Notifications\GeneralNotification;
use Illuminate\Http\Request;
use App\Models\Order;
use App\Models\Driver;
use App\Models\PriceList;
use DB;
use Carbon\Carbon;
use App\Models\Admin;
use App\Notifications\AdminNotification;

trait OrderOperations
{
  

    /**
     * Register a New .
     *
     * @param $request
     * @return \App\
     */
    public function register ($request)
    {
        $data = $request->all();
        if ($request->hasFile('image')) {
            $data['image'] = uploadImage($request->file('image'));
        }
        DB::beginTransaction();
        $Order = Order::create($data);
        DB::commit();
        return $Order;
    }


    /**
     * Update Record
     * @param $truck
     * @param $request
     */
    public function UpdateRecords(Order $Order,$request)
    {
        $data = $request->all();
        if ($request->hasFile('image')) {
            @unlink(public_path('/cdn/'.$Order->image));
            // 
            $data['image'] = uploadImage($request->file('image'));
        }
        
        if ($request->has('status') && $request->get('status') != 'init' && $request->get('status') != $Order->status) {
            // check order type start
            
            // check order type end
            // send notification
            
            if( $Order->User->lang == 'ar')
                {
                    $title = "تم تغيير حالة الطلب رقم #". $Order->id;
                    $content = "تم تغيير حالة الطلب رقم #". $Order->id . ' الي '.trans('words.'.$request->status);

                }else{
                    $title = " status has been changed for order #".$Order->id;
                    $content = " status has been changed for order #".$Order->id . ' to '. trans('wordsen.'.$request->status);
                }
                $type = "order_details";
                
                $title_ar = "تم تغيير حالة الطلب رقم #".$Order->id;
                $title_en = " status has been changed for order #".$Order->id;
                $content_ar = "تم تغيير حالة الطلب رقم #".$Order->id . ' الي '.trans('words.'.$request->status);
                $content_en = " status has been changed for order #".$Order->id . ' to '. trans('wordsen.'.$request->status);
                $activity = "order_details";
                $data2 = [
                    'order' => $Order,
                    'title_ar' => $title_ar,
                    'title_en' => $title_en,
                    'content_ar' => $content_ar,
                    'content_en' => $content_en,
                    'type' => $type,
                ];
                $notifiable = $Order->User()->first();
                $token = $notifiable->PlayerId()->pluck('player_id')->toArray();
                FCMController::Push($title, $content,$token,$data2);
                $notifiable->notify(new GeneralNotification($title, $content, $type, $data2, $activity) );
                
                // send notification to admin start
                $admin = Admin::first();
                $admin->notify(new AdminNotification($content_ar . $Order->id , route('orders.show', $Order->id)));
                // send notification to admin end
                
                // send notification end
                    // $Order->OrderLog()->create([
                    //     'created_by_type' => 'admin',
                    //     'created_by_id' => auth()->id(),
                    //     'key' => 'status_changed',
                    //     'notes' => trans('words.order status has been changed by', ['by_name' => auth()->user()->name, 'status' => trans('words.'.$request->status) ]),
                    // ]); 
            }
        $Order->update($data);
        return $Order;
    }
    /**
     * delete Record
     * @param $truck
     * @param $request
     */
    public function DeleteRecord($id)
    {
        //
    }
}