<?php

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;

class Product extends Model
{
    protected $table='products';
    protected $fillable = [
            'title', 'id', 'price' , 'city_id' , 'type' , 'quantity' , 'description' , 'works' , 'branch_id' ,
             'model_id' , 'mission_id' , 'version' , 'maker_company' , 'year_id', 'category_id', 'user_id', 'daily_price', 'hour_price', 'active',
             'gasoline',
             'product_number' ,'plate_number' ,'chasis' ,'color' ,'location_number' ,'location_name' ,'model' ,'counter' ,'notes', 'skeleton_no'
       ];
    protected $appends = ['image', 'images', 'is_fav', 'city', 'rate', 'rate_count', 'cart_type', 'in_cart'];
    /**
     * Get all of the post's Files.
     */
    public function Files()
    {
        return $this->morphMany(Files::class, 'taggable');
    }
    public function Cart()
    {
        return $this->Hasmany(Cart::class, 'product_id');
    }
    public function ProductCity()
    {
        return $this->Hasmany(ProductCity::class, 'product_id');
    }
    public function OrderItem()
    {
        return $this->Hasmany(OrderItem::class, 'product_id');
    }
    public function ProductRating()
    {
        return $this->Hasmany(ProductRating::class, 'product_id');
    }


    public function User()
    {
        return $this->belongsTo(User::class, 'user_id');
    }

    public function Branch()
    {
        return $this->belongsTo(Branch::class, 'branch_id');
    }
    // public function City()
    // {
    //     return $this->belongsTo;
    // }
    /**
     * The City that belong to the Product
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsToMany
     */
    public function City()
    {
        return $this->belongsToMany(City::class, 'product_cities', 'product_id', 'city_id');
    }

    public function Models()
    {
        // <td> {{ $item->Models->name_ar ?? '' }} </td>     Models->name_ar da the name of the method
        return $this->belongsTo(Models::class, 'model_id');
    }
    public function Mission()
    {
        return $this->belongsTo(Mission::class, 'mission_id');
    }
    public function Year()
    {
        return $this->belongsTo(Year::class, 'year_id');
    }
    public function Category()
    {
        return $this->belongsTo(Category::class, 'category_id');
    }

    public function getImageAttribute()
    {
        if($this->Category()->first())
            $img = $this->Category()->first()->product_image;
        else
            $img = getImage('default.png');
        // if ($this->Files()->count() > 0 ) {
        //     return getImage($this->Files()->first()->name);
        // }elseif (sizeof($this->extrFilesP()) > 0 ) {
        //     return url($this->extrFilesP()[0]);
        // }
        return $img;
    }

    public function getImagesAttribute()
    {
        /*if ($this->Files()->count() > 0) {
            $arr = $this->Files()->get()->toArray();

            // foreach ($this->extrFilesP() as $k) {
            //     $it = new \stdClass;
            //     $it->id = 1;
            //     $it->name = url($k);
            //     $it->type = NULL;
            //     $it->original_name = "";
            //     $it->taggable_id = $this->id;
            //     $it->taggable_type = "";
            //     $it->created_at = "";
            //     $it->updated_at = "";
            //     $arr[] = $it;
            // }
            // return $arr;

        } elseif(sizeof($this->extrFilesP()) == 0 ) {
            $it = new \stdClass;
            $it->id = 0;
            $it->name = getImage('default.png');
            $it->type = NULL;
            $it->original_name = "";
            $it->taggable_id = 0;
            $it->taggable_type = "";
            $arr = [$it];
        }
        if (sizeof($this->extrFilesP()) > 0 ) {

            foreach ($this->extrFilesP() as $k) {
                $it = new \stdClass;
                $it->id = 1;
                $it->name = url($k);
                $it->type = NULL;
                $it->original_name = "";
                $it->taggable_id = $this->id;
                $it->taggable_type = "";
                $it->created_at = "";
                $it->updated_at = "";
                $arr[] = $it;
            }

        }*/
        if($this->Category()->first())
            $img = $this->Category()->first()->product_image;
        else
            $img = getImage('default.png');
        $arr = array();
            $it = new \stdClass;
            $it->id = 0;
            // $it->name = getImage('default.png');
            $it->name = $img;
            $it->type = NULL;
            $it->original_name = "";
            $it->taggable_id = 0;
            $it->taggable_type = "";
            $arr = [$it];
        return $arr;

    }
    public function getCityAttribute()
    {
        return City::where('id', Request()->header('city_id'))->first();
    }
    public function getIsFavAttribute()
    {
        if ($user = auth('api')->user() ) {
            if ($user->Favourite()->where('product_id', $this->id)->first()) {
                return true;
            }
        }
        return false;
    }
    public function getRateAttribute()
    {
        return 2;
    }
    public function getPriceAttribute($p)
    {
        if (request()->segment(1) == 'api') {

            return round(PriceWithVat($p),2);
        } else {
            return $p;
        }
    }
    public function getDailyPriceAttribute($p)
    {
        if (request()->segment(1) == 'api') {

            return round(PriceWithVat($p),2);
        } else {
            return $p;
        }

    }
    public function getHourPriceAttribute($p)
    {
        if (request()->segment(1) == 'api') {

            return round(PriceWithVat($p),2);
        } else {
            return $p;
        };
    }
    public function getQuantityAttribute($p)
    {
        return (int)$p;
    }
    public function getRateCountAttribute()
    {
        return 20;
    }
    public function getCartTypeAttribute()
    {
        if (auth('api')->user() && auth('api')->user()->Cart()->first()) {
            return auth('api')->user()->Cart()->first()->product_type;
        }elseif(Request()->header('uuid') && \DB::table('carts')->where('uuid', Request()->header('uuid'))->count() > 0){
            return \DB::table('carts')->where('uuid', Request()->header('uuid'))->first()->product_type;
        }

        return '';
    }
    public function getInCartAttribute()
    {
        $vacations = Vacation::whereDate('day_date', '>=', Carbon::now() )->pluck('day_date')->toArray();
        if (auth('api')->user() && auth('api')->user()->Cart()->where('product_id', $this->id)->first()) {
            $pro = auth('api')->user()->Cart()->where('product_id', $this->id)->first();
            $pro2 = \DB::table('carts')->find($pro->id);
            if ($pro->rent_type == 'time') {
                $pro2->rent_day_time = $pro->CartItemDay()->select('day_date', 'time_from', 'time_to')->first();
                $pro2->rent_days = $vacations;
                // $pro2->rent_days = array();
                //
            } else {
                $pro2->rent_day_time = new \stdClass;
                $pro2->rent_days = array_merge($pro->CartItemDay()->pluck('day_date')->toArray(), $vacations);
                //
            }
            return $pro2;

        }elseif(\DB::table('carts')->where('uuid', Request()->header('uuid'))->where('product_id', $this->id)->first()){
            $pro = \DB::table('carts')->where('uuid', Request()->header('uuid'))->where('product_id', $this->id)->first();
            $pro2 = $pro;
            if ($pro->rent_type == 'time') {
                $pro2->rent_day_time = \DB::table('cart_item_days')->where('cart_id', $pro->id)->select('day_date', 'time_from', 'time_to')->first();
                $pro2->rent_days = $vacations;
                // $pro2->rent_days = array();
                //
            } else {
                $pro2->rent_day_time = new \stdClass;
                $pro2->rent_days =  array_merge(\DB::table('cart_item_days')->where('cart_id', $pro->id)->pluck('day_date')->toArray(), $vacations);
                //
            }
            return $pro2;
        }

        return null;
    }

    public function extrFiles()
    {
        $files = glob("cdn/products/".$this->product_number."/*.{jpg,png,gif,jpeg}", GLOB_BRACE);
        $arr = [];
        foreach($files as $file) {
           $arr[] = url('cdn/products/'.$this->product_number.'/'.$file);
        }
        return $arr;
    }
    public function extrFilesP()
    {
        $files = glob("cdn/products/".$this->product_number."/*.{jpg,png,gif,jpeg}", GLOB_BRACE);
        $arr = [];
        foreach($files as $file) {
           $arr[] = $file;
        }
        return $arr;
    }

    public function hasFolder()
    {
        if (file_exists("/cdn/products/".$this->product_number)) {
            $it = new \stdClass;
                $it->id = 1;
                $it->name = '';
                $it->type = NULL;
                $it->original_name = "";
                $it->taggable_id = '';
                $it->taggable_type = "";
                $it->created_at = "";
                $it->updated_at = "";
                return $it;
        } else {
            return new \stdClass;

        }

    }
    // public function getGasolineCostAttribute()
    // {
    //     return $this->gasoline * (float)getSettingValue('gasoline_cost');
    // }
    // public function getHousingCostAttribute()
    // {
    //     return (float)getSettingValue('housing_cost');
    // }
    // public function getMoveCostAttribute()
    // {
    //     if (request()->has('city_id') && $this->ProductCity()->where('city_id', request()->get('city_id') )->first() ) {
    //         return $this->ProductCity()->where('city_id', request()->get('city_id') )->first()->cost;
    //     }
    //     return 0;
    // }
}
