<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Models extends Model
{
    protected $table='models';
    protected $fillable = [
        'image', 'name_ar', 'name_en', 'active', 
    ];
    protected $appends = [
        'name', 
    ];

    public function getNameAttribute()
    {
        if (Request()->header('lang') == 'en') {
            return $this->name_en;
        }else{
            return $this->name_ar;
        }
    }
    public function products()
    {
        return $this->Hasmany(products::class, 'model_id');
    }
}
