<?php

namespace App\Http\Controllers\Api;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

class OrderRateController extends Controller
{
    public function index(Request $request)
    {
        $user = auth('api')->user();
        $rates = $user->OrderRating()->with('Order')->with('User')->get();
        return Response()->json([
            'data' => [
                'rates' => $rates,
                'total' => (int)$user->OrderRating()->avg('rate')
            ],
            'message' => 'success',
            'code' => getMsgCode('success')
        ]);
    }
    public function store(Request $request)
    {
        $user = auth('api')->user();
        $data = $request->all();
        $user->OrderRating()->create($data);
        return Response()->json([
            'data' => [
            ],
            'message' => 'success',
            'code' => getMsgCode('success')
        ]);
    }
}
