<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Admin\CityController;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Admin;
use App\Models\Setting;
use App\Models\City;
use App\Models\Category;
use App\Models\Year;
use App\Models\Mission;
use App\Models\Models;
use App\Models\Order;
use App\Models\Product;
use App\Models\Vacation;
use App\Notifications\AdminNotification;
use Carbon\Carbon;
use Carbon\CarbonInterval;

class AppInfoController extends Controller
{
    public function index($type = 'home')
    {
        if($type == 'home')
        {
            $cities = City::latest()->get();
            $missions = Mission::latest()->get();
            $categories = Category::latest()->get();
            $years = Year::latest()->get();
            $models = Models::latest()->get();
            return Response()->json([
                    'data' => [
                        'cities' => $cities,
                        'categories' => $categories,
                        'missions' => $missions,
                        'years' => $years,
                        'models' => $models,
                    ],
                    'message' => 'success',
                    'code' => getMsgCode('success')
            ]);
        }
        if($type == 'cities')
        {
            $cities = City::latest()->get();
            return Response()->json([
                    'data' => [
                        'cities' => $cities,
                    ],
                    'message' => 'success',
                    'code' => getMsgCode('success')
            ]);
        }

        $info = Setting::pluck('value', 'key')->toArray();

        return Response()->json([
                'data' => [
                    'info' => $info,
                ],
                'message' => 'success',
                'code' => getMsgCode('success')
        ]);
    }
    public function checkPoint(Request $request)
    {
        $lat = $request->get('latitude');
        $long = $request->get('longitude');
        $pro = Product::find($request->product_id);
        $city_c = new CityController;
        $res = 0;
        $cities = City::get();
        $item = null;
        $city = null;
        foreach ($cities as $item) {
            $resu = $city_c->checkP($item->id, $lat , $long);
            if ($resu == true) {
                $res = 1;
                $city = $item;
                break;
            }
        }
        if ($city && $pro->ProductCity()->where('city_id', $city->id)->first() ) {
            return response()->json([
                'data'   => [
                    'result' => 1,
                    'move_cost' => PriceWithVat($pro->ProductCity()->where('city_id', $city->id)->first()->cost),
                    'city' => $city,
                ],
                'message'   => 'success',
                'code'      => getMsgCode('success')
            ]);

        }
        return response()->json([
            'data'   => [
                'result' => 0,
                'move_cost' => null,
                'city' => $city,
            ],
            'message'   => trans('words.location not available'),
            'code'      => getMsgCode('somethingWrong')
        ]);
    }
    public function getHolidays($start_date, $end_date, $months)
    {
        $fromDate = new Carbon($start_date);
        $toDate = $end_date;
        // Get the date range
        // $fromDate = new Carbon('2021-08-01');
        // $toDate = Carbon::parse('2021-08-01')->addMonths(3)->todatestring();

        // Get the first Friday in the date range
        $date = $fromDate->dayOfWeek == Carbon::FRIDAY
            ? $fromDate
            : $fromDate->copy()->modify('next Friday');


        $dates = [];
        // Iterate until you have reached the end date adding a week each time
        while ($date->lt($toDate)) {
            $dates[] = $date->toDateString();
            $date->addWeek();
        }
        $size_of_vacations = Vacation::whereNotIn('day_date', $dates)->whereDate('day_date', '>=', $fromDate)->whereDate('day_date', '<=', $toDate)->count();
        $list_vacations = Vacation::whereNotIn('day_date', $dates)->whereDate('day_date', '>=', $fromDate)->whereDate('day_date', '<=', $toDate)->pluck('day_date')->toArray();
        // return $dates;
        $expected = $months * 26;
        // dd($expected);
        $diff = $fromDate->diffInDays($toDate);
        $diff = $diff - (sizeof($dates) + $size_of_vacations);
        if ($diff > $expected) {
            return $this->getHolidays($start_date, Carbon::parse($end_date)->subDays(1), $months );
        }elseif ($diff < $expected){
            return $this->getHolidays($start_date, Carbon::parse($end_date)->addDays(1), $months );
        }
        // $toDate;
        $toDate = $toDate->subDays(1);
        $all = [];
        $date1 = $fromDate;
        // dd($dates);
        while ($date1->lt($toDate)) {
            $date1->addDay();
            $all[] = $date1->toDateString();
        }
        $all[] = $toDate->toDateString();
        // return array_merge($dates, $list_vacations);
        $res = array_diff($all, array_merge($dates, $list_vacations));
        // dd(sizeof($res));
        return [
                // 'days'=> $days,
                'diff'=> $diff,
                'expected'=> $months * 26,
                'dates'=> $dates,
                'res'=> $res,
        ];
    }
    public function days(Request $request)
    {
        $months = 1;
        $toDate = Carbon::parse($request->start_date)->addMonths($months)->todatestring();
        return $this->getHolidays($request->start_date, $toDate, $months);
    }

    public function AdminNoti()
    {
        $orders = Order::whereDate('end_date', Carbon::now()->addDays(1))->get();
        foreach ($orders as $order) {
            Admin::first()->notify(new AdminNotification('سيتم عودة معدات الطلب #'. $order->id . ' غدا من موقع العمل', route('orders.show', $order->id)));
        }
        $orders_1 = Order::get()->where('start_date', Carbon::now()->addDays(1)->format('Y-m-d'));
        foreach ($orders_1 as $order1) {
            Admin::first()->notify(new AdminNotification('سيتم انتقال معدات الطلب #'. $order1->id . ' غدا الي موقع العمل', route('orders.show', $order1->id)));
        }
    }
}
