<?php

namespace App\Http\Controllers\Admin;

use App\Http\Requests\Admin\UpdateBranchRequest;
use App\Http\Requests\Admin\StoreBranchRequest;
use App\Http\Controllers\Controller;
use App\Traits\Admin\BranchOperations;
use Illuminate\Http\Request;
use App\Models\Admin;
use App\Models\Branch;
use Auth;

class BranchController extends Controller
{
    use BranchOperations;
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */

    public function __construct()
    {
        // $this->middleware('Permission:engBranch_show'    , ['only' => 'index', 'show']);
        // $this->middleware('Permission:engBranch_add'     , ['only' => 'create', 'store']);
        // $this->middleware('Permission:engBranch_edit'    , ['only' => 'edit', 'update']);
        // $this->middleware('Permission:engBranch_delete'  , ['only' => 'destroy']);
    }
    public function index()
    {
        $branches = Branch::orderBy('id', 'asc')->get();
        $title = 'الفروع';
        return view('admin.branches.index', compact('branches', 'title'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $title = 'اضافة الفرع';
        return view('admin.branches.add', compact('title'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(StoreBranchRequest $request)
    {
        $this->register($request);
        return redirect('/dashboard/branches')->with('success', 'data added successfully');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show(Branch $branch)
    {
        $title = 'عرض الفرع';
        return view('admin.branches.show', compact('branch', 'title'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $branch = Branch::find($id);
        $title = 'تعديل الفرع';
        return view('admin.branches.edit', compact('branch', 'title'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(UpdateBranchRequest $request, Branch $branch)
    {
        // $branch = Branch::find($id);
        $this->UpdateRecords($branch, $request);
        return redirect('/dashboard/branches')->with('success', 'data added successfully');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Branch $branch)
    {
        if ($branch->image) {
            @unlink(public_path('/cdn/'.$branch->image));
        }
        $branch->delete();
        return 'success';
    }
    public function logout()
    {
        Auth::logout();
        return redirect('/login');
    }
}
