<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/cache', function(){
    Artisan::call('cache:clear');
    Artisan::call('config:cache');
    Artisan::call('migrate');
});
Route::get('/', function () {
    return view('welcome');
});
Route::get('/page/privacy', function () {
    return view('privacy');
});
Route::get('/page/seed', function () {
    $files = \App\Models\Files::get();
    $i=0;
    foreach($files as $f)
    {
        $p = \App\Models\Product::find($f->taggable_id);
        if($p)
        {
            $i++;
            // $f->original_name = $p->product_number;
            // $f->save();
        }
    }
    return $i;
});

// Auth::routes();

Route::get('/home', 'HomeController@index')->name('home');

/*===============================================
|                  admin                        |
===============================================*/

Route::group(['namespace' => 'Admin'], function() {
    Route::get('/order-bill-view/{id}', 'OrderController@billView')->name('order-bill-view');
    Route::get('/admin/login', 'AuthController@loginForm')->name('login');
    Route::post('/admin/login', 'AuthController@login');





    Route::group(['prefix' => 'dashboard', 'middleware' => 'auth:admin'], function() {
        Route::post('/logout', 'AuthController@logout')->name('logout');
        Route::get('/', 'HomeController@index');
        Route::resource('/users', 'UserController');
        Route::post('/users-post', 'UserController@indexPost')->name('users.index-post');
        Route::post('/users-deleteArray', 'UserController@deleteArray')->name('users.delete-array');
        Route::post('/users-update-array', 'UserController@updateArray')->name('users.update-array');
        Route::resource('/drivers', 'DriverController');
        Route::resource('/orders', 'OrderController');
        Route::post('/orders-post', 'OrderController@indexPost')->name('orders.index-post');
        Route::post('/orders-deleteArray', 'OrderController@deleteArray')->name('orders.delete-array');
        Route::post('/orders-update-array', 'OrderController@updateArray')->name('orders.update-array');
        Route::get('/orders-bill/{id}', 'OrderController@bill')->name('orders-bill');
        Route::resource('/coupons', 'CouponController');
        Route::resource('/cities', 'CityController');
        Route::resource('/vacations', 'VacationController');
        Route::resource('/company-orders', 'CompanyOrderController');
        Route::resource('/pricelists', 'PriceListController');
        Route::resource('/branches', 'BranchController');
        Route::resource('/transactions', 'TransactionController');
        Route::resource('/trips', 'TripController');
        Route::resource('/payments', 'PaymentController');
        Route::resource('/products', 'ProductController');
        Route::post('/products-post', 'ProductController@indexPost')->name('products.index-post');
        Route::post('/products-deleteArray', 'ProductController@deleteArray')->name('products.delete-array');
        Route::post('/products-update-array', 'ProductController@updateArray')->name('products.update-array');
        Route::resource('/product-cities', 'ProductCityController');
        Route::post('/products-excel', 'ProductController@Import');
        Route::resource('/sliders', 'SliderController');
        Route::resource('/notifications', 'NotificationController')->only(['index', 'store']);
        Route::get('/export-excel/{type}', 'SettingsController@ExportExcel');

        Route::group(['prefix' => 'reports'], function () {
            Route::get('cities', 'ReportController@Cities');
            Route::post('cities/{type?}', 'ReportController@citiesPost');
        });

        Route::group(['prefix' => 'settings'], function() {
            Route::get('/site', 'SettingController@index');
            Route::post('/site', 'SettingController@store');



            Route::get('/admins', 'SettingsController@AdminGet');
            Route::post('/admins', 'SettingsController@AdminPost');
            Route::get('/admins-edit/{id}', 'SettingsController@AdminEdit');
            Route::post('/admins-update/{id}', 'SettingsController@AdminUpdate');
            Route::delete('/admins-delete/{id}', 'SettingsController@AdminDelete');

            Route::get('/regions', 'SettingsController@RegionGet');
            Route::post('/regions', 'SettingsController@RegionPost');
            Route::post('/regions-update/{id}', 'SettingsController@RegionUpdate');
            Route::delete('/regions-delete/{id}', 'SettingsController@RegionDelete');

            Route::get('/car-types', 'SettingsController@CarTypeGet');
            Route::post('/car-types', 'SettingsController@CarTypePost');
            Route::post('/car-types-update/{id}', 'SettingsController@CarTypeUpdate');
            Route::delete('/car-types-delete/{id}', 'SettingsController@CarTypeDelete');

            Route::get('/bustypes', 'SettingsController@BusTypeGet');
            Route::post('/bustypes', 'SettingsController@BusTypePost');
            Route::post('/bustypes-update/{id}', 'SettingsController@BusTypeUpdate');
            Route::delete('/bustypes-delete/{id}', 'SettingsController@BusTypeDelete');

            Route::get('/colors', 'SettingsController@ColorGet');
            Route::post('/colors', 'SettingsController@ColorPost');
            Route::post('/colors-update/{id}', 'SettingsController@ColorUpdate');
            Route::delete('/colors-delete/{id}', 'SettingsController@ColorDelete');

            Route::get('/years', 'SettingsController@YearGet');
            Route::post('/years', 'SettingsController@YearPost');
            Route::post('/years-update/{id}', 'SettingsController@YearUpdate');
            Route::delete('/years-delete/{id}', 'SettingsController@YearDelete');
// *********************************
            Route::get('/models', 'SettingsController@ModelsGet');
            Route::post('/models', 'SettingsController@ModelsPost');
            Route::post('/models-update/{id}', 'SettingsController@ModelsUpdate');
            Route::delete('/models-delete/{id}', 'SettingsController@ModelsDelete');
            // ***********************************************************************
            Route::get('/missions', 'SettingsController@MissionsGet');
            Route::post('/missions', 'SettingsController@MissionsPost');
            Route::post('/missions-update/{id}', 'SettingsController@MissionsUpdate');
            Route::delete('/missions-delete/{id}', 'SettingsController@MissionsDelete');
            // ********************************************************************
            Route::get('/categories', 'SettingsController@CategoriesGet');
            Route::post('/categories', 'SettingsController@CategoriesPost');
            Route::post('/categories-update/{id}', 'SettingsController@CategoriesUpdate');
            Route::delete('/categories-delete/{id}', 'SettingsController@CategoriesDelete');
// **********************************
            Route::get('/price-lists', 'SettingsController@PriceListGet');
            Route::post('/price-lists', 'SettingsController@PriceListPost');
            Route::post('/price-lists-update/{id}', 'SettingsController@PriceListUpdate');
            Route::delete('/price-lists-delete/{id}', 'SettingsController@PriceListDelete');

            Route::get('/permissions', 'SettingsController@PermissionGet');
            Route::post('/permissions', 'SettingsController@PermissionPost');
            Route::post('/permissions-update/{id}', 'SettingsController@PermissionUpdate');
            Route::delete('/permissions-delete/{id}', 'SettingsController@PermissionDelete');
            Route::delete('/user-permissions-delete/{id}', 'SettingsController@PermissionDeleteUser');
            Route::post('/user-role', 'SettingsController@UserRole');
        });
    });

    Route::group(['prefix' => 'ajax'], function(){
        Route::get('/class-rooms/{id}', 'AjaxController@ClassRooms');
        Route::get('/bus-types/{id}', 'AjaxController@BusTypes');
        Route::get('/drivers-by-type/{type}', 'AjaxController@GetDriversByType');
    });
});
// ajax start

Route::group(['prefix' => 'ajax'], function(){
    Route::get('/get-sons/{id}', 'Admin\AjaxController@getSons');
    Route::get('/get-orders-for-trip/{s_id}/{d_id}', 'Admin\AjaxController@OrdersForTrip');
    Route::delete('/file/delete/{id}', 'Admin\AjaxController@DeleteFile');
});
// ajax end
// cron job
// Route::get('/notify-drivers', 'CronJobController@CheckTrip');
// Route::get('/notify-transaction', 'CronJobController@transaction');
// Route::get('/notify-tripLog', 'CronJobController@tripLog');
// cron job end
/*===============================================
|                 admin                         |
===============================================*/


