<?php

use Illuminate\Http\Request;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::group(['prefix' => '/v1', 'namespace' => 'Api'], function() {
    Route::get('/test-fcm/{type}', 'NotificationTestController@test');
    Route::group(['prefix' => '/pages'], function() {
        Route::get('/home', 'PageController@home');
        Route::get('/cities', 'PageController@Cities');
        Route::post('/filter', 'PageController@filter');
        Route::get('/filter', 'PageController@filter');
        Route::get('/product/{id}', 'PageController@productView');
    });
    Route::group(['prefix' => '/user'], function() {
        Route::post('/signup', 'UserController@store');
        Route::post('/signin', 'UserController@login');
        Route::post('/send-verify-code', 'UserController@sendVerifyCode');
        Route::post('/verify-phone', 'UserController@phoneVerify');
        Route::post('/check-user', 'UserController@CheckUser');
        Route::post('/check-business-account', 'UserController@CheckVIP');
        Route::post('/forget-password', 'UserController@sendVerifyForgetPasswordNum');
        Route::post('/verify-forget-password', 'UserController@verifyForgetPassword');
        Route::group(['prefix' => 'no-auth'], function() {
            Route::group(['prefix' => 'carts'], function () {
                Route::post('/add'      , 'CartNoAuthController@addToCart');
                Route::post('/update/{id}'      , 'CartNoAuthController@updateCartItem');
                Route::post('/delete'   , 'CartNoAuthController@removeFromCart');
                Route::post('/costs'      , 'CartController@costs');
                Route::get('/view'      , 'CartNoAuthController@viewCart');
            });
        });
        Route::group(['middleware' => 'auth:api'], function() {
        	Route::post('/delete-account', 'UserController@delete');
        	Route::post('/logout', 'UserController@logout');
            Route::post('/update', 'UserController@update');
            Route::post('/vip-request', 'UserController@VIPRequest');
            Route::get('/profile', 'UserController@profile');
            Route::get('/show', 'UserController@show');
            Route::get('/my-orders-rate', 'UserController@MyOrdersRate');
            Route::get('/notifications', 'UserController@notifications');
            Route::post('/notification-mark-as-readed', 'UserController@notificationReaded');
            Route::group(['prefix' => 'orders'], function(){
                // Route::post('/add', 'OrderController@store');
                Route::get('/view/{id}', 'OrderController@show');
                Route::post('/update/{id}', 'OrderController@update');
                Route::get('/all', 'OrderController@index');
                // Route::post('/cancel', 'OrderController@orderCancel');
                Route::post('/delete/{id}', 'OrderController@destroy');
                // Route::post('/create'      , 'OrderController@proceedToCheckout');
                Route::post('/create'      , 'OrderController@createOrder');
            });
            Route::group(['prefix' => 'company-orders'], function () {
                Route::get('/all', 'CompanyOrderController@index');
                Route::post('/create'      , 'CompanyOrderController@store');
                Route::get('/view/{id}', 'CompanyOrderController@show');
            });
            Route::group(['prefix' => 'payment'], function () {
                Route::post('/create-checkout', 'TransactionController@PrepareCheckout');
                Route::post('/request', 'TransactionController@PaymentRequest');
            });
            Route::group(['prefix' => 'carts'], function () {
                Route::post('/add'      , 'CartController@addToCart');
                Route::post('/update/{id}'      , 'CartController@updateCartItem');
                Route::post('/delete'   , 'CartController@removeFromCart');
                Route::get('/view'      , 'CartController@viewCart');
                Route::post('/costs'      , 'CartController@costs');
                Route::post('/coupon'      , 'CartController@checkCoupon');
            });
            Route::group(['prefix' => 'vip-carts'], function () {
                Route::post('/add'      , 'VIPCartController@addToCart');
                Route::post('/delete'   , 'VIPCartController@removeFromCart');
                Route::get('/view'      , 'VIPCartController@viewCart');
            });
            Route::group(['prefix' => 'products'], function(){
                Route::post('/add', 'ProductController@store');
                Route::get('/view/{id}', 'ProductController@show');
                Route::post('/update/{id}', 'ProductController@update');
                Route::post('/delete/{id}', 'ProductController@destroy');
                Route::get('/all', 'ProductController@index');
            });
            Route::group(['prefix' => 'favourites'], function(){
                Route::post('/toggle/{id}', 'FavouriteController@toggle');
                Route::get('/all', 'FavouriteController@index');
            });
            Route::group(['prefix' => 'rates'], function(){
                Route::post('/add', 'OrderRateController@store');
                Route::get('/all', 'OrderRateController@index');
            });
            Route::group(['prefix' => 'vip'], function(){
                Route::get('/reviews', 'UserController@VIPAccountRates');
            });

        });
    });
    Route::group(['prefix' => 'contactus'], function(){
        Route::post('/send', 'ContactUsController@store');
    });

    Route::get('/settings', 'HomeController@Settings');
    Route::get('/days', 'AppInfoController@days');
    Route::get('/app-info/{type?}', 'AppInfoController@index');
    Route::post('check-location', 'AppInfoController@checkPoint');
    Route::post('/upload-file', 'HomeController@UploadFile');
    Route::get('/notifications-user', 'HomeController@PushToUser');
    // order data
    Route::get('/order-info', 'OrderController@OrderInfo');
    Route::post('/get-price', 'OrderController@GetPrice');
    Route::post('/payment-callback', 'OrderController@Payment');
    Route::post('/branch-to-branch/{from_city_id}/{to_city_id}', 'OrderController@BranchToBranch');
    Route::get('/notify-admin', 'AppInfoController@AdminNoti');
});

Route::group(['prefix' => '/service', 'middleware' => ['servicemw']], function() {
    // service
    Route::resource('products', 'ServiceController');
    Route::delete('products-array', 'ServiceController@deleteArray');
    Route::delete('products-clear', 'ServiceController@clear');
    // service
});
