<!doctype html>
<html lang="en">
@php
    use Carbon\Carbon;
@endphp
<head>
    <!-- Required meta tags -->
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">


    <link rel="stylesheet" href="/bill/omierstyle.css">
    <style>
        .row2>div {
            width: 50%;
        }
        .row3>div {
            width: 48%;
        }
        .tableR  tr:first-child td:first-child{
            border-top-left-radius: 40px !important;
        }
        .tableR  tr:last-child td:first-child{
            border-top-left-radius: 40px;

        }
        .tableR  tr:last-child td:last-child{
            border-top-right-radius: 40px;

        }
        .tableR  tr:last-child td:last-child{
            border-top-right-radius: 40px;

        }
        .tableR  tr{
            line-height: 30px;
        }
        .tableRE tr td{
            padding: 5px;
        }
        .tableRE tr{
            line-height: 25px;
        }
        .tableR{
            margin: 5px;
        }
    </style>
    <title>omierbill</title>
</head>

<body onload="window.print()">
    <!---- header------------------>


    <div class="page">
        <div class="row1 flex">
            <div class="ar-box">
                {{-- <div>شركة الأومير للتجارة والمقاولات</div>
                <div>شركة سعودية مساهمة مقفلة</div>
                <div> سجل تجاري :1123000085</div> --}}
            </div>
            <div class="img-box">
                <img src="/bill/logo.png" alt="logo">
            </div>
            <div class="e-box">
                {{-- <div>Alomaier Trading And Contracting Co.</div>
                <div> Saudi Closed Joint - stock company</div>
                <div> CR : 1123000085</div> --}}
            </div>

        </div>
        <h5 class="title"><span class="border">فاتورة ضريبية</span></h5>
        <div class="row2 flex">
            <div class="ar-box">
                <div class="scan">
                    <!--<img src="/bill/brc.png" alt="">-->
                    {!! DNS2D::getBarcodeSVG('Bill no. :'.$order->id.'', 'QRCODE',6,6) !!}

                </div>
            </div>
            <div class="e-box">
                <table class="tableRE" style="width:100%;direction: rtl;border: 1px solid; font-size: 15px">
                    <tr style="border-bottom: 1px solid;">
                        <td style="font-size: 18px; font-weight: bold; text-align: right; padding-right: 5px;">رقم الفاتورة  Inv No.</td>
                        <td style="font-size: 18px; font-weight: bold; text-align: center;">{{$order->id}}</td>
                    </tr>
                    <tr style="border-bottom: 1px solid;">
                        <td style="font-size: 18px; font-weight: bold; text-align: right; padding-right: 5px;">تاريخ الفاتورة  date</td>
                        <td style="font-size: 18px; font-weight: bold; text-align: center;">{{\Carbon\Carbon::now()->format('Y-m-d')}}</td>
                    </tr>
                    <tr style="border-bottom: 1px solid;">
                        <td style="font-size: 18px; font-weight: bold; text-align: right; padding-right: 5px;">تاريخ التوريد  S.date</td>
                        <td style="font-size: 18px; font-weight: bold; text-align: center;">{{\Carbon\Carbon::now()->format('Y-m-d')}}</td>
                    </tr>
                    <!--<tr style="border-bottom: 1px solid;">-->
                    <!--    <td style="font-size: 18px; font-weight: bold; text-align: right; padding-right: 5px;">الوصف  Desc</td>-->
                    <!--    <td style="font-size: 18px; font-weight: bold; text-align: center;"></td>-->
                    <!--</tr>-->
                    <tr style="border-bottom: 1px solid;">
                        <td style="font-size: 18px; font-weight: bold; text-align: right; padding-right: 5px;">طريقة الدفع  Pay.T</td>
                        <td style="font-size: 18px; font-weight: bold; text-align: center;">نقدي</td>
                    </tr>
                </table>
            </div>

        </div>
        <!--<br/>-->
        <div class="row3 flex" style="justify-content: space-between; margin-bottom:5px; margin-top:5px;">
            <div class="ar-box">
                <table class="tableRE" style="width:100%;direction: rtl;border: 1px solid; font-size: 15px">
                    <tr>
                        <td style="font-size: 18px; font-weight: bold; text-align: right; padding-right: 5px;">بيانات البائع </td>
                        <td style="font-size: 18px; font-weight: bold; text-align: center;"></td>
                        <td style="font-size: 18px; font-weight: bold; text-align: left;">Seller Info</td>
                    </tr>
                    <tr>
                        <td style="font-size: 18px; font-weight: bold; text-align: right; padding-right: 5px;">اسم الشركة </td>
                        <td style="font-size: 18px; font-weight: bold; text-align: center;"> </td>
                        <td style="font-size: 18px; font-weight: bold; text-align: left;">Company Name</td>
                    </tr>
                    <tr>
                        <td style="font-size: 18px; font-weight: bold; text-align: center;" colspan="3">شركة الأومير للتجارة و المقاولات</td>
                    </tr>
                    <tr>
                        <td style="font-size: 18px; font-weight: bold; text-align: right; padding-right: 5px;">اسم الفرع </td>
                        <td style="font-size: 18px; font-weight: bold; text-align: center;">المركز الرئيسي</td>
                        <td style="font-size: 18px; font-weight: bold; text-align: left;">Branch Name</td>
                    </tr>
                    <!--<tr>-->
                    <!--    <td style="font-size: 18px; font-weight: bold; text-align: right; padding-right: 5px;">رقم المبني </td>-->
                    <!--    <td style="font-size: 18px; font-weight: bold; text-align: center;">8656</td>-->
                    <!--    <td style="font-size: 18px; font-weight: bold; text-align: left;">Building No.</td>-->
                    <!--</tr>-->
                    <tr>
                        <td style="font-size: 18px; font-weight: bold; text-align: right; padding-right: 5px;">اسم الشارع </td>
                        <td style="font-size: 18px; font-weight: bold; text-align: center;">{{getSettingValue('address')}}</td>
                        <td style="font-size: 18px; font-weight: bold; text-align: left;">Address</td>
                    </tr>
                    <tr>
                        <td style="font-size: 18px; font-weight: bold; text-align: right; padding-right: 5px;">المدينة </td>
                        <td style="font-size: 18px; font-weight: bold; text-align: center;">{{getSettingValue('city')}}</td>
                        <td style="font-size: 18px; font-weight: bold; text-align: left;">City</td>
                    </tr>
                    <tr>
                        <td style="font-size: 18px; font-weight: bold; text-align: right; padding-right: 5px;">المنطقة </td>
                        <td style="font-size: 18px; font-weight: bold; text-align: center;">{{getSettingValue('area')}}</td>
                        <td style="font-size: 18px; font-weight: bold; text-align: left;">Area</td>
                    </tr>
                    <tr>
                        <td style="font-size: 18px; font-weight: bold; text-align: right; padding-right: 5px;">البلد </td>
                        <td style="font-size: 18px; font-weight: bold; text-align: center;">السعودية</td>
                        <td style="font-size: 18px; font-weight: bold; text-align: left;">Country</td>
                    </tr>
                    <!--<tr>-->
                    <!--    <td style="font-size: 18px; font-weight: bold; text-align: right; padding-right: 5px;">الرمز البريدي </td>-->
                    <!--    <td style="font-size: 18px; font-weight: bold; text-align: center;">{{getSettingValue('posta')}}</td>-->
                    <!--    <td style="font-size: 18px; font-weight: bold; text-align: left;">Postal Code</td>-->
                    <!--</tr>-->
                    <tr>
                        <td style="font-size: 18px; font-weight: bold; text-align: right; padding-right: 5px;">الرقم الضريبي </td>
                        <td style="font-size: 18px; font-weight: bold; text-align: center;">{{getSettingValue('tax_number')}}</td>
                        <td style="font-size: 18px; font-weight: bold; text-align: left;">Vat No</td>
                    </tr>
                </table>
            </div>
            <div class="e-box">
                <table class="tableRE" style="width:100%;direction: rtl;border: 1px solid; font-size: 15px">
                    <tr>
                        <td style="font-size: 18px; font-weight: bold; text-align: right; padding-right: 5px;">بيانات العميل </td>
                        <td style="font-size: 18px; font-weight: bold; text-align: center;"></td>
                        <td style="font-size: 18px; font-weight: bold; text-align: left;">Customer Info</td>
                    </tr>
                    <tr>
                        <td style="font-size: 18px; font-weight: bold; text-align: right; padding-right: 5px;">اسم العميل </td>
                        <td style="font-size: 18px; font-weight: bold; text-align: center;"></td>
                        <td style="font-size: 18px; font-weight: bold; text-align: left;">Customer Name</td>
                    </tr>
                    <tr>
                        <td style="font-size: 18px; font-weight: bold; text-align: center;" colspan="3">{{$order->User->name ?? ''}}</td>
                    </tr>
                    <tr>
                        <td style="font-size: 18px; font-weight: bold; text-align: right; padding-right: 5px;">رقم الجوال </td>
                        <td style="font-size: 18px; font-weight: bold; text-align: center;">{{$order->User->phone ?? ''}}</td>
                        <td style="font-size: 18px; font-weight: bold; text-align: left;">Mobile No.</td>
                    </tr>
                    <tr>
                        <td style="font-size: 18px; font-weight: bold; text-align: right; padding-right: 5px;">رقم المبني </td>
                        <td style="font-size: 18px; font-weight: bold; text-align: center;"> </td>
                        <td style="font-size: 18px; font-weight: bold; text-align: left;">Building No.</td>
                    </tr>
                    <tr>
                        <td style="font-size: 18px; font-weight: bold; text-align: right; padding-right: 5px;">اسم الشارع </td>
                        <td style="font-size: 18px; font-weight: bold; text-align: center;">{{$order->User->address ?? ''}}</td>
                        <td style="font-size: 18px; font-weight: bold; text-align: left;">Address</td>
                    </tr>
                    <tr>
                        <td style="font-size: 18px; font-weight: bold; text-align: right; padding-right: 5px;">المدينة </td>
                        <td style="font-size: 18px; font-weight: bold; text-align: center;">{{$order->User->City->name ?? ''}}</td>
                        <td style="font-size: 18px; font-weight: bold; text-align: left;">City</td>
                    </tr>
                    <tr>
                        <td style="font-size: 18px; font-weight: bold; text-align: right; padding-right: 5px;">المنطقة </td>
                        <td style="font-size: 18px; font-weight: bold; text-align: center;"></td>
                        <td style="font-size: 18px; font-weight: bold; text-align: left;">Area</td>
                    </tr>
                    <tr>
                        <td style="font-size: 18px; font-weight: bold; text-align: right; padding-right: 5px;">البلد </td>
                        <td style="font-size: 18px; font-weight: bold; text-align: center;">السعودية</td>
                        <td style="font-size: 18px; font-weight: bold; text-align: left;">Country</td>
                    </tr>
                    <tr>
                        <td style="font-size: 18px; font-weight: bold; text-align: right; padding-right: 5px;">الرمز البريدي </td>
                        <td style="font-size: 18px; font-weight: bold; text-align: center;"></td>
                        <td style="font-size: 18px; font-weight: bold; text-align: left;">Postal Code</td>
                    </tr>
                    <tr>
                        <td style="font-size: 18px; font-weight: bold; text-align: right; padding-right: 5px;">الرقم الضريبي </td>
                        <td style="font-size: 18px; font-weight: bold; text-align: center;"></td>
                        <td style="font-size: 18px; font-weight: bold; text-align: left;">Vat No</td>
                    </tr>
                </table>
            </div>

        </div>
        <!--<br/>-->
        {{-- <div class="text-center">اسم الفرع</div>
        <h5 class="title"><span class="border">فاتورة مبيعات</span></h5>
        <div class="flex-bt alig-center">
            <div class="box">
                <span class="lbl bold"> الرقم الضريبي : </span>
                <span class="val bold  f-18 "> {{getSettingValue('tax_number')}}</span>
            </div>
            <div class="box e-box">
                <div>print in</div>
                <div class="time">
                    {{Carbon::now()->format('d - m - Y h:i a')}}
                </div>
            </div>
        </div> --}}
        {{-- <div class="border det-box bold">
            <div class="line flex-bt">
                <div class="item">
                    <span class="lbl">الرقم :</span>
                    <span class="val"> {{$order->id}}</span>
                </div>
                <div class="item">
                    <span class="lbl">التاريخ :</span>
                    <span class="val"> {{$order->created_at->format('d - m - Y')}}</span>
                </div>
                <div class="item w-22">
                    <span class="lbl">الحالة :</span>
                    <span class="val"> @lang('words.'.$order->status)</span>
                </div>
            </div>
            <div class="line2 ">
                <div class="item">
                    <span class="lbl">مكان العمل :</span>
                    <span class="val"> {{$order->address}}</span>
                </div>
            </div>
            <div class="line3 flex-bt">
                <div class="item">
                    <span class="lbl">المستودع :</span>
                    <span class="val"> {{$order->OrderItem()->first()->City->name_ar ?? ''}}</span>
                </div>
                <div class="item nowrap">
                    <span class="lbl">رقم امر المبيعات :</span>
                    <span class="val"> {{$order->id}}</span>
                </div>
                <div class="item nowrap w-22">
                    <span class="lbl">رقم الملف :</span>
                    <span class="val"> {{$order->user_id}}</span>
                </div>
            </div>
            <div class="line4 flex-bt">
                <div class="item">
                    <span class="lbl">العنوان :</span>
                    <span class="val"> {{$order->Branch->address ?? ''}}</span>
                </div>
                <div class="item nowrap w-22">
                    <span class="lbl">العملة :</span>
                    <span class="val"> ريال</span>
                </div>

            </div>
            <div class="line5 flex-bt">
                <div class="item">
                    <span class="lbl">الرقم الضريبي للعميل :</span>
                    <span class="val"> {{$order->User->tax_number ?? ''}}</span>
                </div>
                <div class="item nowrap w-22">
                    <span class="lbl">سعر الصرف :</span>
                    <span class="val"> 1 </span>
                </div>

            </div>
            <div class="line5 flex-bt">
                <div class="item">
                    <span class="lbl">عنوان العميل :</span>
                    <span class="val"> {{$order->User->address ?? ''}} </span>
                </div>

            </div>
            <div class="line5 flex-bt">
                <div class="item">
                    <span class="lbl"> مندوب المبيعات :</span>
                    <span class="val"> </span>
                </div>

            </div>


        </div> --}}

        {{-- <div class="before-table border">الأصناف</div> --}}
        @php
            $net = 0;
            $original = 0;
        @endphp
        <table class="table table-bordered" style="margin-bottom: 0;">
            <thead>
                <tr>
                    <th scope="col">الرمز</th>
                    <th scope="col">اسم الصنف</th>
                    <th scope="col">الوحده</th>
                    <th scope="col">الكميه</th>
                    <th scope="col">السعر</th>
                    <th scope="col">القيمه</th>
                    <th scope="col">الخصم</th>
                    <th scope="col">الصافي</th>
                    <th scope="col">نسبة الضريبة</th>
                    <th scope="col">قيمة الضريبة</th>
                    <th scope="col">الصافي بعد الضريبة</th>
                </tr>
            </thead>
            <tbody>
                @php
                    $i = 1;
                @endphp
                @foreach ($order->OrderItem()->get() as $item)
                    <tr>
                        <td>{{$item->Product->product_number ?? ''}}</td>
                        <td>{{$item->Product->title ?? ''}}</td>
                        <td>معدة</td>
                        <td>{{$item->quantity}}</td>
                        <td>{{$item->price}}</td>
                        <td>{{$item->price  * $item->quantity}}</td>
                        <td>0</td>
                        <td>{{$item->price  * $item->quantity}}</td>
                        <td>{{getSettingValue('tax')}}</td>
                        <td>{{$tax = ($item->price  * $item->quantity) * ((float)getSettingValue('tax')/100)}}</td>
                        <td>{{$tax + ($item->price  * $item->quantity)}}</td>
                        @php
                            $net = $net + ($tax + ($item->price  * $item->quantity));
                            $original = $original + ($item->price  * $item->quantity);
                        @endphp
                    </tr>
                    @php
                        $i++;
                    @endphp
                @endforeach
            </tbody>
        </table>


        <div class="last " style="margin-top: 0px; border: 1px solid;">
            <div class="flex alig-center">
                <table class="tableR table table-bordered" style="border-radius: 30px; width:50%;">
                    <tr>
                        <td>الاجمالي    Amount</td>
                        <td>{{$original}}</td>
                    </tr>
                    <tr>
                        <td>الخصم      Disount</td>
                        <td>{{$order->discount}}</td>
                    </tr>
                    <tr>
                        <td>الضرائب     VAT 15%</td>
                        <td>{{$tax = $original * ((float)getSettingValue('tax')/100)}}</td>
                    </tr>
                    <tr>
                        <td>الصافي      Net Amount</td>
                        <td>{{$net - $order->discount}}</td>
                    </tr>
                </table>
                {{-- <span class="lbl bold"> اجمالي القيمة : </span>
                <span class="val bold  f-18 "> {{$order->original_total}}</span> --}}
            </div>
            @if ($order->discount && false)
                <div class="flex alig-center">
                    <span class="lbl bold"> اجمالي الخصم : </span>
                    <span class="val bold  f-18 "> {{$order->discount}}</span>
                </div>
                <div class="flex-bt alig-center mx-500">
                    <div class="flex alig-center sub-box ">
                        <span class="lbl bold"> الصافي بعد الخصم : </span>
                        <span class="val bold  f-18 "> </span>
                    </div>
                    <div class="flex alig-center sub-box ">
                        <span class="lbl bold"> خصم اضافى : </span>
                        <span class="val bold  f-18 "> 0</span>
                    </div>

                </div>

            @endif
            {{-- <div class="flex-bt alig-center mx-500">
                <div class="flex alig-center sub-box ">
                    <span class="lbl bold"> اجمالي الضريبة : </span>
                    <span class="val bold  f-18 "> {{$tax = $order->original_total * ((float)getSettingValue('tax')/100)}}</span>
                </div>
                <div class="flex alig-center sub-box ">
                    <span class="lbl bold"> الصافي بعد الضريبة : </span>
                    <span class="val bold  f-18 "> {{$order->total_price}}</span>
                </div>

            </div> --}}
            <div class="total flex">
                {{-- <span> المجوع الكلي مكتوب بالحروف</span> --}}
            </div>
            </div>

        <div class="last ">
            <div class="flex seg">
                <span> البائع</span>
                <span> المستلم</span>


            </div>



        </div>
        @if(0)
        <footer>
            <p> هذة فاتورة يتم انشاؤها اليكترونيا ولا تتطلب توقيع او ختم المورد</p>
            <div class="flex alig-center">
                <div class="scan">
                    <img src="/bill/brc.png" alt="">

                </div>
                <div class="flex-bt alig-center">
                    <div class="ar-box">
                        <div class="bold"> شركة الاومير للتجارة </div>
                        <small> مكان اضافه بيانات الاتصال </small>
                    </div>
                    <div class="e-box">
                        <div>Alomaier Trading And Contracting Co.</div>
                        <small> {{getSettingValue('phone')}}</small>
                        <div class="bold"> {{getSettingValue('email')}}</div>

                    </div>

                </div>

            </div>
        </footer>
        @endif





    </div>




</body>

</html>
