<?php
namespace App\Traits\Admin;

use Illuminate\Http\Request;
use App\Models\Coupon;
use DB;

trait CouponOperations
{
  

    /**
     * Register a New .
     *
     * @param $request
     * @return \App\
     */
    public function register ($request)
    {
        $data = (array)$request->except('_token');
        if ($request->hasFile('image')) {
            $data['image'] = uploadFile($request);
        }
        DB::beginTransaction();
        $Coupon = Coupon::create($data);
        DB::commit();
        return $Coupon;
    }


    /**
     * Update Record
     * @param $truck
     * @param $request
     */
    public function UpdateRecords(Coupon $Coupon,$request)
    {
        $data = $request->all();
        if ($request->hasFile('image')) {
            @unlink(public_path('/cdn/'.$Coupon->image));
            // 
            $data['image'] = uploadFile($request);
        }
        $Coupon->update($data);
        return $Coupon;
    }

    /**
     * delete Record
     * @param $truck
     * @param $request
     */
    public function DeleteRecord($id)
    {
        //
    }
}