<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Carbon\Carbon;

class Order extends Model
{
    protected $table = 'orders';
    protected $fillable = [
        'address', 'latitude', 'longitude', 'user_id', 'total_price', 'status', 'coupon', 'discount', 'original_total', 'gasoline_cost', 'move_cost', 'end_date', 'rent_type',
        'months', 'payment_type', 'transaction_id','payment_response',
    ];
    protected $casts = [
        'latitude' => 'double',
        'longitude' => 'double',
        'created_at' => 'datetime:d/m/Y',
        'updated_at' => 'datetime:d/m/Y',
    ];
    protected $appends = [
        'images',
        'status_txt',
        'start_date'
    ];


    public function Transaction()
    {
        return $this->Hasone(Transaction::class, 'order_id');
    }



    public function OrderImage()
    {
        return $this->Hasmany(OrderImage::class, 'order_id');
    }

    public function OrderLog()
    {
        return $this->Hasmany(OrderLog::class, 'order_id');
    }
    public function OrderRating()
    {
        return $this->Hasmany(OrderRating::class, 'order_id');
    }
    public function OrderItem()
    {
        return $this->Hasmany(OrderItem::class, 'order_id');
    }

    public function DestinationCity()
    {
        return $this->belongsTo(City::class, 'destination_city_id');
    }

    public function SourceCity()
    {
        return $this->belongsTo(City::class, 'source_city_id');
    }

    public function DestinationBranch()
    {
        return $this->belongsTo(Branch::class, 'destination_branch_id');
    }

    public function SourceBranch()
    {
        return $this->belongsTo(Branch::class, 'source_branch_id');
    }

    public function User()
    {
        return $this->belongsTo(User::class, 'user_id');
    }

    public function Driver()
    {
        return $this->belongsTo(Driver::class, 'driver_id');
    }

    public function CarModel()
    {
        return $this->belongsTo(CarModel::class, 'car_model_id');
    }

    public function CarMaker()
    {
        return $this->belongsTo(CarMaker::class, 'car_maker_id');
    }

    public function CarType()
    {
        return $this->belongsTo(CarType::class, 'car_type_id');
    }

    public function ServiceType()
    {
        return $this->belongsTo(ServiceType::class, 'service_type_id');
    }

    public function Files()
    {
        return $this->morphMany(Files::class, 'taggable');
    }
    public function getImagesAttribute()
    {
        return $this->Files()->pluck('name')->toArray();
    }
    public function getStatusTxtAttribute()
    {
        if (Request()->header('lang') == 'ar') {
            return trans('words.'.$this->status);
        }else{
            return trans('wordsen.'.$this->status);
        }
    }
    public function getStartDateAttribute()
    {
        if ($this->OrderItemDay()->orderBy('day_date', 'asc')->first()) {
            return $this->OrderItemDay()->orderBy('day_date', 'asc')->first()->day_date;
        }
        return null;
    }

    /**
     * Get all of the OrderItemDay for the Order
     *
     * @return \Illuminate\Database\Eloquent\Relations\HasManyThrough
     */
    public function OrderItemDay()
    {
        return $this->hasManyThrough(OrderItemDay::class, OrderItem::class);
    }

}
