<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class City extends Model
{
    protected $table = 'cities';
    protected $primaryKey = 'id';
	protected $guarded = ['id'];
    public $sequence = 'xxccs_cities_id_seq';
    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'name_ar', 'name_en', 'id', 'polygon', 'polygon_data', 'latitude', 'longitude'
    ];
    protected $appends = [
        'name',
    ];

    public function getNameAttribute()
    {
        if (Request()->header('lang') == 'en') {
            return $this->name_en;
        }else{
            return $this->name_ar;
        }
    }
    public function Products()
    {
        return $this->Hasmany(ProductCity::class, 'city_id');
    }

}
