<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class BusinessAccount extends Model
{
    protected $table='business_accounts';
    protected $fillable = [
        'user_id', 'company_name', 'phone', 'email', 'registration_number', 'active','image',
    ];

    public function User()
    {
        return $this->belongsTo(User::class,'user_id');
    }
    public function getImageAttribute($img)
    {
        if($img)
        {
            return url('/').'/cdn/'.$img;
        }
        return $img;

    }
}
