<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Branch extends Model
{
    protected $table='branchs';
    protected $fillable = [
        'image', 'name_ar', 'name_en', 'active', 'phone', 'email', 'latitude', 'longitude', 'address'
    ];
    protected $appends = [
        'name',
    ];

    public function getNameAttribute()
    {
        if (Request()->header('lang') == 'en') {
            return $this->name_en;
        }else{
            return $this->name_ar;
        }
    }

    public function products()
    {
        return $this->Hasmany(products::class, 'branch_id');
    }
}
