<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class ProductResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [
                'id'    => $this->id,
                'product_number'    => $this->product_number,
                'title'             => $this->title,
                'model'             => $this->model,
                'skeleton_no'       => $this->skeleton_no,
                'version'           => $this->version,
                'type'              => $this->type,
                'maker_company'     => $this->maker_company,
                'quantity'          => $this->quantity,
                'price'             => $this->price,
                'daily_price'       => $this->daily_price,
                'hour_price'        => $this->hour_price,
                'cities'            => $this->City()->select('cities.id', 'cities.name_ar', 'cities.name_en')->get()->makeHidden(['pivot']),
                'category_id'       => $this->Category()->select('id', 'name_ar', 'name_en')->first(),
                'mission_id'        => $this->Mission()->select('id', 'name_ar', 'name_en')->first(),
                'works'             => $this->works,
                'description'       => $this->description,
                'color'             => $this->color,
                'active'            => $this->active,
                'gasoline'          => $this->gasoline,
                'branch_id'         => $this->Branch()->select('id', 'name_ar', 'name_en')->first(),
                'year'              => $this->Year->name ?? '',
        ];
    }
}
