<?php

namespace App\Http\Resources;

use Carbon\Carbon;
use Illuminate\Http\Resources\Json\JsonResource;

class CartItemResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        $item = $this;
        $product = $item->Product()->first();
        $total_price = 0;
        if ($item->product_type == 'rent') {
            //
            if ($item->rent_type == 'day') {
                $total_price += $item->CartItemDay()->count() * $product->daily_price;
            } else if ($item->rent_type == 'month') {
                $total_price += $item->months * $product->price;
                // dd($item->months);
            } else {
                if ($item->CartItemDay()->first()) {

                    $from = Carbon::createFromFormat('Y-m-d H:s:i', $item->CartItemDay()->first()->day_date . ' ' . $item->CartItemDay()->first()->time_from);
                    $to = Carbon::createFromFormat('Y-m-d H:s:i', $item->CartItemDay()->first()->day_date . ' ' . $item->CartItemDay()->first()->time_to);
                    $diff_in_hours = $to->diffInHours($from);
                    $total_price += $diff_in_hours * $product->hour_price;
                }
            }

        }else{
            $total_price +=  $item->Product->price;
        }
        $total_price = $item->quantity * $total_price;
        return [
            'id' => $this->id,
            'product_id' => $product->id,
            'product_title' => $product->title,
            'product_image' => $product->image,
            'quantity' => $this->quantity,
            'rent_type' => $this->rent_type,
            'months' => $this->months,
            'days' => $this->CartItemDay()->count(),
            'hours' => @$diff_in_hours,
            'city_id' => $this->city_id,
            'city_name' => $this->City->name ?? '',
            'latitude' => $this->latitude,
            'longitude' => $this->longitude,
            'move_cost' => PriceWithVat($this->move_cost),
            'gasoline_cost' => PriceWithVat($this->gasoline_cost),
            'housing_cost' => PriceWithVat($this->housing_cost),
            'product_price' => round($total_price,2) ,
            'item_total' => $total_price +PriceWithVat( ($this->move_cost ?? 0) + ($this->gasoline_cost ?? 0) + ($this->housing_cost ?? 0) ),
        ];
    }
}
