<?php
namespace App\Http\Requests;
use Illuminate\Http\JsonResponse;
use Illuminate\Validation\ValidationException;
use Illuminate\Contracts\Validation\Validator;
use Illuminate\Http\Exceptions\HttpResponseException;
use Illuminate\Foundation\Http\FormRequest as LaravelFormRequest;
abstract class ApiFormRequest extends LaravelFormRequest
{
    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    abstract public function rules();
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    abstract public function authorize();
    /**
     * Handle a failed validation attempt.
     *
     * @param  \Illuminate\Contracts\Validation\Validator  $validator
     * @return void
     *
     * @throws \Illuminate\Validation\ValidationException
     */
    protected function failedValidation(Validator $validator)
    {
        // $errors = (new ValidationException($validator))->errors();
        // throw new HttpResponseException(response()->json(['errors' => $errors
        // ], JsonResponse::HTTP_UNPROCESSABLE_ENTITY));
        $errors = (new ValidationException($validator))->errors();
        throw new HttpResponseException(response()->json([
            'data'  => new \stdClass,
            'errors' => $validator->errors()->all(),
            'message'   => implode(' , ', $validator->errors()->all()),
            'code'      => getMsgCode('validationErrors')
        ], 200));
    }
}