<?php

namespace App\Http\Controllers;

use App\Http\Resources\ProductResource;
use App\Models\Order;
use App\Models\OrderItem;
use App\Models\Product;
use App\Models\ProductCity;
use App\Models\Year;
use Illuminate\Http\Request;
use Validator;

class ServiceController extends Controller
{
    public function __construct()
    {
        // if (!Request()->header('apikey') || Request()->header('apikey') != 'Asdsdwqjk4562EW55') {
        //     return response()->json([
        //         'data' => [
        //             'message' => 'wrong apikey',
        //             'code' => 100
        //         ]
        //     ], 200);
        // }
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $products = Product::latest()->paginate(24);
        $products->data = ProductResource::collection($products);
        return response()->json([
            'data' => [
                'products' => $products,
                'code' => 200
            ]
        ], 200);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $rules = [
                'product_number'    => 'required|unique:products',
                'title'             => 'required',
                'model'             => 'required',
                'skeleton_no'        => 'required',
                'version'           => 'required',
                'type'              => 'required',
                'maker_company'     => 'required',
                'quantity'          => 'required',
                'price'             => 'required',
                'daily_price'       => 'required',
                'hour_price'        => 'required',
                // 'cities'            => 'required',
                'category_id'       => 'required',
                'mission_id'        => 'required',
                'works'             => 'required',
                'description'       => 'required',
                'color'             => 'required',
                'active'            => 'required',
                'gasoline'          => 'required',
                'branch_id'         => 'required',
                'year'              => 'required',

        ];
        $validator = Validator::make($request->all(), $rules);
        if ($validator->fails()) {
            return response()->json([
                'data' => [
                    'errors' => $validator->errors()->all(),
                    'message'   => implode(' , ', $validator->errors()->all()),
                    'code' => 400
                ]
            ], 200);
        }
        $data = $request->all();
        if(Year::where('name','LIKE', "%$request->get('year')%")->first())
        {
            $yearID = Year::where('name','LIKE', "%$request->get('year')%")->first()->id;

        }else{
            $row2 = Year::create(['name' => $request->get('year') ]);
            $yearID = $row2->id;
        }
        $data['year_id'] = $yearID;
        // $path = 'products/'.$request->product_number.'/';
        // // dd($path);
        // if ($request->hasFile('images') ) {
        //     foreach ($request->file('images') as $image) {
        //         $data2['name'] = uploadImage($image, $path);
        //         $Product->Files()->create($data2);
        //     }
        // }

        if ($request->has('active') && $data['active'] == '1') {
            $data['active'] = '1';
        }else{
            $data['active'] = '0';

        }
        $Product = Product::create($data);
        if ($request->has('cities') ) {
            foreach ($request->get('cities') as $key => $it) {
                    $Product->ProductCity()->create(['city_id' => $it, 'cost' => @$request->get('move_cost')[$key] ]);
            }
        }
        $Product = new ProductResource($Product);
        return Response()->json([
            'data'          => [
                'product'  => $Product,
            ],
            'message'       => 'product details',
            'code'          => getMsgCode('success'),
        ]);
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $Product = Product::where('product_number', $id)->first();
        if (!$Product) {
            return Response()->json([
            'data'          => [
            ],
            'message'       => 'product not found',
            'code'          => 404,
        ]);
        }
        $Product = new ProductResource($Product);
        return Response()->json([
            'data'          => [
                'product'  => $Product,
            ],
            'message'       => 'product details',
            'code'          => getMsgCode('success'),
        ]);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $rules = [
            'product_number'    => 'nullable|unique:products,product_number,'.$id,
            'title'             => 'nullable',
            'model'             => 'nullable',
            'skeleton_no'        => 'nullable',
            'version'           => 'nullable',
            'type'              => 'nullable',
            'maker_company'     => 'nullable',
            'quantity'          => 'nullable',
            'price'             => 'nullable',
            'daily_price'       => 'nullable',
            'hour_price'        => 'nullable',
            // 'cities'            => 'nullable',
            'category_id'       => 'nullable',
            'mission_id'        => 'nullable',
            'works'             => 'nullable',
            'description'       => 'nullable',
            'color'             => 'nullable',
            'active'            => 'nullable',
            'gasoline'          => 'nullable',
            'branch_id'         => 'nullable',
            'year'              => 'nullable',

    ];
    $validator = Validator::make($request->all(), $rules);
    if ($validator->fails()) {
        return response()->json([
            'data' => [
                'errors' => $validator->errors()->all(),
                'message'   => implode(' , ', $validator->errors()->all()),
                'code' => 400
            ]
        ], 200);
    }
        $Product = Product::where('product_number', $id)->first();
        if (!$Product) {
            return Response()->json([
            'data'          => [
            ],
            'message'       => 'product not found',
            'code'          => 404,
        ]);
        }
        $data = $request->all();
        if ($request->has('year')) {
            if(Year::where('name','LIKE', "%$request->get('year')%")->first())
            {
                $yearID = Year::where('name','LIKE', "%$request->get('year')%")->first()->id;

            }else{
                $row2 = Year::create(['name' => $request->get('year') ]);
                $yearID = $row2->id;
            }
            $data['year_id'] = $yearID;

        }
        // $path = 'products/'.$request->product_number.'/';
        // // dd($path);
        // if ($request->hasFile('images') ) {
        //     foreach ($request->file('images') as $image) {
        //         $data2['name'] = uploadImage($image, $path);
        //         $Product->Files()->create($data2);
        //     }
        // }

        if ($request->has('active')) {
            if ($data['active'] == '1') {
                $data['active'] = '1';
            }else{
                $data['active'] = '0';
            }
        }

        if ($request->has('cities') ) {
            $Product->ProductCity()->delete();
            foreach ($request->get('cities') as $it) {
                $Product->ProductCity()->create(['city_id' => $it]);
            }
        }
        $Product->update($data);
        $Product = new ProductResource($Product);
        return Response()->json([
            'data'          => [
                'product'  => $Product,
            ],
            'message'       => 'product details',
            'code'          => getMsgCode('success'),
        ]);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $product = Product::where('product_number', $id)->first();
        if (!$product) {
            return Response()->json([
            'data'          => [
            ],
            'message'       => 'product not found',
            'code'          => 404,
        ]);
        }
         // if ($product->image) {
            @unlink(public_path('/cdn/'.$product->image));
            // @unlink(public_path('/cdn/'.$product->product_number.'/'.$product->image));
            $dirPath = public_path('/cdn/products/'.$product->product_number);
            $files = glob("cdn/products/".$product->product_number."/*.{jpg,png,gif,jpeg}", GLOB_BRACE);
            foreach ($files as $file) {
                // dd($file);
                    @unlink(public_path($file));
            }
            @rmdir($dirPath);
        // }
        $product->delete();
        return Response()->json([
            'data'          => [
            ],
            'message'       => 'deleted',
            'code'          => getMsgCode('success'),
        ]);
    }

    public function deleteArray(Request $request)
    {
        $numbers = $request->get('ids');
        foreach ($numbers as $id) {
            $this->destroy($id);
        }
        return Response()->json([
            'data'          => [
            ],
            'message'       => 'array deleted',
            'code'          => getMsgCode('success'),
        ]);
    }
    public function clear(Request $request)
    {
        OrderItem::whereNotNull('id')->delete();
        Order::whereNotNull('id')->delete();
        ProductCity::whereNotNull('id')->delete();
        Product::whereNotNull('id')->delete();
        $dirPath = public_path('/cdn/products');
        // @rmdir($dirPath);
        return Response()->json([
            'data'          => [
            ],
            'message'       => 'cleared',
            'code'          => getMsgCode('success'),
        ]);
    }
}
