<?php

namespace App\Http\Controllers\Api;

use App\Http\Requests\Admin\UpdateProductRequest;
use App\Http\Requests\Admin\StoreProductRequest;
use App\Http\Controllers\Controller;
use App\Traits\Api\ProductOperations;
use Illuminate\Http\Request;
use App\Models\Admin;
use App\Models\Product;
use Auth;
use Validator;
use Maatwebsite\Excel\Facades\Excel;

class ProductController extends Controller
{
    use ProductOperations;

    public function index()
    {
        $user = auth('api')->user();
        $products = $user->Product()->get();
        return Response()->json([
            'data'          => [
                'products'  => $products,
            ],
            'message'       => 'success',
            'code'          => getMsgCode('success'),
        ]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        // return $request->all();
        $product = $this->register($request);
        $product = Product::find($product->id);
        return Response()->json([
            'data'          => [
                'product'  => $product,
            ],
            'message'       => 'success',
            'code'          => getMsgCode('success'),
        ]);
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $user = auth('api')->user();
        $product = $user->Product()->find($id);
        $related = Product::where('active', '1')->limit(6)->get();
        return Response()->json([
            'data'          => [
                'product'  => $product,
                'related'  => $related,
            ],
            'message'       => 'success',
            'code'          => getMsgCode('success'),
        ]);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $user = auth('api')->user();
        $product = $user->Product()->find($id);
        $this->UpdateRecords($product, $request);
        return Response()->json([
            'data'          => [
                'product'  => $product,
            ],
            'message'       => 'success',
            'code'          => getMsgCode('success'),
        ]);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $user = auth('api')->user();
        $product = $user->Product()->find($id);
        $product->delete();
        return Response()->json([
            'data'          => [ ],
            'message'       => 'success',
            'code'          => getMsgCode('success'),
        ]);
    }
}
