<?php

namespace App\Http\Controllers\Api;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\User;
use App\Models\Setting;
use App\Models\Category;
use App\Models\City;
use App\Models\Branch;
use App\Models\CarMaker;
use App\Models\CarType;
use App\Models\ServiceType;
use App\Models\PriceList;
use App\Models\Order;
use App\Models\OrderLog;
use Auth;
use DB;
use App\Traits\Api\OrderOperations;
use App\Notifications\GeneralNotification;
use App\Models\Admin;
use App\Notifications\AdminNotification;

class DriverOrderController extends Controller
{

    use OrderOperations;

    public function index()
    {
        $driver = auth('driver-api')->user();
        $old_orders = OrderLog::where('key', 'driver_assigned')
                                ->where('key_id', $driver->id)
                                ->whereNotIn('order_id', $driver->Order()->pluck('id')->toArray() )
                                ->pluck('order_id')->toArray();
        $previous = Order::whereIn('id', $old_orders)
                        ->with('CarType')
                        ->with('CarMaker')
                        ->with('CarModel')
                        ->with('CarColor')
                        ->with('ServiceType')
                        ->with('User')
                        ->with('Driver')
                        ->with('SourceCity')
                        ->with('DestinationCity')
                        ->with('SourceBranch')
                        ->with('DestinationBranch')
                        ->latest()
                        ->get();
        $current = $driver->Order()
                        ->with('CarType')
                        ->with('CarMaker')
                        ->with('CarModel')
                        ->with('CarColor')
                        ->with('ServiceType')
                        ->with('User')
                        ->with('Driver')
                        ->with('SourceCity')
                        ->with('DestinationCity')
                        ->with('SourceBranch')
                        ->with('DestinationBranch')
                        ->latest()
                        ->get();
        return Response()->json([
                'data' => [
                    'previous_orders' => $previous,
                    'current_orders' => $current,
                ],
                'message' => 'success',
                'code' => getMsgCode('success')
        ]);
    }



    public function update(Request $request, $id)
    {
        $driver = auth('driver-api')->user();
        $order = $driver->Order()->findOrfail($id);
        $order->update( $request->all() );
        if ($request->has('images')) {
            $order->OrderImage()->delete();
            foreach ($request->images as $image) {
                // $image = uploadImage($image);
                $order->OrderImage()->create(['image' => $image]);
            } 
        }
        if ($request->has('status') && $request->get('status') != 'init' && $request->get('status') != '') {
            DB::beginTransaction();
            // check order type start
            if ($order->order_type == 'external' && $request->get('status') == 'finished') {
                $pricelist = PriceList::where('from_city_id', $order->source_city_id)
                                        ->where('to_city_id', $order->destination_city_id)
                                        ->where('car_type_id', $order->car_type_id)
                                        ->first();
                $driver->DriverPayment()->create([
                    'order_id' => $order->id,
                    'amount' => $pricelist->not_employee_price,
                    'type' => 'income'
                ]);
            }
            // check order type end
             // send notification
        $notifiable = $order->User()->first();
        if( $notifiable->lang == 'ar')
            {
                $title = " الطلب #"  . $order->id;
                $content = "تم تعديل حالة الطلب الي ". ' '.trans('words.'.$request->status) ;

            }else{
                $title = " Order #".$order->id;
                $content = " Order status has been changed to ".OrderStatusEn($request->status);
            }
        $type = "order_details";
        
        $title_ar = " الطلب #"  . $order->id;
        $content_ar = "تم تعديل حالة الطلب الي ". ' '.trans('words.'.$request->status) ;
        $title_en = " Order #".$order->id;
        $content_en = " Order status has been changed to ".OrderStatusEn($request->status);
        $activity = "order_details";
        $data2 = [
            'order' => $order,
            'title_ar' => $title_ar,
            'title_en' => $title_en,
            'content_ar' => $content_ar,
            'content_en' => $content_en,
            'type' => $type,
        ];
        $token = $notifiable->PlayerId()->pluck('player_id')->toArray();
        FCMController::Push($title, $content,$token,$data2);
        $notifiable->notify(new GeneralNotification($title, $content, $type, $data2, $activity) );
        // send notification to admin start
        $admin = Admin::first();
        $admin->notify(new AdminNotification($content_ar, route('orders.show', $order->id)));
        // send notification to admin end
        // send notification end
            
        }
       
        $driver->OrderLog([
            'created_by_type' => 'driver',
            'order_id' => $order->id,
            'notes' => $request->get('notes'), 
            'key' => 'driver_log', 
        ]);
        DB::commit();
        // $order = $this->register($request, $driver);
        return Response()->json([
            'data' => [
                'order' => $order,
            ],
            'message' => 'success',
            'code' => getMsgCode('success')
        ]);
    }

    public function show(Request $request, $id)
    {
        $driver = auth('driver-api')->user();
        $order = Order::where('id',$id)
                        ->with('CarType')
                        ->with('CarMaker')
                        ->with('CarModel')
                        ->with('CarColor')
                        ->with('ServiceType')
                        ->with('User')
                        ->with('Driver')
                        ->with('SourceCity')
                        ->with('DestinationCity')
                        ->with('SourceBranch')
                        ->with('DestinationBranch')
                        ->first();
        return Response()->json([
            'data' => [
                'order' => $order,
            ],
            'message' => 'success',
            'code' => getMsgCode('success')
        ]);
    }
    
    public function accept(Request $request, $id)
    {
        $driver = auth('driver-api')->user();
        $order = Order::where('id',$id)
                        ->first();
        if ($order->driver_id) {
            if (Request()->header('lang') == 'ar') {
                $message = 'هذا الطلب اصبح غير متاح';
            }else{
                $message = 'Order is no longer available';
            }
            return Response()->json([
                'data' => new \stdClass,
                'errors' => ['order not available'],
                'message' => $message,
                'code' => getMsgCode('somethingWrong')
            ]);
        }
        $order->update(['status' => 'processing']);
        $order->OrderLog()->create([
                'created_by_type' => 'driver',
                'created_by_id' => $driver->id,
                'key' => 'driver_assigned',
                'key_id' => $driver->id,
                'notes' => trans('words.driver has been assigned by', ['by_name' => 'his self', 'driver_name' => $driver->name ]),
            ]);
            if( $driver->lang == 'ar')
                {
                    $title = "الطلب #". $order->id;
                    $content = "جاري استلام الطلب";

                }else{
                    $title = "Order #". $order->id;
                    $content = "Your order is processing .";
                }
                $type = "order_assign_driver";
                
                $title_ar = "الطلب #". $order->id;
                $title_en = "Order #". $order->id;
                $content_ar = "جاري استلام الطلب";
                $content_en = "Your order is processing .";
                $activity = "order_details";
                $data2 = [
                    'order' => $order,
                    'title_ar' => $title_ar,
                    'title_en' => $title_en,
                    'content_ar' => $content_ar,
                    'content_en' => $content_en,
                    'type' => $type,
                ];
                $notifiable = $order->User()->first();
                $token = $notifiable->PlayerId()->pluck('player_id')->toArray();
                FCMController::Push($title, $content,$token,$data2);
                $notifiable->notify(new GeneralNotification($title, $content, $type, $data2, $activity) );
                
                // send notification to admin start
                $admin = Admin::first();
                $admin->notify(new AdminNotification($content_ar . $order->id , route('orders.show', $order->id)));
                // send notification to admin end
                // send notification end
        $order->update(['driver_id' => $driver->id ]);
        if ($driver->type == 'not_employee') {
            $order->update(['order_type' => 'external']);
            
        }
        if (Request()->header('lang') == 'ar') {
            $message = 'تم الحصول علي الطلب';
        }else{
            $message = 'Order assigned to You';
        }
        return Response()->json([
            'data' => [
                'order' => $order,
            ],
            'message' => $message,
            'code' => getMsgCode('success')
        ]);
    }

}
