<?php

namespace App\Http\Controllers\Api;

use App\Mail\Api\UserVerify as UserVerifyMail;
use App\Http\Requests\Api\StoreDriverRequest;
use App\Mail\Api\UserForgetPasswordMail;
use App\Http\Requests\Api\LoginRequest;
use App\Http\Requests\Api\DriverSignupRequest;
use App\Http\Controllers\Controller;
use App\Traits\Api\DriverOperations;
use Illuminate\Http\Request;
use App\Models\UserVerify;
use App\Models\Driver;
use Carbon\Carbon;
use Auth;
use Mail;
use Tymon\JWTAuth\Facades\JWTAuth;
use App\Models\Admin;
use App\Notifications\AdminNotification;

class DriverController extends Controller
{
    use DriverOperations;

    public function login(LoginRequest $request)
    {
        
            // $code = $request->get('code');
            $email = $request->get('email');
            $password = $request->get('password');
            $phone = $request->get('phone');
            if ($request->has('phone')) {
                $credentials = ['phone' => $phone];
                // check user
                $driver = Driver::where('phone', $phone)->first();
                if(!$driver)
                {
                    return Response()->json([
                        'data'          => new \stdClass,
                        'errors'        => '',
                        'message'       => 'authFailed',
                        'code'          => getMsgCode('authFailed'),
                    ]);
                }
                if($driver)
                {
                    $token=JWTAuth::fromUser($driver);
                    if(Request()->has('player_id') && !$driver->PlayerId()->where('player_id', '=', $request->get('player_id'))->first() )
                    {
                        $driver->PlayerId()->create(['player_id' => $request->player_id]);
                    }
                    $driver->token = $token;
                    return Response()->json([
                            'data'          => [
                                'driver'  => $driver,
                                // 'token'  => $token
                            ],
                            'message'       => 'success',
                            'code'          => getMsgCode('success'),
                        ]);
                }
            }else{
                return Response()->json([
                    'data'          => new \stdClass,
                    'message'       => 'somethingWrong',
                    'code'          => getMsgCode('somethingWrong'),
                ]);
            }
            
    }

    public function signup(DriverSignupRequest $request)
    {
        $driver = $this->register($request);
        $driver = Driver::find($driver->id);
        if($driver)
        {
            $token=JWTAuth::fromUser($driver);
            if(Request()->has('player_id') && !$driver->PlayerId()->where('player_id', '=', $request->get('player_id'))->first() )
            {
                $driver->PlayerId()->create(['player_id' => $request->player_id]);
            }
            $driver->token = $token;
            return Response()->json([
                    'data'          => [
                        'driver'  => $driver,
                        // 'token'  => $token
                    ],
                    'message'       => 'success',
                    'code'          => getMsgCode('success'),
                ]);
        }
            
    }

    public function ContinueInfo(Request $request)
    {
        $driver = Auth::guard('driver-api')->user();
        $data = $request->all();
        if ($request->has('image') && $request->get('image') != '') {
            $driver->update(['image' => $request->get('image')]);
        }
        $info = $driver->DriverInfo()->first();
        
        if ($info) {
            $info->update($data);
        } else {
            $driver->DriverInfo()->create($data);
        }
        // $driver->update(['reviewed'=>1]);
        $driver->token = auth('driver-api')->tokenById($driver->id);
        
        // send notification to admin start
        $admin = Admin::first();
        $admin->notify(new AdminNotification(' تم اتمام بيانات السائق  ' . $driver->name , route('drivers.show', $driver->id)));
        // send notification to admin end
        
        return Response()->json([
                'data'          => [
                    'driver'  => $driver,
                    // 'token'  => $token
                ],
                'message'       => 'driver_not_reviewed',
                'code'          => getMsgCode('driver_not_reviewed'),
            ]);
            
    }

    public function logout()
    {
        $driver = Auth::guard('driver-api')->user();
        if (Request()->has('player_id')) {
            $driver->PlayerId()->where('player_id', '=', Request()->get('player_id'))->delete();
        }
        return Response()->json([
            'data'          => new \stdClass,
            'message'       => 'success',
            'code'          => getMsgCode('success'),
        ]);
    }

     
    public function update(Request $request)
    {
        $driver = Auth::guard('driver-api')->user();
        $this->UpdateRecords($driver, $request);
        $driver = Driver::find($driver->id);
        if($driver->image)
        {
            // $driver->image = url('/').'/cdn/'.$driver->image;
        }
        $driver->token = auth('driver-api')->tokenById($driver->id);
        return Response()->json([
                'data' => [
                    'driver' => $driver
                ],
                'message' => 'success',
                'code' => getMsgCode('success')
        ]);
    }
    public function profile(Request $request)
    {
        $driver = Auth::guard('driver-api')->user();
        
        return Response()->json([
                'data' => [
                    'driver' => $driver
                ],
                'message' => 'success',
                'code' => getMsgCode('success')
        ]);
    }
      

    public function show(Request $request)
    {
        $driver_id = Request()->get('driver_id');
        $driver = Driver::find($driver_id);
        if($driver->image)
        {
            // $driver->image = url('/').'/cdn/'.$driver->image;
        }
        $rate = 0;
        try {
            $rate = ($driver->MyRate()->sum('value') / $driver->MyRate()->count());
        } catch (\Exception $e) {
            $rate = 0;
        }
        $driver->rate = $rate;
        return Response()->json([
                'data' => [
                    'driver' => $driver
                ],
                'message' => 'success',
                'code' => getMsgCode('success')
        ]);
    }
 

    public function notifications(Request $request)
    {
        $user = Auth::guard('driver-api')->user();
        $notifications  = $user->unreadnotifications->pluck('data');
        // return $notifications;
        return Response()->json([
                'data' => [
                    'notifications' => $notifications
                ],
                'message' => 'success',
                'code' => getMsgCode('success')
        ]);
    } 

}
