<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Admin;
use App\Models\ProductCity;
use Auth;

class ProductCityController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */

    public function __construct()
    {
    }
    public function index()
    {
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $title = 'اضافة مدينة';
        $product_id = Request()->get('product_id');
        return view('admin.product-cities.add', compact('title', 'product_id'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $request->validate([
            'city_id' => 'required',
            'product_id' => 'required',
            'cost' => 'required'
        ]);
        ProductCity::create($request->all());
        return redirect()->back()->with('success', 'data added successfully');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show(ProductCity $ProductCity)
    {
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $row = ProductCity::find($id);
        $title = 'تعديل مدينة';
        return view('admin.product-cities.edit', compact('row', 'title'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, ProductCity $ProductCity)
    {
        $request->validate([
            'city_id' => 'required',
            'cost' => 'required'
        ]);
        // $ProductCity = ProductCity::find($id);
        $ProductCity->update($request->all());
        return redirect()->back()->with('success', 'data added successfully');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(ProductCity $ProductCity)
    {
        if ($ProductCity->image) {
            @unlink(public_path('/cdn/'.$ProductCity->image));
        }
        $ProductCity->delete();
        return 'success';
    }
}
