<?php

namespace App\Http\Controllers\Admin;

use App\Http\Requests\Admin\UpdateOrderRequest;
use App\Http\Requests\Admin\StoreOrderRequest;
use App\Http\Controllers\Controller;
use App\Traits\Admin\CompanyOrderOperations;
use Illuminate\Http\Request;
use App\Models\Admin;
use App\Models\Order;
use App\Models\Bus;
use App\Models\CompanyOrder;
use Auth;
use Validator;
use Maatwebsite\Excel\Facades\Excel;

class CompanyOrderController extends Controller
{
    use CompanyOrderOperations;
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */

    public function __construct()
    {
        // $this->middleware('Permission:Order_show'    , ['only' => 'index', 'show']);
        // $this->middleware('Permission:Order_add'     , ['only' => 'create', 'store']);
        // $this->middleware('Permission:Order_edit'    , ['only' => 'edit', 'update']);
        // $this->middleware('Permission:Order_delete'  , ['only' => 'destroy']);
    }

    



    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
 

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */


    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show( $id)
    {
        $company_order = CompanyOrder::find($id);
        $title = 'عرض طلب';
        return view('admin.company_orders.show', compact('company_order', 'title'));
    }
    public function OrderInfo($id)
    {
        $company_order = CompanyOrder::find($id);
        $title = 'عرض طلب';
        return view('admin.company_orders.ajax_data', compact('company_order', 'title'))->render();
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $title = 'تعديل طلب';
        $company_order = CompanyOrder::find($id);
        return view('admin.company_orders.edit', compact('company_order', 'title'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(UpdateOrderRequest $request, $id)
    {
        $company_order = CompanyOrder::find($id);
        $this->UpdateRecords($company_order, $request);
        return redirect('/dashboard/orders')->with('success', 'data added successfully');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(CompanyOrder $company_order)
    {
        if ($company_order->image) {
            @unlink(public_path('/cdn/'.$company_order->image));
        }
        $company_order->CompanyOrderItem()->delete();
        $company_order->delete();
        return 'success';
    }
}
